/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.SymbolTable;
import tla2sany.st.TreeNode;
import tla2sany.xml.SymbolContext;
import util.UniqueString;

public class FormalParamNode
extends SymbolNode {
    private int arity;
    private ModuleNode moduleNode;

    public FormalParamNode(UniqueString us, int ar, TreeNode stn, SymbolTable symbolTable, ModuleNode mn) {
        super(11, stn, us);
        this.arity = ar;
        this.moduleNode = mn;
        if (symbolTable != null) {
            symbolTable.addSymbol(us, this);
        }
    }

    @Override
    public final int getArity() {
        return this.arity;
    }

    @Override
    public final boolean isLocal() {
        return true;
    }

    public final ModuleNode getModuleNode() {
        return this.moduleNode;
    }

    @Override
    public final boolean match(OpApplNode test, ModuleNode mn) {
        SymbolNode odn = test.getOperator();
        return odn.getArity() == this.arity;
    }

    public final boolean match(SemanticNode test) {
        return this.arity == 0;
    }

    @Override
    public final boolean levelCheck(int iter) {
        if (this.levelChecked == 0) {
            this.levelChecked = iter;
            this.levelParams.add(this);
            this.allParams.add(this);
        }
        return true;
    }

    @Override
    public final void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        Integer uid = this.myUID;
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        visitor.preVisit(this);
        visitor.postVisit(this);
    }

    @Override
    public final String toString(int depth) {
        if (depth <= 0) {
            return "";
        }
        return "\n*FormalParamNode: " + this.getName().toString() + "  " + super.toString(depth) + "  arity: " + this.arity;
    }

    @Override
    protected String getNodeRef() {
        return "FormalParamNodeRef";
    }

    @Override
    protected Element getSymbolElement(Document doc, SymbolContext context) {
        Element e = doc.createElement("FormalParamNode");
        e.appendChild(this.appendText(doc, "uniquename", this.getName().toString()));
        e.appendChild(this.appendText(doc, "arity", Integer.toString(this.getArity())));
        return e;
    }
}

