/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tlc2.tool.ITool;
import tlc2.tool.TLCState;
import tlc2.tool.liveness.LNAll;
import tlc2.tool.liveness.LNBool;
import tlc2.tool.liveness.LNConj;
import tlc2.tool.liveness.LNEven;
import tlc2.tool.liveness.LiveExprNode;
import tlc2.tool.liveness.TBPar;
import tlc2.util.Vect;

class LNDisj
extends LiveExprNode {
    private final Vect<LiveExprNode> disjs;
    private int info;

    public LNDisj(int size) {
        this.disjs = new Vect(size);
        this.info = 0;
    }

    public LNDisj(LiveExprNode n) {
        this.disjs = new Vect(1);
        this.disjs.addElement(n);
        int level = n.getLevel();
        this.info = n.containAction() ? level + 8 : level;
    }

    public LNDisj(LiveExprNode n1, LiveExprNode n2) {
        this.disjs = new Vect(2);
        this.disjs.addElement(n1);
        this.disjs.addElement(n2);
        boolean hasAct = n1.containAction() || n2.containAction();
        int level = Math.max(n1.getLevel(), n2.getLevel());
        this.info = hasAct ? level + 8 : level;
    }

    public LNDisj(Vect<LiveExprNode> disjs) {
        this.disjs = disjs;
        boolean hasAct = false;
        int level = 0;
        for (int i = 0; i < disjs.size(); ++i) {
            LiveExprNode lexpr = disjs.elementAt(i);
            level = Math.max(level, lexpr.getLevel());
            hasAct = hasAct || lexpr.containAction();
        }
        this.info = hasAct ? level + 8 : level;
    }

    public final int getCount() {
        return this.disjs.size();
    }

    public final LiveExprNode getBody(int i) {
        return this.disjs.elementAt(i);
    }

    public final void addDisj(LiveExprNode elem) {
        if (elem instanceof LNDisj) {
            LNDisj elem1 = (LNDisj)elem;
            for (int i = 0; i < elem1.getCount(); ++i) {
                this.addDisj(elem1.getBody(i));
            }
        } else {
            this.disjs.addElement(elem);
        }
        int level = Math.max(this.getLevel(), elem.getLevel());
        boolean hasAct = this.containAction() || elem.containAction();
        this.info = hasAct ? level + 8 : level;
    }

    @Override
    public final int getLevel() {
        return this.info & 7;
    }

    @Override
    public final boolean containAction() {
        return (this.info & 8) > 0;
    }

    @Override
    public final boolean eval(ITool tool, TLCState s1, TLCState s2) {
        int sz = this.disjs.size();
        for (int i = 0; i < sz; ++i) {
            LiveExprNode item = this.disjs.elementAt(i);
            if (!item.eval(tool, s1, s2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void toString(StringBuffer sb, String padding) {
        int len = this.getCount();
        String padding1 = padding + "    ";
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                sb.append(padding);
            }
            sb.append("\\/ (");
            this.getBody(i).toString(sb, padding1);
            sb.append(")");
            if (i == len - 1) continue;
            sb.append("\n");
        }
    }

    @Override
    public String toDotViz() {
        int len = this.getCount();
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            sb.append("\\/ (");
            sb.append(this.getBody(i).toDotViz());
            sb.append(")");
            if (i == len - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public void extractPromises(TBPar promises) {
        this.getBody(0).extractPromises(promises);
        this.getBody(1).extractPromises(promises);
    }

    @Override
    public int tagExpr(int tag) {
        for (int i = 0; i < this.getCount(); ++i) {
            tag = this.getBody(i).tagExpr(tag);
        }
        return tag;
    }

    @Override
    public final LiveExprNode makeBinary() {
        if (this.getCount() == 1) {
            return this.getBody(0).makeBinary();
        }
        int mid = this.getCount() / 2;
        LNDisj left = new LNDisj(0);
        LNDisj right = new LNDisj(0);
        for (int i = 0; i < this.getCount(); ++i) {
            if (i < mid) {
                left.addDisj(this.getBody(i));
                continue;
            }
            right.addDisj(this.getBody(i));
        }
        return new LNDisj(left.makeBinary(), right.makeBinary());
    }

    @Override
    public LiveExprNode flattenSingleJunctions() {
        if (this.getCount() == 1) {
            return this.getBody(0).flattenSingleJunctions();
        }
        LNDisj lnd2 = new LNDisj(this.getCount());
        for (int i = 0; i < this.getCount(); ++i) {
            lnd2.addDisj(this.getBody(i).flattenSingleJunctions());
        }
        return lnd2;
    }

    @Override
    public final LiveExprNode toDNF() {
        LNDisj aeRes = new LNDisj(0);
        LNDisj res = new LNDisj(0);
        for (int i = 0; i < this.getCount(); ++i) {
            LiveExprNode elem = this.getBody(i).toDNF();
            if (elem instanceof LNDisj) {
                LNDisj disj1 = (LNDisj)elem;
                for (int j = 0; j < disj1.getCount(); ++j) {
                    LiveExprNode elem1 = disj1.getBody(j);
                    LiveExprNode elemBody = elem1.getAEBody();
                    if (elemBody == null) {
                        res.addDisj(elem1);
                        continue;
                    }
                    aeRes.addDisj(elemBody);
                }
                continue;
            }
            LiveExprNode elemBody = elem.getAEBody();
            if (elemBody == null) {
                res.addDisj(elem);
                continue;
            }
            aeRes.addDisj(elemBody);
        }
        if (aeRes.getCount() == 1) {
            res.addDisj(new LNAll(new LNEven(aeRes.getBody(0))));
        } else if (aeRes.getCount() > 1) {
            res.addDisj(new LNAll(new LNEven(aeRes)));
        }
        return res;
    }

    @Override
    public LiveExprNode simplify() {
        LNDisj lnd1 = new LNDisj(this.getCount());
        for (int i = 0; i < this.getCount(); ++i) {
            LiveExprNode elem = this.getBody(i).simplify();
            if (elem instanceof LNBool) {
                if (!((LNBool)elem).b) continue;
                return LNBool.TRUE;
            }
            lnd1.addDisj(elem);
        }
        if (lnd1.getCount() == 0) {
            return LNBool.FALSE;
        }
        if (lnd1.getCount() == 1) {
            return lnd1.getBody(0);
        }
        return lnd1;
    }

    @Override
    public boolean isGeneralTF() {
        for (int i = 0; i < this.getCount(); ++i) {
            if (this.getBody(i).isGeneralTF()) continue;
            return false;
        }
        return super.isGeneralTF();
    }

    @Override
    public LiveExprNode pushNeg() {
        LNConj lnc = new LNConj(this.getCount());
        for (int i = 0; i < this.getCount(); ++i) {
            lnc.addConj(this.getBody(i).pushNeg());
        }
        return lnc;
    }

    @Override
    public LiveExprNode pushNeg(boolean hasNeg) {
        if (hasNeg) {
            LNConj lnc = new LNConj(this.getCount());
            for (int i = 0; i < this.getCount(); ++i) {
                lnc.addConj(this.getBody(i).pushNeg(true));
            }
            return lnc;
        }
        LNDisj lnd1 = new LNDisj(this.getCount());
        for (int i = 0; i < this.getCount(); ++i) {
            lnd1.addDisj(this.getBody(i).pushNeg(false));
        }
        return lnd1;
    }

    @Override
    public boolean equals(LiveExprNode exp) {
        if (exp instanceof LNDisj) {
            LNDisj exp2 = (LNDisj)exp;
            if (this.getCount() != exp2.getCount()) {
                return false;
            }
            for (int i = 0; i < this.getCount(); ++i) {
                if (this.getBody(i).equals(exp2.getBody(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

