/*
 * Decompiled with CFR 0.152.
 */
package tlc2.model;

import java.util.ArrayList;
import java.util.Map;
import tla2sany.st.Location;
import tlc2.model.MCVariable;
import tlc2.tool.TLCStateInfo;
import tlc2.value.IValue;
import util.UniqueString;

public class MCState {
    private static final String BACK_TO_STATE = " Back to state";
    private final MCVariable[] variables;
    private final String name;
    private final String label;
    private final Location location;
    private final boolean isStuttering;
    private final boolean isBackToState;
    private final int stateNumber;

    public static MCState parseState(String stateInputString) {
        Location location;
        String name;
        int index = stateInputString.indexOf(":");
        int index2 = stateInputString.indexOf("\n", index);
        if (index2 == -1) {
            index2 = stateInputString.length();
        }
        int stateNumber = Integer.parseInt(stateInputString.substring(0, index).trim());
        String label = stateInputString.substring(index + 1, index2);
        boolean isStuttering = label.indexOf(" Stuttering") == 0;
        boolean isBackToState = label.indexOf(BACK_TO_STATE) == 0;
        MCVariable[] vars = null;
        if (!isBackToState && !isStuttering) {
            String variableInputString = stateInputString.substring(index2 + 1);
            vars = MCState.parseVariables(variableInputString);
            if (label.length() > 2) {
                String sublabel = label.substring(2, label.length() - 1);
                int lineIndex = sublabel.indexOf("line ");
                if (lineIndex != -1) {
                    name = sublabel.substring(0, lineIndex - 1);
                    location = Location.parseLocation(sublabel.substring(lineIndex));
                } else {
                    name = sublabel;
                    location = null;
                }
            } else {
                name = null;
                location = null;
            }
        } else {
            name = null;
            location = null;
        }
        return new MCState(vars, name, label, location, isStuttering, isBackToState, stateNumber);
    }

    public MCState(MCVariable[] vars, String stateName, String stateLabel, Location moduleLocation, boolean stuttering, boolean backToState, int ordinal) {
        this.variables = vars;
        this.name = stateName;
        this.label = stateLabel;
        this.location = moduleLocation;
        this.isStuttering = stuttering;
        this.isBackToState = backToState;
        this.stateNumber = ordinal;
    }

    public MCState(MCState other, boolean isStuttering, boolean isBackToState) {
        this.variables = other.variables;
        this.name = other.name;
        this.label = other.label;
        this.location = other.location;
        this.stateNumber = other.stateNumber;
        this.isStuttering = isStuttering;
        this.isBackToState = isBackToState;
    }

    public MCState(TLCStateInfo tlcState) {
        this.name = "";
        this.label = "";
        this.location = null;
        this.isStuttering = false;
        this.isBackToState = false;
        this.stateNumber = (int)tlcState.stateNumber;
        Map<UniqueString, IValue> variableMap = tlcState.getOriginalState().getVals();
        ArrayList<MCVariable> variableList = new ArrayList<MCVariable>();
        for (UniqueString key : variableMap.keySet()) {
            IValue value = variableMap.get(key);
            MCVariable variable = new MCVariable(key.toString(), value);
            variableList.add(variable);
        }
        this.variables = variableList.toArray(new MCVariable[variableList.size()]);
    }

    public MCVariable[] getVariables() {
        return this.variables;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStuttering() {
        return this.isStuttering;
    }

    public boolean isBackToState() {
        return this.isBackToState;
    }

    public int getStateNumber() {
        return this.stateNumber;
    }

    public Location getLocation() {
        return this.location;
    }

    public String asRecord(boolean includeHeader) {
        StringBuilder result = new StringBuilder();
        result.append("[");
        result.append("\n");
        if (includeHeader) {
            result.append(" ");
            result.append("_TEAction");
            result.append(" |-> ");
            result.append("[");
            result.append("\n");
            result.append(" ").append(" ").append(" ");
            result.append("position");
            result.append(" |-> ");
            result.append(this.getStateNumber());
            result.append(",").append("\n");
            result.append(" ").append(" ").append(" ");
            result.append("name");
            result.append(" |-> ");
            result.append("\"");
            result.append(this.name);
            result.append("\"");
            result.append(",").append("\n");
            result.append(" ").append(" ").append(" ");
            result.append("location");
            result.append(" |-> ");
            result.append("\"");
            result.append(this.location);
            result.append("\"");
            result.append("\n");
            result.append(" ").append("]");
            if (this.variables.length != 0) {
                result.append(",").append("\n");
            }
        }
        for (int i = 0; i < this.variables.length; ++i) {
            MCVariable variable = this.variables[i];
            if (variable.isTraceExplorerExpression()) {
                result.append(variable.getSingleLineDisplayName());
            } else {
                result.append(variable.getName());
            }
            result.append(" |-> ");
            result.append(variable.getValueAsString());
            if (i >= this.variables.length - 1) continue;
            result.append(",").append("\n");
        }
        result.append("\n").append("]");
        return result.toString();
    }

    public String asSimpleRecord() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        for (int i = 0; i < this.variables.length; ++i) {
            MCVariable var = this.variables[i];
            buf.append(var.getName());
            buf.append(" |-> ");
            buf.append(var.getValueAsString());
            if (i >= this.variables.length - 1) continue;
            buf.append(",");
        }
        buf.append("]");
        return buf.toString();
    }

    public String getConjunctiveDescription(boolean includeTraceExpressions, String indent) {
        return this.getConjunctiveDescription(includeTraceExpressions, indent, false);
    }

    public String getConjunctiveDescription(boolean includeTraceExpressions, String indent, boolean ansiMarkup) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.variables.length; ++i) {
            MCVariable var = this.variables[i];
            if (var.isTraceExplorerExpression() && !includeTraceExpressions) continue;
            if (indent != null) {
                result.append(indent);
            }
            result.append("/\\ ");
            if (var.isTraceExplorerExpression()) {
                if (ansiMarkup) {
                    result.append("\u001b[1m");
                }
                result.append(var.getSingleLineDisplayName());
            } else {
                result.append(var.getName());
            }
            result.append(" = ").append(var.getValueAsString());
            if (var.isTraceExplorerExpression() && ansiMarkup) {
                result.append("\u001b[0m");
            }
            result.append('\n');
        }
        return result.toString();
    }

    private static MCVariable[] parseVariables(String variableInputString) {
        String[] lines = variableInputString.split("\n");
        ArrayList<MCVariable> vars = new ArrayList<MCVariable>();
        String[] stateVarString = null;
        for (int j = 0; j < lines.length; ++j) {
            int index = lines[j].indexOf("/\\");
            if (index != -1) {
                if (stateVarString != null) {
                    MCVariable var = new MCVariable((String)stateVarString[0], stateVarString[1]);
                    vars.add(var);
                }
                stateVarString = lines[j].substring(index + "/\\".length() + 1).split(" = ");
                continue;
            }
            if (stateVarString != null) {
                stateVarString[1] = stateVarString[1] + "\n";
                stateVarString[1] = stateVarString[1] + lines[j];
                continue;
            }
            stateVarString = lines[j].split(" = ");
        }
        if (stateVarString != null) {
            MCVariable var = new MCVariable((String)stateVarString[0], (String)stateVarString[1]);
            vars.add(var);
        }
        return vars.toArray(new MCVariable[vars.size()]);
    }
}

