/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tlc2.tool.ITool;
import tlc2.tool.TLCState;
import tlc2.tool.liveness.LNAll;
import tlc2.tool.liveness.LiveExprNode;
import tlc2.tool.liveness.TBPar;
import util.Assert;

class LNEven
extends LiveExprNode {
    private static final String EVENTUALLY = "<>";
    private final LiveExprNode body;

    public LNEven(LiveExprNode body) {
        this.body = body;
    }

    public final LiveExprNode getBody() {
        return this.body;
    }

    @Override
    public final int getLevel() {
        return 3;
    }

    @Override
    public final boolean containAction() {
        return this.body.containAction();
    }

    @Override
    public final boolean eval(ITool tool, TLCState s1, TLCState s2) {
        Assert.fail(2251, EVENTUALLY);
        return false;
    }

    @Override
    public final void toString(StringBuffer sb, String padding) {
        sb.append(EVENTUALLY);
        this.getBody().toString(sb, padding + "  ");
    }

    @Override
    public LiveExprNode getEABody() {
        LiveExprNode evenBody = this.getBody();
        if (evenBody instanceof LNAll) {
            return ((LNAll)evenBody).getBody();
        }
        return super.getEABody();
    }

    @Override
    public void extractPromises(TBPar promises) {
        LNEven lne = this;
        if (!promises.member(lne)) {
            promises.addElement(lne);
        }
        lne.getBody().extractPromises(promises);
    }

    @Override
    public int tagExpr(int tag) {
        return this.getBody().tagExpr(tag);
    }

    @Override
    public final LiveExprNode makeBinary() {
        return new LNEven(this.getBody().makeBinary());
    }

    @Override
    public LiveExprNode flattenSingleJunctions() {
        return new LNEven(this.getBody().flattenSingleJunctions());
    }

    @Override
    public LiveExprNode simplify() {
        LiveExprNode body1 = this.getBody().simplify();
        if (body1 instanceof LNEven) {
            body1 = ((LNEven)body1).getBody();
        }
        return new LNEven(body1);
    }

    @Override
    public boolean isGeneralTF() {
        LiveExprNode evenBody = this.getBody();
        if (evenBody instanceof LNAll) {
            return false;
        }
        return super.isGeneralTF();
    }

    @Override
    public LiveExprNode pushNeg() {
        return new LNAll(this.getBody().pushNeg());
    }

    @Override
    public LiveExprNode pushNeg(boolean hasNeg) {
        if (hasNeg) {
            return new LNAll(this.getBody().pushNeg(true));
        }
        return new LNEven(this.getBody().pushNeg(false));
    }

    @Override
    public boolean equals(LiveExprNode exp) {
        if (exp instanceof LNEven) {
            return this.getBody().equals(((LNEven)exp).getBody());
        }
        return false;
    }

    @Override
    public String toDotViz() {
        return EVENTUALLY + this.getBody().toDotViz();
    }
}

