/*
 * Decompiled with CFR 0.152.
 */
package tlc2.module;

import java.io.IOException;
import tla2sany.semantic.ExprOrOpArgNode;
import tlc2.TLCGlobals;
import tlc2.overrides.Evaluation;
import tlc2.overrides.TLAPlusOperator;
import tlc2.tool.Action;
import tlc2.tool.EvalControl;
import tlc2.tool.EvalException;
import tlc2.tool.ModelChecker;
import tlc2.tool.SimulationWorker;
import tlc2.tool.TLCState;
import tlc2.tool.coverage.CostModel;
import tlc2.tool.impl.Tool;
import tlc2.tool.queue.IStateQueue;
import tlc2.util.Context;
import tlc2.util.IdThread;
import tlc2.value.ValueConstants;
import tlc2.value.Values;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.Value;
import util.ToolIO;
import util.UniqueString;

public class TLCGetSet
implements ValueConstants {
    private static final UniqueString LEVEL = UniqueString.uniqueStringOf("level");
    private static final UniqueString DURATION = UniqueString.uniqueStringOf("duration");
    private static final UniqueString QUEUE = UniqueString.uniqueStringOf("queue");
    private static final UniqueString DISTINCT = UniqueString.uniqueStringOf("distinct");
    private static final UniqueString GENERATED = UniqueString.uniqueStringOf("generated");
    private static final UniqueString DIAMETER = UniqueString.uniqueStringOf("diameter");
    private static final UniqueString EXIT = UniqueString.uniqueStringOf("exit");
    private static final UniqueString PAUSE = UniqueString.uniqueStringOf("pause");
    private static final UniqueString MODE = UniqueString.uniqueStringOf("mode");
    private static final UniqueString ACTION = UniqueString.uniqueStringOf("action");
    public static final long serialVersionUID = 20210330L;
    private static final long startTime = System.currentTimeMillis();

    @Evaluation(definition="TLCGet", module="TLC", warn=false, silent=true, minLevel=1)
    public static Value TLCGetEval(Tool tool, ExprOrOpArgNode[] args, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        Value vidx = tool.eval(args[0], c, s0, s1, control, cm);
        if (vidx instanceof IntValue) {
            int idx = ((IntValue)vidx).val;
            if (idx >= 0) {
                Thread th = Thread.currentThread();
                Value res = null;
                if (th instanceof IdThread) {
                    res = (Value)((IdThread)th).getLocalValue(idx);
                } else if (TLCGlobals.mainChecker != null) {
                    res = (Value)TLCGlobals.mainChecker.getValue(0, idx);
                } else if (TLCGlobals.simulator != null) {
                    res = (Value)TLCGlobals.simulator.getLocalValue(idx);
                }
                if (res == null) {
                    throw new EvalException(2145, String.valueOf(idx));
                }
                return res;
            }
        } else if (vidx instanceof StringValue) {
            return TLCGetSet.TLCGetStringValue(vidx, s0, s1, control);
        }
        throw new EvalException(2283, new String[]{"TLCGet", "nonnegative integer", Values.ppr(vidx.toString())});
    }

    private static final Value TLCGetStringValue(Value vidx, TLCState s0, TLCState s1, int control) {
        StringValue sv = (StringValue)vidx;
        if (DIAMETER == sv.val) {
            try {
                if (TLCGlobals.mainChecker != null) {
                    return IntValue.gen(TLCGlobals.mainChecker.getProgress());
                }
                if (TLCGlobals.simulator != null) {
                    if (Thread.currentThread() instanceof SimulationWorker) {
                        SimulationWorker sw = (SimulationWorker)Thread.currentThread();
                        long traceCnt = sw.getTraceCnt();
                        if (traceCnt > Integer.MAX_VALUE) {
                            return IntValue.gen(Integer.MAX_VALUE);
                        }
                        return IntValue.gen((int)traceCnt);
                    }
                    return IntValue.gen(0);
                }
                throw new EvalException(2145, String.valueOf(sv.val));
            }
            catch (ArithmeticException e) {
                throw new EvalException(2178, Long.toString(TLCGlobals.mainChecker.getProgress()));
            }
            catch (NullPointerException npe) {
                throw new EvalException(2145, String.valueOf(sv.val));
            }
        }
        if (GENERATED == sv.val) {
            try {
                return IntValue.gen(Math.toIntExact(TLCGlobals.mainChecker.getStatesGenerated()));
            }
            catch (ArithmeticException e) {
                throw new EvalException(2178, Long.toString(TLCGlobals.mainChecker.getStatesGenerated()));
            }
            catch (NullPointerException npe) {
                throw new EvalException(2145, String.valueOf(sv.val));
            }
        }
        if (DISTINCT == sv.val) {
            try {
                return IntValue.gen(Math.toIntExact(TLCGlobals.mainChecker.getDistinctStatesGenerated()));
            }
            catch (ArithmeticException e) {
                throw new EvalException(2178, Long.toString(TLCGlobals.mainChecker.getDistinctStatesGenerated()));
            }
            catch (NullPointerException npe) {
                throw new EvalException(2145, String.valueOf(sv.val));
            }
        }
        if (QUEUE == sv.val) {
            try {
                return IntValue.gen(Math.toIntExact(TLCGlobals.mainChecker.getStateQueueSize()));
            }
            catch (ArithmeticException e) {
                throw new EvalException(2178, Long.toString(TLCGlobals.mainChecker.getStateQueueSize()));
            }
            catch (NullPointerException npe) {
                throw new EvalException(2145, String.valueOf(sv.val));
            }
        }
        if (DURATION == sv.val) {
            try {
                int duration = (int)((System.currentTimeMillis() - startTime) / 1000L);
                return IntValue.gen(Math.toIntExact(duration));
            }
            catch (ArithmeticException e) {
                throw new EvalException(2178, Long.toString((System.currentTimeMillis() - startTime) / 1000L));
            }
        }
        if (MODE == sv.val) {
            if (TLCGlobals.simulator != null) {
                return new StringValue("Simulation");
            }
            return new StringValue("BFS");
        }
        if (LEVEL == sv.val) {
            if (EvalControl.isConst(control) || EvalControl.isInit(control)) {
                return IntValue.gen(0);
            }
            return IntValue.gen(s0.getLevel());
        }
        if (ACTION == sv.val) {
            if (s0 == null || s0.getAction() == null) {
                return new RecordValue(Action.UNKNOWN);
            }
            return new RecordValue(s0.getAction());
        }
        throw new EvalException(2145, String.valueOf(sv.val));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TLAPlusOperator(identifier="TLCSet", module="TLC", warn=false)
    public static Value TLCSet(Value vidx, Value val) {
        if (vidx instanceof IntValue) {
            int idx = ((IntValue)vidx).val;
            if (idx >= 0) {
                Thread th = Thread.currentThread();
                if (th instanceof IdThread) {
                    ((IdThread)th).setLocalValue(idx, val);
                } else if (TLCGlobals.mainChecker != null) {
                    TLCGlobals.mainChecker.setAllValues(idx, val);
                } else {
                    TLCGlobals.simulator.setAllValues(idx, val);
                }
                return BoolValue.ValTrue;
            }
        } else if (vidx instanceof StringValue) {
            StringValue sv = (StringValue)vidx;
            if (EXIT == sv.val) {
                if (val == BoolValue.ValTrue) {
                    if (TLCGlobals.mainChecker != null) {
                        TLCGlobals.mainChecker.stop();
                    }
                    if (TLCGlobals.simulator != null) {
                        TLCGlobals.simulator.stop();
                    }
                }
                return BoolValue.ValTrue;
            }
            if (PAUSE == sv.val) {
                if (val == BoolValue.ValTrue && TLCGlobals.mainChecker instanceof ModelChecker) {
                    ModelChecker mc = (ModelChecker)TLCGlobals.mainChecker;
                    IStateQueue iStateQueue = mc.theStateQueue;
                    synchronized (iStateQueue) {
                        ToolIO.out.println("Press enter to resume model checking.");
                        ToolIO.out.flush();
                        try {
                            System.in.read();
                        }
                        catch (IOException e) {
                            throw new EvalException(1000, e.getMessage());
                        }
                    }
                }
                return BoolValue.ValTrue;
            }
        }
        throw new EvalException(2169, new String[]{"first", "TLCSet", "nonnegative integer", Values.ppr(vidx.toString())});
    }
}

