/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.runner.RunWith;
import tlc2.TLCGlobals;
import tlc2.TestMPRecorder;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.TLCStateMutExt;
import util.IsolatedTestCaseRunner;

@RunWith(value=IsolatedTestCaseRunner.class)
public abstract class CommonTestCase {
    protected static final String BASE_DIR = System.getProperty("basedir", "");
    protected static final String TEST_MODEL = "test-model" + File.separator;
    public static final String BASE_PATH = System.getProperty("basepath", BASE_DIR + TEST_MODEL);
    protected final TestMPRecorder recorder;

    public CommonTestCase() {
        this(new TestMPRecorder());
    }

    public CommonTestCase(TestMPRecorder testMPRecorder) {
        this.recorder = testMPRecorder;
    }

    protected boolean isExtendedTLCState() {
        return TLCState.Empty instanceof TLCStateMutExt;
    }

    protected void assertTraceWith(List<Object> actual, List<String> expectedTrace) {
        Assert.assertEquals((long)expectedTrace.size(), (long)actual.size());
        for (int i = 0; i < expectedTrace.size(); ++i) {
            Object[] objs = (Object[])actual.get(i);
            TLCStateInfo stateInfo = (TLCStateInfo)objs[0];
            String info = (String)stateInfo.info;
            if (i == 0 && !this.isExtendedTLCState()) {
                Assert.assertEquals((Object)"<Initial predicate>", (Object)info);
            } else {
                Assert.assertNotEquals((Object)"<Initial predicate>", (Object)info);
                Assert.assertFalse((boolean)info.startsWith("<Action"));
            }
            Assert.assertEquals((Object)expectedTrace.get(i), (Object)stateInfo.toString().trim());
            Assert.assertEquals((Object)(i + 1), (Object)objs[1]);
        }
    }

    protected void assertTraceWith(List<Object> actual, List<String> expectedTrace, List<String> expectedActions) {
        Assert.assertEquals((long)expectedTrace.size(), (long)actual.size());
        for (int i = 0; i < expectedTrace.size(); ++i) {
            Object[] objs = (Object[])actual.get(i);
            TLCStateInfo stateInfo = (TLCStateInfo)objs[0];
            String info = (String)stateInfo.info;
            Assert.assertEquals((Object)expectedActions.get(i), (Object)info);
            Assert.assertEquals((Object)expectedTrace.get(i), (Object)stateInfo.toString().trim());
            Assert.assertEquals((Object)(i + 1), (Object)objs[1]);
        }
    }

    protected void assertStuttering(int stateNum) {
        Assert.assertTrue((boolean)this.recorder.recorded(2218));
        List<Object> stutter = this.recorder.getRecords(2218);
        Assert.assertTrue((stutter.size() > 0 ? 1 : 0) != 0);
        Object[] object = (Object[])stutter.get(0);
        Assert.assertEquals((Object)stateNum, (Object)object[1]);
    }

    protected void assertBackToState() {
        Assert.assertTrue((boolean)this.recorder.recorded(2122));
        List<Object> loop = this.recorder.getRecords(2122);
        Assert.assertTrue((loop.size() > 0 ? 1 : 0) != 0);
    }

    protected void assertBackToState(int stateNum) {
        Assert.assertTrue((boolean)this.recorder.recorded(2122));
        List<Object> loop = this.recorder.getRecords(2122);
        Assert.assertTrue((loop.size() > 0 ? 1 : 0) != 0);
        Object[] object = (Object[])loop.get(0);
        Assert.assertEquals((Object)Integer.toString(stateNum), (Object)object[0]);
    }

    protected void assertBackToState(int stateNum, String action) {
        Assert.assertTrue((boolean)this.recorder.recorded(2122));
        List<Object> loop = this.recorder.getRecords(2122);
        Assert.assertTrue((loop.size() > 0 ? 1 : 0) != 0);
        Object[] object = (Object[])loop.get(0);
        Assert.assertTrue((object.length > 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)Integer.toString(stateNum), (Object)object[0]);
        Assert.assertEquals((Object)action, (Object)object[1]);
    }

    protected void assertNodeAndPtrSizes(long nodesSize, long ptrsSize) {
        String metadir = TLCGlobals.mainChecker.metadir;
        Assert.assertNotNull((Object)metadir);
        File nodes = new File(metadir + File.separator + "nodes_0");
        Assert.assertTrue((boolean)nodes.exists());
        Assert.assertEquals((long)nodesSize, (long)nodes.length());
        File ptrs = new File(metadir + File.separator + "ptrs_0");
        Assert.assertTrue((boolean)ptrs.exists());
        Assert.assertEquals((long)ptrsSize, (long)ptrs.length());
    }

    protected void assertUncovered(String expectedUncovered) {
        List expected = Arrays.asList(expectedUncovered.trim().split("\n")).stream().map(o -> new TestMPRecorder.Coverage(o.split(":"))).collect(Collectors.toList());
        Set expectedZero = expected.stream().filter(TestMPRecorder.Coverage::isZero).collect(Collectors.toSet());
        Set actualZeroCoverage = this.recorder.getZeroCoverage().stream().collect(Collectors.toSet());
        Assert.assertEquals(expectedZero, actualZeroCoverage);
    }

    protected void assertZeroUncovered() {
        Assert.assertTrue((boolean)this.recorder.getZeroCoverage().isEmpty());
    }

    protected void assertCoverage(String expectedCoverage) {
        List expected = Arrays.asList(expectedCoverage.split("\n")).stream().map(o -> new TestMPRecorder.Coverage(o.split(":"))).collect(Collectors.toList());
        Set expectedZero = expected.stream().filter(TestMPRecorder.Coverage::isZero).filter(TestMPRecorder.Coverage::isCoverage).collect(Collectors.toSet());
        Set actualZeroCoverage = this.recorder.getZeroCoverage().stream().collect(Collectors.toSet());
        Assert.assertEquals(expectedZero, actualZeroCoverage);
        List<TestMPRecorder.Coverage> actualNonZeroCoverage = this.recorder.getNonZeroCoverage();
        List expectedNonZeroCoverage = expected.stream().filter(TestMPRecorder.Coverage::isCoverage).filter(c -> !c.isCost()).collect(Collectors.toList());
        expectedNonZeroCoverage.removeAll(actualZeroCoverage);
        for (int i = 0; i < actualNonZeroCoverage.size(); ++i) {
            TestMPRecorder.Coverage a = actualNonZeroCoverage.get(i);
            TestMPRecorder.Coverage e = (TestMPRecorder.Coverage)expectedNonZeroCoverage.get(i);
            Assert.assertEquals((Object)e, (Object)a);
        }
        Assert.assertTrue((expectedNonZeroCoverage.size() == actualNonZeroCoverage.size() ? 1 : 0) != 0);
        List<TestMPRecorder.Coverage> actualCostCoverage = this.recorder.getCostCoverage();
        List expectedCostCoverage = expected.stream().filter(TestMPRecorder.Coverage::isCoverage).filter(TestMPRecorder.Coverage::isCost).collect(Collectors.toList());
        for (int i = 0; i < actualCostCoverage.size(); ++i) {
            TestMPRecorder.Coverage a = actualCostCoverage.get(i);
            TestMPRecorder.Coverage e = (TestMPRecorder.Coverage)expectedCostCoverage.get(i);
            Assert.assertEquals((Object)e, (Object)a);
        }
        Assert.assertTrue((expectedCostCoverage.size() == actualCostCoverage.size() ? 1 : 0) != 0);
        List<TestMPRecorder.Coverage> actualActions = this.recorder.getActionCoverage();
        List expectedActions = expected.stream().filter(TestMPRecorder.Coverage::isAction).collect(Collectors.toList());
        for (int i = 0; i < actualActions.size(); ++i) {
            TestMPRecorder.Coverage a = actualActions.get(i);
            TestMPRecorder.Coverage e = (TestMPRecorder.Coverage)expectedActions.get(i);
            Assert.assertEquals((Object)e, (Object)a);
        }
        Assert.assertTrue((expectedActions.size() == actualActions.size() ? 1 : 0) != 0);
    }
}

