/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.stream.Collectors;
import tla2sany.parser.SimpleCharStream;
import tla2sany.parser.TLAplusParserTokenManager;
import tla2sany.parser.Token;
import tla2sany.parser.TokenMgrError;
import tlc2.tool.ConfigFileException;
import tlc2.util.Vect;
import tlc2.value.ValueConstants;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueVec;
import util.FileUtil;
import util.FilenameToStream;
import util.MonolithSpecExtractor;
import util.SimpleFilenameToStream;

public class ModelConfig
implements ValueConstants,
Serializable {
    private static final String Constant = "CONSTANT";
    private static final String Constants = "CONSTANTS";
    private static final String Constraint = "CONSTRAINT";
    private static final String Constraints = "CONSTRAINTS";
    private static final String ActionConstraint = "ACTION_CONSTRAINT";
    private static final String ActionConstraints = "ACTION_CONSTRAINTS";
    private static final String Invariant = "INVARIANT";
    private static final String Invariants = "INVARIANTS";
    private static final String Init = "INIT";
    private static final String Next = "NEXT";
    private static final String View = "VIEW";
    private static final String Symmetry = "SYMMETRY";
    private static final String Spec = "SPECIFICATION";
    private static final String Prop = "PROPERTY";
    private static final String Props = "PROPERTIES";
    private static final String Alias = "ALIAS";
    private static final String PostCondition = "POSTCONDITION";
    public static final String CheckDeadlock = "CHECK_DEADLOCK";
    private static final long serialVersionUID = 1L;
    public static final String[] ALL_KEYWORDS = new String[]{"CONSTANT", "CONSTANTS", "CONSTRAINT", "CONSTRAINTS", "ACTION_CONSTRAINT", "ACTION_CONSTRAINTS", "INVARIANT", "INVARIANTS", "INIT", "NEXT", "VIEW", "SYMMETRY", "SPECIFICATION", "PROPERTY", "PROPERTIES", "ALIAS", "POSTCONDITION", "CHECK_DEADLOCK"};
    private Hashtable configTbl;
    private Hashtable<String, String> overrides;
    private Hashtable<String, String> overridesReverseMap;
    private Hashtable modConstants;
    private Hashtable modOverrides;
    private String configFileName;
    private FilenameToStream resolver;
    private List<String> rawConstants;

    public ModelConfig(String configFileName, FilenameToStream resolver) {
        this.resolver = resolver != null ? resolver : new SimpleFilenameToStream();
        ModelValue.init();
        this.configFileName = configFileName;
        this.configTbl = new Hashtable();
        Vect temp = new Vect();
        this.configTbl.put(Constant, temp);
        this.configTbl.put(Constants, temp);
        temp = new Vect();
        this.configTbl.put(Constraint, temp);
        this.configTbl.put(Constraints, temp);
        temp = new Vect();
        this.configTbl.put(ActionConstraint, temp);
        this.configTbl.put(ActionConstraints, temp);
        temp = new Vect();
        this.configTbl.put(Invariant, temp);
        this.configTbl.put(Invariants, temp);
        this.configTbl.put(Init, "");
        this.configTbl.put(Next, "");
        this.configTbl.put(View, "");
        this.configTbl.put(Symmetry, "");
        this.configTbl.put(Spec, "");
        temp = new Vect();
        this.configTbl.put(Prop, temp);
        this.configTbl.put(Props, temp);
        this.configTbl.put(Alias, "");
        this.configTbl.put(PostCondition, "");
        this.configTbl.put(CheckDeadlock, "undef");
        this.modConstants = new Hashtable();
        this.modOverrides = new Hashtable();
        this.overrides = new Hashtable();
        this.overridesReverseMap = new Hashtable();
        this.rawConstants = new ArrayList<String>();
    }

    public final void parse() {
        Vect constants = (Vect)this.configTbl.get(Constant);
        Vect constraints = (Vect)this.configTbl.get(Constraint);
        Vect actionConstraints = (Vect)this.configTbl.get(ActionConstraint);
        Vect invariants = (Vect)this.configTbl.get(Invariant);
        Vect props = (Vect)this.configTbl.get(Prop);
        try {
            InputStream fis = FileUtil.newFIS(this.resolver.resolve(this.configFileName, false));
            if (fis == null) {
                throw new ConfigFileException(5001, new String[]{this.configFileName, "File not found."});
            }
            if (this.configFileName.endsWith(".tla")) {
                fis = MonolithSpecExtractor.config(fis, this.configFileName.replace(".tla", ""));
            }
            SimpleCharStream scs = new SimpleCharStream(fis, 1, 1);
            TLAplusParserTokenManager tmgr = new TLAplusParserTokenManager(scs, 2);
            ArrayList<StringBuffer> rawConstants = new ArrayList<StringBuffer>();
            Token tt = ModelConfig.getNextToken(tmgr);
            block2: while (tt.kind != 0) {
                String old;
                String tval = tt.image;
                int loc = scs.getBeginLine();
                if (tval.equals(Init)) {
                    tt = ModelConfig.getNextToken(tmgr);
                    if (tt.kind == 0) {
                        throw new ConfigFileException(5003, new String[]{String.valueOf(loc), Init});
                    }
                    old = this.configTbl.put(Init, tt.image);
                    if (old.length() != 0) {
                        throw new ConfigFileException(5004, new String[]{String.valueOf(loc), Init});
                    }
                    tt = ModelConfig.getNextToken(tmgr);
                    continue;
                }
                if (tval.equals(Next)) {
                    tt = ModelConfig.getNextToken(tmgr);
                    if (tt.kind == 0) {
                        throw new ConfigFileException(5003, new String[]{String.valueOf(loc), Next});
                    }
                    old = this.configTbl.put(Next, tt.image);
                    if (old.length() != 0) {
                        throw new ConfigFileException(5004, new String[]{String.valueOf(loc), Next});
                    }
                    tt = ModelConfig.getNextToken(tmgr);
                    continue;
                }
                if (tval.equals(Spec)) {
                    tt = ModelConfig.getNextToken(tmgr);
                    if (tt.kind == 0) {
                        throw new ConfigFileException(5003, new String[]{String.valueOf(loc), Spec});
                    }
                    old = this.configTbl.put(Spec, tt.image);
                    if (old.length() != 0) {
                        throw new ConfigFileException(5004, new String[]{String.valueOf(loc), Spec});
                    }
                    tt = ModelConfig.getNextToken(tmgr);
                    continue;
                }
                if (tval.equals(View)) {
                    tt = ModelConfig.getNextToken(tmgr);
                    if (tt.kind == 0) {
                        throw new ConfigFileException(5003, new String[]{String.valueOf(loc), View});
                    }
                    old = this.configTbl.put(View, tt.image);
                    if (old.length() != 0) {
                        throw new ConfigFileException(5004, new String[]{String.valueOf(loc), View});
                    }
                    tt = ModelConfig.getNextToken(tmgr);
                    continue;
                }
                if (tval.equals(Symmetry)) {
                    tt = ModelConfig.getNextToken(tmgr);
                    if (tt.kind == 0) {
                        throw new ConfigFileException(5003, new String[]{String.valueOf(loc), Symmetry});
                    }
                    old = this.configTbl.put(Symmetry, tt.image);
                    if (old.length() != 0) {
                        throw new ConfigFileException(5004, new String[]{String.valueOf(loc), Symmetry});
                    }
                    tt = ModelConfig.getNextToken(tmgr);
                    continue;
                }
                if (tval.equals(Alias)) {
                    tt = ModelConfig.getNextToken(tmgr);
                    if (tt.kind == 0) {
                        throw new ConfigFileException(5003, new String[]{String.valueOf(loc), Alias});
                    }
                    old = this.configTbl.put(Alias, tt.image);
                    if (old.length() != 0) {
                        throw new ConfigFileException(5004, new String[]{String.valueOf(loc), Alias});
                    }
                    tt = ModelConfig.getNextToken(tmgr);
                    continue;
                }
                if (tval.equals(PostCondition)) {
                    tt = ModelConfig.getNextToken(tmgr);
                    if (tt.kind == 0) {
                        throw new ConfigFileException(5003, new String[]{String.valueOf(loc), PostCondition});
                    }
                    old = this.configTbl.put(PostCondition, tt.image);
                    if (old.length() != 0) {
                        throw new ConfigFileException(5004, new String[]{String.valueOf(loc), PostCondition});
                    }
                    tt = ModelConfig.getNextToken(tmgr);
                    continue;
                }
                if (tval.equals(Constant) || tval.equals(Constants)) {
                    StringBuffer buf2 = new StringBuffer(tval);
                    rawConstants.add(buf2);
                    while (true) {
                        String modName;
                        tt = ModelConfig.getNextToken(tmgr);
                        if (tt.kind == 0 || this.configTbl.get(tt.image) != null) continue block2;
                        buf2.append("\n").append(tt.image).append(" ");
                        String lhs = tt.image;
                        tt = ModelConfig.getNextToken(tmgr, buf2);
                        while (tt.image.equals("!")) {
                            tt = ModelConfig.getNextToken(tmgr, buf2);
                            lhs = lhs + "!" + tt.image;
                            tt = ModelConfig.getNextToken(tmgr, buf2);
                        }
                        Vect<Object> line = new Vect<Object>();
                        line.addElement(lhs);
                        if (tt.image.equals("<-")) {
                            tt = ModelConfig.getNextToken(tmgr, buf2);
                            if (tt.image.equals("[")) {
                                tt = ModelConfig.getNextToken(tmgr, buf2);
                                if (tt.kind == 0) {
                                    throw new ConfigFileException(5005, new String[]{String.valueOf(scs.getBeginLine()), "<-["});
                                }
                                modName = tt.image;
                                tt = ModelConfig.getNextToken(tmgr, buf2);
                                if (!tt.image.equals("]")) {
                                    throw new ConfigFileException(5006, new String[]{String.valueOf(scs.getBeginLine()), "]"});
                                }
                                tt = ModelConfig.getNextToken(tmgr, buf2);
                                if (tt.kind == 0) {
                                    throw new ConfigFileException(5005, new String[]{String.valueOf(scs.getBeginLine()), "<-[mod]"});
                                }
                                Hashtable defs = (Hashtable)this.modOverrides.get(modName);
                                if (defs == null) {
                                    defs = new Hashtable();
                                    this.modOverrides.put(modName, defs);
                                }
                                defs.put(line.elementAt(0), tt.image);
                                continue;
                            }
                            if (tt.kind == 0) {
                                throw new ConfigFileException(5005, new String[]{String.valueOf(scs.getBeginLine()), "<-"});
                            }
                            String string = (String)line.elementAt(0);
                            this.overrides.put(string, tt.image);
                            this.overridesReverseMap.put(tt.image, string);
                            continue;
                        }
                        if (tt.image.equals("(")) {
                            do {
                                tt = ModelConfig.getNextToken(tmgr, buf2);
                                Value arg = this.parseValue(tt, scs, tmgr, buf2);
                                line.addElement(arg);
                                tt = ModelConfig.getNextToken(tmgr, buf2);
                            } while (tt.image.equals(","));
                            if (!tt.image.equals(")")) {
                                throw new ConfigFileException(5002, new String[]{String.valueOf(loc)});
                            }
                            tt = ModelConfig.getNextToken(tmgr, buf2);
                        }
                        if (!tt.image.equals("=")) {
                            throw new ConfigFileException(5006, new String[]{String.valueOf(scs.getBeginLine()), "= or <-"});
                        }
                        tt = ModelConfig.getNextToken(tmgr, buf2);
                        if (tt.image.equals("[")) {
                            tt = ModelConfig.getNextToken(tmgr, buf2);
                            if (tt.kind == 0) {
                                throw new ConfigFileException(5005, new String[]{String.valueOf(scs.getBeginLine()), "=["});
                            }
                            modName = tt.image;
                            tt = ModelConfig.getNextToken(tmgr, buf2);
                            if (!tt.image.equals("]")) {
                                throw new ConfigFileException(5006, new String[]{String.valueOf(scs.getBeginLine()), "]"});
                            }
                            tt = ModelConfig.getNextToken(tmgr, buf2);
                            line.addElement(this.parseValue(tt, scs, tmgr, buf2));
                            Vect mConsts = (Vect)this.modConstants.get(modName);
                            if (mConsts == null) {
                                mConsts = new Vect();
                                this.modConstants.put(modName, mConsts);
                            }
                            mConsts.addElement(line);
                            continue;
                        }
                        line.addElement(this.parseValue(tt, scs, tmgr, buf2));
                        constants.addElement(line);
                    }
                }
                if (tval.equals(Invariant) || tval.equals(Invariants)) {
                    while (true) {
                        tt = ModelConfig.getNextToken(tmgr);
                        if (tt.kind == 0 || this.configTbl.get(tt.image) != null) continue block2;
                        invariants.addElement(tt.image);
                    }
                }
                if (tval.equals(Prop) || tval.equals(Props)) {
                    while (true) {
                        tt = ModelConfig.getNextToken(tmgr);
                        if (tt.kind == 0 || this.configTbl.get(tt.image) != null) continue block2;
                        props.addElement(tt.image);
                    }
                }
                if (tval.equals(Constraint) || tval.equals(Constraints)) {
                    while (true) {
                        tt = ModelConfig.getNextToken(tmgr);
                        if (tt.kind == 0 || this.configTbl.get(tt.image) != null) continue block2;
                        constraints.addElement(tt.image);
                    }
                }
                if (tval.equals(ActionConstraint) || tval.equals(ActionConstraints)) {
                    while (true) {
                        tt = ModelConfig.getNextToken(tmgr);
                        if (tt.kind == 0 || this.configTbl.get(tt.image) != null) continue block2;
                        actionConstraints.addElement(tt.image);
                    }
                }
                if (tval.equals(CheckDeadlock)) {
                    Boolean previous;
                    tt = ModelConfig.getNextToken(tmgr);
                    if (tt.kind == 0) {
                        throw new ConfigFileException(5003, new String[]{String.valueOf(loc), CheckDeadlock});
                    }
                    if (tt.image.equals("TRUE")) {
                        previous = this.configTbl.put(CheckDeadlock, true);
                    } else if (tt.image.equals("FALSE")) {
                        previous = this.configTbl.put(CheckDeadlock, false);
                    } else {
                        throw new ConfigFileException(5006, new String[]{String.valueOf(scs.getBeginLine()), "TRUE or FALSE"});
                    }
                    if (previous != "undef") {
                        throw new ConfigFileException(5004, new String[]{String.valueOf(loc), CheckDeadlock});
                    }
                    tt = ModelConfig.getNextToken(tmgr);
                    continue;
                }
                throw new ConfigFileException(5006, new String[]{String.valueOf(scs.getBeginLine()), "a keyword"});
            }
            this.rawConstants = rawConstants.stream().map(buf -> buf.toString()).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new ConfigFileException(5001, new String[]{this.configFileName, e.getMessage()}, e);
        }
    }

    private Value parseValue(Token tt, SimpleCharStream scs, TLAplusParserTokenManager tmgr, StringBuffer buf) throws IOException {
        if (tt.kind == 110) {
            int val = Integer.parseInt(tt.image);
            return IntValue.gen(val);
        }
        if (tt.kind == 111) {
            String tval = tt.image;
            return new StringValue(tval.substring(1, tval.length() - 1));
        }
        if (tt.image.equals("TRUE")) {
            return BoolValue.ValTrue;
        }
        if (tt.image.equals("FALSE")) {
            return BoolValue.ValFalse;
        }
        if (tt.image.equals("{")) {
            ValueVec elems = new ValueVec();
            tt = ModelConfig.getNextToken(tmgr, buf);
            if (!tt.image.equals("}")) {
                while (true) {
                    Value elem = this.parseValue(tt, scs, tmgr, buf);
                    elems.addElement(elem);
                    tt = ModelConfig.getNextToken(tmgr, buf);
                    if (!tt.image.equals(",")) break;
                    tt = ModelConfig.getNextToken(tmgr, buf);
                }
            }
            if (!tt.image.equals("}")) {
                throw new ConfigFileException(5006, new String[]{String.valueOf(scs.getBeginLine()), "}"});
            }
            return new SetEnumValue(elems, false);
        }
        if (tt.kind != 0) {
            return ModelValue.make(tt.image);
        }
        throw new ConfigFileException(5006, new String[]{String.valueOf(scs.getBeginLine()), "a value"});
    }

    private static Token getNextToken(TLAplusParserTokenManager tmgr) {
        try {
            return tmgr.getNextToken();
        }
        catch (TokenMgrError e) {
            Token tt = new Token();
            tt.kind = 0;
            return tt;
        }
    }

    private static Token getNextToken(TLAplusParserTokenManager tmgr, StringBuffer buf) {
        try {
            Token nextToken = tmgr.getNextToken();
            buf.append(nextToken.image).append(" ");
            return nextToken;
        }
        catch (TokenMgrError e) {
            Token tt = new Token();
            tt.kind = 0;
            return tt;
        }
    }

    public final synchronized List<String> getRawConstants() {
        return this.rawConstants;
    }

    public final synchronized Vect getConstants() {
        return (Vect)this.configTbl.get(Constant);
    }

    public final synchronized Hashtable getModConstants() {
        return this.modConstants;
    }

    public final synchronized Hashtable<String, String> getOverrides() {
        return this.overrides;
    }

    public final synchronized String getOverridenSpecNameForConfigName(String configName) {
        return this.overridesReverseMap.get(configName);
    }

    public final synchronized Hashtable getModOverrides() {
        return this.modOverrides;
    }

    public final synchronized Vect getConstraints() {
        return (Vect)this.configTbl.get(Constraint);
    }

    public final synchronized Vect getActionConstraints() {
        return (Vect)this.configTbl.get(ActionConstraint);
    }

    public final synchronized String getInit() {
        return (String)this.configTbl.get(Init);
    }

    public final synchronized String getNext() {
        return (String)this.configTbl.get(Next);
    }

    public final synchronized String getView() {
        return (String)this.configTbl.get(View);
    }

    public final synchronized boolean configDefinesSpecification() {
        String spec2 = this.getSpec();
        return spec2 != null && spec2.trim().length() > 0;
    }

    public final synchronized String getSymmetry() {
        return (String)this.configTbl.get(Symmetry);
    }

    public final synchronized Vect getInvariants() {
        return (Vect)this.configTbl.get(Invariant);
    }

    public final synchronized String getSpec() {
        return (String)this.configTbl.get(Spec);
    }

    public final synchronized Vect getProperties() {
        return (Vect)this.configTbl.get(Prop);
    }

    public final synchronized String getAlias() {
        return (String)this.configTbl.get(Alias);
    }

    public final synchronized String getPostCondition() {
        return (String)this.configTbl.get(PostCondition);
    }

    public final synchronized boolean getCheckDeadlock() {
        Object object = this.configTbl.get(CheckDeadlock);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            FileInputStream fis = new FileInputStream(args[0]);
            SimpleCharStream scs = new SimpleCharStream(fis, 1, 1);
            TLAplusParserTokenManager tmgr = new TLAplusParserTokenManager(scs, 2);
            Token t = ModelConfig.getNextToken(tmgr);
            while (t.kind != 0) {
                System.err.println(t);
                t = ModelConfig.getNextToken(tmgr);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }
}

