/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tlc2.tool.liveness.AbstractGraphNode;
import tlc2.tool.liveness.TBGraph;
import tlc2.tool.liveness.TBGraphNode;
import tlc2.util.BitVector;
import util.WrongInvocationException;

public class BEGraphNode
extends AbstractGraphNode {
    public long stateFP;
    private BEGraphNode[] nnodes;
    private long number;
    private static final BEGraphNode[] emptyNodes = new BEGraphNode[0];

    public BEGraphNode(long fp) {
        super(new BitVector(0));
        this.stateFP = fp;
        this.nnodes = emptyNodes;
        this.number = 0L;
    }

    public final long resetNumberField() {
        long old = this.number;
        this.number = 0L;
        return old;
    }

    public final long getNumber() {
        return this.number & Long.MAX_VALUE;
    }

    public final void incNumber() {
        ++this.number;
    }

    public final void setNumber(long num) {
        this.number = this.number < 0L ? num | Long.MIN_VALUE : num;
    }

    public final boolean getVisited() {
        return this.number < 0L;
    }

    public final void flipVisited() {
        this.number ^= Long.MIN_VALUE;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.stateFP ^ this.stateFP >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BEGraphNode other = (BEGraphNode)obj;
        return this.stateFP == other.stateFP;
    }

    public final BEGraphNode nextAt(int i) {
        return this.nnodes[i];
    }

    public final int nextSize() {
        return this.nnodes.length;
    }

    public final void addTransition(BEGraphNode target, int slen, int alen, boolean[] acts) {
        int num = this.nnodes.length;
        if (acts != null) {
            int pos = slen + alen * num;
            for (int i = 0; i < acts.length; ++i) {
                if (!acts[i]) continue;
                this.checks.set(pos + i);
            }
        }
        BEGraphNode[] newNodes = new BEGraphNode[num + 1];
        System.arraycopy(this.nnodes, 0, newNodes, 0, num);
        newNodes[num] = target;
        this.nnodes = newNodes;
    }

    public final boolean transExists(BEGraphNode target) {
        int len = this.nnodes.length;
        for (int i = 0; i < len; ++i) {
            if (!target.equals(this.nnodes[i])) continue;
            return true;
        }
        return false;
    }

    public TBGraphNode getTNode(TBGraph tableau) {
        throw new WrongInvocationException("TLC bug: should never call BEGraphNode.getTNode().");
    }

    public String nodeInfo() {
        return Long.toString(this.stateFP);
    }

    public final void setParent(BEGraphNode node) {
        if (this.nnodes.length == 0) {
            this.nnodes = new BEGraphNode[1];
        }
        this.nnodes[0] = node;
    }

    public final BEGraphNode getParent() {
        return this.nnodes[0];
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        this.toString(buf, this.getVisited());
        return buf.toString();
    }

    protected void toString(StringBuffer buf, boolean unseen) {
        if (this.getVisited() == unseen) {
            int i;
            this.flipVisited();
            buf.append(this.stateFP + " --> ");
            int size = this.nnodes.length;
            if (size != 0) {
                buf.append(this.nextAt((int)0).stateFP);
            }
            for (i = 1; i < size; ++i) {
                buf.append(", ");
                buf.append(this.nextAt((int)i).stateFP);
            }
            buf.append("\n");
            for (i = 0; i < size; ++i) {
                this.nextAt(i).toString(buf, unseen);
            }
        }
    }
}

