/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import tlc2.util.BigInt;

public class ByteUtils {
    public static byte[] intToByteArray(int x) {
        byte[] b = new byte[]{(byte)(x >>> 24), (byte)(x >>> 16), (byte)(x >>> 8), (byte)x};
        return b;
    }

    public static byte[] longToByteArray(long x) {
        byte[] b = new byte[]{(byte)(x >>> 56), (byte)(x >>> 48), (byte)(x >>> 40), (byte)(x >>> 32), (byte)(x >>> 24), (byte)(x >>> 16), (byte)(x >>> 8), (byte)x};
        return b;
    }

    public static int byteArrayToInt(byte[] b) {
        int i0 = (b[0] & 0xFF) << 24;
        int i1 = (b[1] & 0xFF) << 16;
        int i2 = (b[2] & 0xFF) << 8;
        int i3 = b[3] & 0xFF;
        return i0 | i1 | i2 | i3;
    }

    public static long byteArrayToLong(byte[] b) {
        long i0 = (long)(b[0] & 0xFF) << 56;
        long i1 = (long)(b[1] & 0xFF) << 48;
        long i2 = (long)(b[2] & 0xFF) << 40;
        long i3 = (long)(b[3] & 0xFF) << 32;
        long i4 = (long)(b[4] & 0xFF) << 24;
        long i5 = (long)(b[5] & 0xFF) << 16;
        long i6 = (long)(b[6] & 0xFF) << 8;
        long i7 = b[7] & 0xFF;
        return i0 | i1 | i2 | i3 | i4 | i5 | i6 | i7;
    }

    public static byte[] bigIntToByteArray(BigInt b, int len) throws IOException {
        byte[] bA = b.toByteArray();
        return ByteUtils.byteArrayToByteArray(bA, len);
    }

    public static byte[] byteArrayToByteArray(byte[] bA, int length) throws IOException {
        if (bA.length > length) {
            throw new IOException("byteArrayToByteArray: b needs more than length bytes.");
        }
        byte[] lA = new byte[length];
        int li = length - 1;
        for (int bi = bA.length - 1; bi >= 0; --bi) {
            lA[li--] = bA[bi];
        }
        if (bA[0] < 0) {
            while (li >= 0) {
                lA[li] = -1;
                --li;
            }
        } else {
            while (li >= 0) {
                lA[li] = 0;
                --li;
            }
        }
        return lA;
    }

    public static void writeInt(OutputStream out, int i) throws IOException {
        out.write(ByteUtils.intToByteArray(i));
    }

    public static void writeLong(OutputStream out, long l) throws IOException {
        out.write(ByteUtils.longToByteArray(l));
    }

    public static void writeSizeByteArray(OutputStream out, byte[] bA) throws IOException {
        int len = bA.length;
        ByteUtils.writeInt(out, len);
        out.write(bA);
    }

    public static void writeSizeBigInt(OutputStream out, BigInt b) throws IOException {
        ByteUtils.writeSizeByteArray(out, b.toByteArray());
    }

    public static void writeByteArray(OutputStream out, byte[] bA, int len) throws IOException {
        int bAlen = bA.length;
        if (bAlen > len) {
            throw new IOException("writeByteArray: the byte array too large");
        }
        out.write(ByteUtils.byteArrayToByteArray(bA, len));
    }

    public static void writeBigInt(OutputStream out, BigInt b, int len) throws IOException {
        ByteUtils.writeByteArray(out, b.toByteArray(), len);
    }

    public static void writeSizeArrayOfSizeBigInts(BigInt[] A, int start, int finish, OutputStream out) throws IOException {
        ByteUtils.writeInt(out, finish - start + 1);
        ByteUtils.writeArrayOfSizeBigInts(A, start, finish, out);
    }

    public static void writeArrayOfSizeBigInts(BigInt[] A, int start, int finish, OutputStream out) throws IOException {
        for (int i = start; i <= finish; ++i) {
            ByteUtils.writeSizeByteArray(out, A[i].toByteArray());
        }
    }

    public static int read(InputStream in, byte[] b, int off, int len) throws IOException {
        int cnt;
        int readOnce;
        for (cnt = 0; cnt < len && (readOnce = in.read(b, off + cnt, len - cnt)) > 0; cnt += readOnce) {
        }
        return cnt;
    }

    public static int read(InputStream in, byte[] b) throws IOException {
        return ByteUtils.read(in, b, 0, b.length);
    }

    public static int readInt(InputStream in) throws IOException {
        byte[] b = new byte[4];
        int cnt = ByteUtils.read(in, b);
        if (cnt < 4) {
            if (cnt <= 0) {
                throw new IOException("readInt: the input stream is empty.");
            }
            throw new IOException("readInt: not enought bytes.");
        }
        return ByteUtils.byteArrayToInt(b);
    }

    public static long readLong(InputStream in) throws IOException {
        byte[] b = new byte[8];
        int cnt = ByteUtils.read(in, b);
        if (cnt < 8) {
            if (cnt <= 0) {
                throw new IOException("readLong: the imput stream is empty.");
            }
            throw new IOException("readLong: not enought bytes.");
        }
        return ByteUtils.byteArrayToLong(b);
    }

    public static byte[] readSizeByteArray(InputStream in) throws IOException {
        int len = ByteUtils.readInt(in);
        byte[] bA = new byte[len];
        int cnt = ByteUtils.read(in, bA);
        if (cnt != len) {
            throw new IOException("readSizeByteArray: not enough bytes.");
        }
        return bA;
    }

    public static BigInt readSizeBigInt(InputStream in) throws IOException {
        int len = ByteUtils.readInt(in);
        byte[] bA = new byte[len];
        int cnt = ByteUtils.read(in, bA);
        if (cnt != len) {
            throw new IOException("readSizeBigInt: not enough bytes.");
        }
        return new BigInt(bA);
    }

    public static BigInt[] readSizeArrayOfSizeBigInts(InputStream in) throws IOException {
        int len;
        try {
            len = ByteUtils.readInt(in);
        }
        catch (IOException e) {
            throw new IOException("Can't read an array of BigInts from the input stream; it's empty.");
        }
        BigInt[] A = new BigInt[len];
        try {
            for (int i = 0; i < len; ++i) {
                A[i] = ByteUtils.readSizeBigInt(in);
            }
        }
        catch (IOException e) {
            throw new IOException("Can't read an array of BigInts from the input stream; not enough bytes, but not empty.");
        }
        return A;
    }

    public static BigInt[] readArrayOfSizeBigInts(InputStream in) throws IOException {
        Vector<BigInt> A = new Vector<BigInt>();
        int i = 0;
        try {
            while (true) {
                A.addElement(ByteUtils.readSizeBigInt(in));
                ++i;
            }
        }
        catch (IOException iOException) {
            BigInt[] bA = new BigInt[i];
            for (int j = 0; j < i; ++j) {
                bA[j] = (BigInt)A.elementAt(j);
            }
            return bA;
        }
    }

    public static void appendByteArray(InputStream in, OutputStream out) throws IOException {
        int i;
        try {
            i = ByteUtils.readInt(in);
        }
        catch (IOException e) {
            throw new IOException("Can't append in to out; in is empty.");
        }
        try {
            for (int j = 0; j < i; ++j) {
                ByteUtils.writeSizeByteArray(out, ByteUtils.readSizeByteArray(in));
            }
        }
        catch (IOException e) {
            throw new IOException("Can't append in to out; not enough bytes, but not empty.");
        }
    }

    public static void appendSizeByteArray(InputStream in, OutputStream out) throws IOException {
        int i;
        try {
            i = ByteUtils.readInt(in);
        }
        catch (IOException e) {
            throw new IOException("Can't append in to out; in is empty.");
        }
        ByteUtils.writeInt(out, i);
        try {
            for (int j = 0; j < i; ++j) {
                ByteUtils.writeSizeByteArray(out, ByteUtils.readSizeByteArray(in));
            }
        }
        catch (IOException e) {
            throw new IOException("Can't append in to out; not enough bytes, but not empty.");
        }
    }

    public static String printHex(byte[] b) {
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            StringBuffer t = new StringBuffer(Integer.toHexString(b[i]));
            if (t.length() > 2) {
                StringBuffer t1 = new StringBuffer();
                t1.append(t.charAt(t.length() - 2));
                t1.append(t.charAt(t.length() - 1));
                t = t1;
            }
            res.append(t);
        }
        return res.toString();
    }
}

