/*
 * Decompiled with CFR 0.152.
 */
package tlc2.debug;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.debug.Breakpoint;
import org.eclipse.lsp4j.debug.Capabilities;
import org.eclipse.lsp4j.debug.ConfigurationDoneArguments;
import org.eclipse.lsp4j.debug.ContinueArguments;
import org.eclipse.lsp4j.debug.ContinueResponse;
import org.eclipse.lsp4j.debug.DisconnectArguments;
import org.eclipse.lsp4j.debug.EvaluateArguments;
import org.eclipse.lsp4j.debug.EvaluateResponse;
import org.eclipse.lsp4j.debug.ExceptionBreakpointsFilter;
import org.eclipse.lsp4j.debug.InitializeRequestArguments;
import org.eclipse.lsp4j.debug.NextArguments;
import org.eclipse.lsp4j.debug.OutputEventArguments;
import org.eclipse.lsp4j.debug.PauseArguments;
import org.eclipse.lsp4j.debug.ScopesArguments;
import org.eclipse.lsp4j.debug.ScopesResponse;
import org.eclipse.lsp4j.debug.SetBreakpointsArguments;
import org.eclipse.lsp4j.debug.SetBreakpointsResponse;
import org.eclipse.lsp4j.debug.SetExceptionBreakpointsArguments;
import org.eclipse.lsp4j.debug.SetVariableArguments;
import org.eclipse.lsp4j.debug.SetVariableResponse;
import org.eclipse.lsp4j.debug.Source;
import org.eclipse.lsp4j.debug.SourceBreakpoint;
import org.eclipse.lsp4j.debug.StackFrame;
import org.eclipse.lsp4j.debug.StackTraceArguments;
import org.eclipse.lsp4j.debug.StackTraceResponse;
import org.eclipse.lsp4j.debug.StepInArguments;
import org.eclipse.lsp4j.debug.StepOutArguments;
import org.eclipse.lsp4j.debug.StoppedEventArguments;
import org.eclipse.lsp4j.debug.TerminateArguments;
import org.eclipse.lsp4j.debug.TerminatedEventArguments;
import org.eclipse.lsp4j.debug.ThreadsResponse;
import org.eclipse.lsp4j.debug.Variable;
import org.eclipse.lsp4j.debug.VariablesArguments;
import org.eclipse.lsp4j.debug.VariablesResponse;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.st.Location;
import tlc2.TLCGlobals;
import tlc2.debug.AbstractDebugger;
import tlc2.debug.AttachingDebugger;
import tlc2.debug.IDebugTarget;
import tlc2.debug.TLCActionStackFrame;
import tlc2.debug.TLCSourceBreakpoint;
import tlc2.debug.TLCStackFrame;
import tlc2.debug.TLCStateStackFrame;
import tlc2.debug.TLCSuccessorsStackFrame;
import tlc2.tool.Action;
import tlc2.tool.INextStateFunctor;
import tlc2.tool.TLCState;
import tlc2.tool.impl.Tool;
import tlc2.util.Context;
import tlc2.value.impl.Value;

public abstract class TLCDebugger
extends AbstractDebugger
implements IDebugTarget {
    protected static Logger LOGGER = Logger.getLogger(TLCDebugger.class.getName());
    protected Launcher<IDebugProtocolClient> launcher;
    private Tool tool;
    protected final Map<String, List<TLCSourceBreakpoint>> breakpoints = new HashMap<String, List<TLCSourceBreakpoint>>();
    protected final LinkedList<TLCStackFrame> stack = new LinkedList();
    private volatile int targetLevel = 1;
    private volatile IDebugTarget.Step step = IDebugTarget.Step.In;
    private volatile boolean halt;

    public TLCDebugger() {
        this.step = IDebugTarget.Step.In;
        this.halt = true;
    }

    public TLCDebugger(IDebugTarget.Step s, boolean halt) {
        this.step = s;
        this.halt = halt;
    }

    public abstract TLCDebugger listen(int var1);

    @Override
    public IDebugTarget setTool(Tool tool) {
        this.tool = tool;
        return this;
    }

    @Override
    public synchronized CompletableFuture<Capabilities> initialize(InitializeRequestArguments args) {
        LOGGER.finer("initialize");
        Executors.newSingleThreadExecutor().submit(() -> {
            LOGGER.finer("initialize -> initialized");
            this.launcher.getRemoteProxy().initialized();
        });
        Capabilities capabilities = new Capabilities();
        capabilities.setSupportsEvaluateForHovers(true);
        capabilities.setSupportsTerminateRequest(true);
        capabilities.setSupportsExceptionInfoRequest(false);
        capabilities.setExceptionBreakpointFilters(this.getExceptionBreakpointFilters());
        capabilities.setSupportsExceptionOptions(false);
        capabilities.setSupportsHitConditionalBreakpoints(true);
        capabilities.setSupportsConditionalBreakpoints(false);
        capabilities.setSupportsLogPoints(false);
        return CompletableFuture.completedFuture(capabilities);
    }

    private ExceptionBreakpointsFilter[] getExceptionBreakpointFilters() {
        ExceptionBreakpointsFilter filter = new ExceptionBreakpointsFilter();
        filter.setDefault_(this.halt);
        filter.setFilter("ExceptionBreakpointsFilter");
        filter.setLabel("Halt (break) on exceptions");
        return new ExceptionBreakpointsFilter[]{filter};
    }

    @Override
    public synchronized CompletableFuture<Void> setExceptionBreakpoints(SetExceptionBreakpointsArguments args) {
        this.halt = Arrays.asList(args.getFilters()).contains("ExceptionBreakpointsFilter");
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletableFuture<EvaluateResponse> evaluate(EvaluateArguments args) {
        if ("hover".equals(args.getContext()) && args.getExpression().startsWith("tlaplus://")) {
            return CompletableFuture.completedFuture(this.stack.stream().filter(f -> f.getId() == args.getFrameId().intValue()).findAny().map(f -> f.get(args)).orElse(new EvaluateResponse()));
        }
        if (!"repl".equals(args.getContext()) && "variables".equals(args.getContext())) {
            EvaluateResponse response = new EvaluateResponse();
            response.setResult(args.getExpression());
            return CompletableFuture.completedFuture(response);
        }
        return CompletableFuture.completedFuture(new EvaluateResponse());
    }

    @Override
    public synchronized CompletableFuture<Void> terminate(TerminateArguments args) {
        LOGGER.finer("terminate");
        if (TLCGlobals.mainChecker != null) {
            TLCGlobals.mainChecker.stop();
        }
        if (TLCGlobals.simulator != null) {
            TLCGlobals.simulator.stop();
        }
        if (this.launcher != null) {
            this.launcher.getRemoteProxy().terminated(new TerminatedEventArguments());
        }
        return this.disconnect(new DisconnectArguments());
    }

    @Override
    public synchronized CompletableFuture<Void> disconnect(DisconnectArguments args) {
        LOGGER.finer("disconnect");
        this.breakpoints.clear();
        this.targetLevel = -1;
        this.step = IDebugTarget.Step.Continue;
        this.halt = false;
        this.notify();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletableFuture<Void> configurationDone(ConfigurationDoneArguments args) {
        LOGGER.finer("configurationDone");
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletableFuture<SetBreakpointsResponse> setBreakpoints(SetBreakpointsArguments args) {
        LOGGER.finer("setBreakpoints");
        String module = args.getSource().getName().replaceFirst(".tla$", "");
        if (args.getBreakpoints() != null && args.getBreakpoints().length > 0) {
            this.breakpoints.computeIfAbsent(module, key -> new ArrayList()).clear();
            ModuleNode moduleNode = this.tool.getModule(module);
            SourceBreakpoint[] sbps = args.getBreakpoints();
            Breakpoint[] bp = new Breakpoint[sbps.length];
            for (int j = 0; j < sbps.length; ++j) {
                final TLCSourceBreakpoint sbp = new TLCSourceBreakpoint(module, sbps[j]);
                this.breakpoints.get(module).add(sbp);
                Breakpoint breakpoint = new Breakpoint();
                breakpoint.setColumn(sbp.getColumn());
                breakpoint.setLine(sbp.getLine());
                breakpoint.setId(j);
                breakpoint.setVerified(moduleNode == null || moduleNode.walkChildren(new SemanticNode.ChildrenVisitor<Boolean>(){
                    private boolean verified = false;

                    @Override
                    public void preVisit(SemanticNode node) {
                        Location location = node.getLocation();
                        if (location.beginLine() == sbp.getLine() && location.endLine() == sbp.getLine()) {
                            this.verified = true;
                        }
                    }

                    @Override
                    public boolean preempt(SemanticNode node) {
                        return this.verified || !node.getLocation().includes(sbp.getLocation());
                    }

                    @Override
                    public Boolean get() {
                        return this.verified;
                    }
                }).get() != false);
                Source source = args.getSource();
                breakpoint.setSource(source);
                bp[j] = breakpoint;
            }
            SetBreakpointsResponse response = new SetBreakpointsResponse();
            response.setBreakpoints(bp);
            return CompletableFuture.completedFuture(response);
        }
        ((List)this.breakpoints.getOrDefault(module, new ArrayList())).clear();
        return CompletableFuture.completedFuture(new SetBreakpointsResponse());
    }

    @Override
    public synchronized CompletableFuture<StackTraceResponse> stackTrace(StackTraceArguments args) {
        int req;
        LOGGER.finer(String.format("stackTrace frame: %s, levels: %s\n", args.getStartFrame(), args.getLevels()));
        StackTraceResponse res = new StackTraceResponse();
        int from = 0;
        if (args.getStartFrame() != null) {
            int req2 = args.getStartFrame();
            if (req2 < 0 || this.stack.size() - 1 < req2) {
                res.setStackFrames(new StackFrame[0]);
                return CompletableFuture.completedFuture(res);
            }
            from = req2;
        }
        int to = this.stack.size();
        if (args.getLevels() != null && (req = args.getLevels().intValue()) > 0 && from + req < to) {
            to = from + req;
        }
        List frames = this.stack.subList(from, to);
        res.setStackFrames(frames.toArray(new StackFrame[frames.size()]));
        res.setTotalFrames(this.stack.size());
        return CompletableFuture.completedFuture(res);
    }

    @Override
    public synchronized CompletableFuture<ScopesResponse> scopes(ScopesArguments args) {
        LOGGER.finer(String.format("scopes frame %s\n", args.getFrameId()));
        ScopesResponse response = new ScopesResponse();
        this.stack.stream().filter(s -> s.getId() == args.getFrameId()).findFirst().ifPresent(frame -> response.setScopes(frame.getScopes()));
        return CompletableFuture.completedFuture(response);
    }

    @Override
    public synchronized CompletableFuture<VariablesResponse> variables(VariablesArguments args) {
        int vr = args.getVariablesReference();
        VariablesResponse value = new VariablesResponse();
        ArrayList<Variable> collect = new ArrayList<Variable>();
        for (TLCStackFrame frame : this.stack) {
            collect.addAll(Arrays.asList(frame.getVariables(vr)));
        }
        value.setVariables(collect.toArray(new Variable[collect.size()]));
        return CompletableFuture.completedFuture(value);
    }

    @Override
    public synchronized CompletableFuture<SetVariableResponse> setVariable(SetVariableArguments args) {
        LOGGER.finer("setVariable");
        return CompletableFuture.completedFuture(new SetVariableResponse());
    }

    @Override
    public synchronized CompletableFuture<ThreadsResponse> threads() {
        LOGGER.finer("threads");
        org.eclipse.lsp4j.debug.Thread thread = new org.eclipse.lsp4j.debug.Thread();
        thread.setId(0);
        thread.setName("worker");
        ThreadsResponse res = new ThreadsResponse();
        res.setThreads(new org.eclipse.lsp4j.debug.Thread[]{thread});
        return CompletableFuture.completedFuture(res);
    }

    @Override
    public synchronized CompletableFuture<ContinueResponse> continue_(ContinueArguments args) {
        LOGGER.finer("continue_");
        this.targetLevel = -1;
        this.step = IDebugTarget.Step.Continue;
        this.notify();
        return CompletableFuture.completedFuture(new ContinueResponse());
    }

    @Override
    public synchronized CompletableFuture<Void> next(NextArguments args) {
        LOGGER.finer("next/stepOver");
        this.targetLevel = this.stack.size();
        this.step = IDebugTarget.Step.Over;
        this.notify();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletableFuture<Void> stepIn(StepInArguments args) {
        LOGGER.finer("stepIn");
        this.step = IDebugTarget.Step.In;
        this.notify();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletableFuture<Void> stepOut(StepOutArguments args) {
        LOGGER.finer("stepOut");
        this.targetLevel = this.stack.size();
        this.step = IDebugTarget.Step.Out;
        this.notify();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletableFuture<Void> pause(PauseArguments args) {
        LOGGER.finer("pause");
        Executors.newSingleThreadExecutor().submit(() -> {
            LOGGER.finer("pause -> stopped");
            StoppedEventArguments eventArguments = new StoppedEventArguments();
            eventArguments.setThreadId(0);
            eventArguments.setReason("pause");
            this.launcher.getRemoteProxy().stopped(eventArguments);
        });
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized IDebugTarget pushFrame(Tool tool, SemanticNode expr, Context c) {
        TLCStackFrame frame = new TLCStackFrame(this.stack.peek(), expr, c, tool);
        this.stack.push(frame);
        this.haltExecution(frame, this.stack.size());
        return this;
    }

    @Override
    public synchronized IDebugTarget pushFrame(Tool tool, SemanticNode expr, Context c, TLCState s) {
        TLCStateStackFrame frame = new TLCStateStackFrame(this.stack.peek(), expr, c, tool, s);
        this.stack.push(frame);
        this.haltExecution(frame, this.stack.size());
        return this;
    }

    @Override
    public synchronized IDebugTarget pushFrame(Tool tool, SemanticNode expr, Context c, TLCState s, Action a, TLCState t) {
        TLCActionStackFrame frame = new TLCActionStackFrame(this.stack.peek(), expr, c, tool, s, a, t);
        this.stack.push(frame);
        this.haltExecution(frame, this.stack.size());
        return this;
    }

    @Override
    public synchronized IDebugTarget pushFrame(Tool tool, OpDefNode expr, Context c, TLCState s, Action a, INextStateFunctor fun) {
        TLCSuccessorsStackFrame frame = new TLCSuccessorsStackFrame(this.stack.peek(), expr, c, tool, s, a, fun);
        this.stack.push(frame);
        return this;
    }

    @Override
    public synchronized IDebugTarget popFrame(Tool tool, OpDefNode expr, Context c, TLCState s, Action a, INextStateFunctor fun) {
        TLCStackFrame frame = this.stack.peek();
        if (frame != null && this.matches(frame)) {
            this.haltExecution(frame);
        }
        return this.popFrame(s);
    }

    @Override
    public synchronized IDebugTarget pushFrame(TLCState s) {
        TLCStackFrame f = this.stack.peek();
        this.pushFrame(f.getTool(), f.getNode(), f.getContext(), s);
        return this;
    }

    @Override
    public synchronized IDebugTarget pushFrame(TLCState s, Action a, TLCState t) {
        TLCStackFrame f = this.stack.peek();
        return this.pushFrame(f.getTool(), f.getNode(), f.getContext(), s, a, t);
    }

    @Override
    public synchronized IDebugTarget popFrame(TLCState state) {
        TLCStackFrame f = this.stack.peek();
        return this.popFrame(f.getTool(), f.getNode(), f.getContext(), state);
    }

    @Override
    public synchronized IDebugTarget popFrame(TLCState s, TLCState t) {
        return this.popFrame(t);
    }

    @Override
    public synchronized IDebugTarget popFrame(Tool tool, SemanticNode expr, Context c) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(String.format("%s Call popFrame: [%s], level: %s\n", new String(new char[this.stack.size()]).replace('\u0000', '#'), expr, this.stack.size()));
        }
        TLCStackFrame pop = this.stack.pop();
        assert (expr == pop.getNode());
        return this;
    }

    @Override
    public synchronized IDebugTarget popFrame(Tool tool, SemanticNode expr, Context c, Value v) {
        this.popFrame(tool, expr, c);
        TLCStackFrame peeked = this.stack.peek();
        if (peeked != null && peeked.node.myUID == expr.myUID) {
            this.stack.peek().setValue(v);
        }
        return this;
    }

    @Override
    public synchronized IDebugTarget popFrame(Tool tool, SemanticNode expr, Context c, TLCState s) {
        TLCStackFrame pop = this.stack.pop();
        assert (expr == pop.getNode());
        return this;
    }

    @Override
    public synchronized IDebugTarget popFrame(Tool tool, SemanticNode expr, Context c, Value v, TLCState t) {
        this.popFrame(tool, expr, c, v);
        return this;
    }

    @Override
    public synchronized IDebugTarget popFrame(Tool tool, SemanticNode expr, Context c, TLCState s, TLCState t) {
        return this.popFrame(tool, expr, c);
    }

    @Override
    public synchronized IDebugTarget popFrame(Tool tool, SemanticNode expr, Context c, Value v, TLCState s, TLCState t) {
        this.popFrame(tool, expr, c, v);
        return this;
    }

    @Override
    public synchronized IDebugTarget pushExceptionFrame(Tool tool, SemanticNode expr, Context c, RuntimeException e) {
        return this.pushExceptionFrame(new TLCStackFrame(this.stack.peek(), expr, c, tool, e), e);
    }

    @Override
    public synchronized IDebugTarget pushExceptionFrame(Tool tool, SemanticNode expr, Context c, TLCState state, RuntimeException e) {
        return this.pushExceptionFrame(new TLCStateStackFrame(this.stack.peek(), expr, c, tool, state, e), e);
    }

    @Override
    public synchronized IDebugTarget pushExceptionFrame(Tool tool, SemanticNode expr, Context c, TLCState s, Action a, TLCState t, RuntimeException e) {
        return this.pushExceptionFrame(new TLCActionStackFrame(this.stack.peek(), expr, c, tool, s, a, t, e), e);
    }

    private IDebugTarget pushExceptionFrame(TLCStackFrame frame, RuntimeException e) {
        this.stack.push(frame);
        OutputEventArguments oea = new OutputEventArguments();
        oea.setOutput(e.getMessage());
        if (this.launcher != null) {
            this.launcher.getRemoteProxy().output(oea);
        }
        if (this.halt) {
            this.haltExecution(frame);
        }
        return this;
    }

    protected void haltExecution(TLCStackFrame frame, int level) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(String.format("%s(%s): [%s]\n", new String(new char[level]).replace('\u0000', '#'), level, frame.getNode()));
        }
        if (TLCDebugger.matches(this.step, this.targetLevel, level) || this.matches(frame)) {
            this.haltExecution(frame);
        }
    }

    protected void haltExecution(TLCStackFrame frame) {
        this.sendStopped(frame);
        try {
            this.wait();
        }
        catch (InterruptedException notExpectedToHappen) {
            notExpectedToHappen.printStackTrace();
            Thread.currentThread().interrupt();
        }
    }

    protected void sendStopped(TLCStackFrame frame) {
        LOGGER.finer("loadSource -> stopped");
        if (this.launcher != null) {
            StoppedEventArguments eventArguments = frame.getStoppedEventArgument();
            eventArguments.setThreadId(0);
            this.launcher.getRemoteProxy().stopped(eventArguments);
        }
    }

    private static boolean matches(IDebugTarget.Step dir, int targetLevel, int currentLevel) {
        if (dir == IDebugTarget.Step.In) {
            return true;
        }
        return dir == IDebugTarget.Step.Over ? currentLevel == targetLevel : dir == IDebugTarget.Step.Out && (currentLevel < targetLevel || currentLevel == 0);
    }

    private boolean matches(TLCStackFrame frame) {
        return ((List)this.breakpoints.getOrDefault(frame.getNode().getLocation().source(), new ArrayList())).stream().anyMatch(b -> frame.matches((TLCSourceBreakpoint)b));
    }

    public static class Factory {
        public static TLCDebugger OVERRIDE;

        public static TLCDebugger getInstance(boolean suspend, boolean halt) throws Exception {
            if (OVERRIDE != null) {
                return OVERRIDE;
            }
            if (suspend) {
                return new AttachingDebugger(IDebugTarget.Step.In, halt);
            }
            return new AttachingDebugger(IDebugTarget.Step.Continue, halt);
        }
    }
}

