/*
 * Decompiled with CFR 0.152.
 */
package tlc2.output;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import tlc2.model.Assignment;
import tlc2.model.TypedSet;
import tlc2.output.SpecWriterUtilities;

public abstract class AbstractSpecWriter {
    protected static final String CLOSING_SEP = "\n----\n";
    protected final StringBuilder tlaBuffer = new StringBuilder();
    protected final StringBuilder cfgBuffer;

    public static String addArrowAssignmentToBuffers(StringBuilder tlaBuffer, StringBuilder cfgBuffer, Assignment constant, String schema) {
        String identifier = SpecWriterUtilities.getValidIdentifier(schema);
        return AbstractSpecWriter.addArrowAssignmentIdToBuffers(tlaBuffer, cfgBuffer, constant, identifier, identifier);
    }

    public static String addArrowAssignmentIdToBuffers(StringBuilder tlaBuffer, StringBuilder cfgBuffer, Assignment constant, String id, String configId) {
        tlaBuffer.append(constant.getParametrizedLabel(id)).append(" == ").append("\n");
        tlaBuffer.append(constant.getRight()).append("\n");
        if (cfgBuffer != null) {
            cfgBuffer.append("\n").append("CONSTANT").append("\n");
            cfgBuffer.append("    ").append(constant.getLabel()).append(" <- ").append(configId).append("\n");
        }
        return id;
    }

    protected AbstractSpecWriter(boolean generateConfigurationContent) {
        this.cfgBuffer = generateConfigurationContent ? new StringBuilder() : null;
    }

    protected String getTLAModuleClosingTag() {
        StringBuilder sb = SpecWriterUtilities.getModuleClosingTag(77, false);
        return sb.toString();
    }

    void appendContentToBuffers(String tla, String cfg) {
        if (tla != null) {
            this.tlaBuffer.append(tla);
        }
        if (cfg != null) {
            this.cfgBuffer.append(cfg);
        }
    }

    public void writeStreams(OutputStream tlaStream, OutputStream cfgStream) throws IOException {
        ContentWriter cw = (inputStream, forTlaFile) -> {
            OutputStream outputStream;
            OutputStream outputStream2 = outputStream = forTlaFile ? tlaStream : cfgStream;
            if (null != outputStream) {
                int length;
                byte[] buffer = new byte[8192];
                while ((length = inputStream.read(buffer)) > 0) {
                    outputStream.write(buffer, 0, length);
                }
            }
        };
        this.writeFiles(cw);
    }

    public void writeFiles(File tlaFile, File cfgFile) throws IOException {
        ContentWriter cw = (inputStream, forTLAFile) -> {
            File f;
            File file = f = forTLAFile ? tlaFile : cfgFile;
            if (f != null) {
                Files.copy(inputStream, f.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        };
        this.writeFiles(cw);
    }

    protected void writeFiles(ContentWriter contentWriter) throws IOException {
        this.tlaBuffer.append(this.getTLAModuleClosingTag());
        ByteArrayInputStream tlaBAIS = new ByteArrayInputStream(this.tlaBuffer.toString().getBytes());
        contentWriter.writeStreamToFile(tlaBAIS, true);
        if (this.cfgBuffer != null) {
            this.cfgBuffer.append((CharSequence)SpecWriterUtilities.getGeneratedTimeStampCommentLine());
            ByteArrayInputStream configurationBAIS = new ByteArrayInputStream(this.cfgBuffer.toString().getBytes());
            contentWriter.writeStreamToFile(configurationBAIS, false);
        }
    }

    public void addPrimer(String moduleFilename, String extendedModuleName) {
        this.tlaBuffer.append((CharSequence)SpecWriterUtilities.getExtendingModuleContent(moduleFilename, extendedModuleName, "TLC"));
    }

    public void addSpecDefinition(String[] specDefinition, String attributeName) {
        if (this.cfgBuffer != null) {
            this.cfgBuffer.append("SPECIFICATION").append(" ");
            this.cfgBuffer.append(specDefinition[0]).append("\n");
        }
        this.tlaBuffer.append("\\* ").append("SPECIFICATION").append(" ");
        this.tlaBuffer.append("@").append(attributeName).append("\n");
        this.tlaBuffer.append(specDefinition[1]).append(CLOSING_SEP);
    }

    public void addInitNextDefinitions(String[] initDefinition, String[] nextDefinition, String initAttributeName, String nextAttributeName) {
        if (this.cfgBuffer != null) {
            this.cfgBuffer.append("\\* ").append("INIT").append(" definition");
            this.cfgBuffer.append("\n").append("INIT").append("\n");
            this.cfgBuffer.append(initDefinition[0]).append("\n");
        }
        this.tlaBuffer.append("\\* ").append("INIT").append(" definition ");
        this.tlaBuffer.append("@").append(initAttributeName).append("\n");
        this.tlaBuffer.append(initDefinition[1]).append("\n");
        if (this.cfgBuffer != null) {
            this.cfgBuffer.append("\\* ").append("NEXT").append(" definition");
            this.cfgBuffer.append("\n").append("NEXT").append("\n");
            this.cfgBuffer.append(nextDefinition[0]).append("\n");
        }
        this.tlaBuffer.append("\\* ").append("NEXT").append(" definition ");
        this.tlaBuffer.append("@").append(nextAttributeName).append("\n");
        this.tlaBuffer.append(nextDefinition[1]).append("\n");
    }

    public void addConstants(List<String> rawConstants) {
        for (String constant : rawConstants) {
            this.cfgBuffer.append(constant);
            this.cfgBuffer.append("\n");
        }
    }

    public void addConstants(List<Assignment> constants, TypedSet modelValues, String attributeConstants, String attributeMVs) {
        Assignment constant;
        int i;
        this.addMVTypedSet(modelValues, "MV CONSTANT declarations ", attributeMVs);
        ArrayList<String> symmetrySets = new ArrayList<String>();
        for (i = 0; i < constants.size(); ++i) {
            constant = constants.get(i);
            if (!constant.isModelValue() || !constant.isSetOfModelValues()) continue;
            this.addMVTypedSet(constant.getSetOfModelValues(), "MV CONSTANT declarations", attributeConstants);
        }
        for (i = 0; i < constants.size(); ++i) {
            constant = constants.get(i);
            if (!constant.isModelValue()) continue;
            if (constant.isSetOfModelValues()) {
                if (this.cfgBuffer != null) {
                    this.cfgBuffer.append("\\* ").append("MV CONSTANT definitions").append("\n");
                }
                this.tlaBuffer.append("\\* ").append("MV CONSTANT definitions " + constant.getLeft());
                this.tlaBuffer.append("\n");
                String id = this.addArrowAssignment(constant, "const");
                if (constant.isSymmetricalSet()) {
                    symmetrySets.add(id);
                }
                this.tlaBuffer.append("----").append("\n").append("\n");
                continue;
            }
            if (this.cfgBuffer == null) continue;
            this.cfgBuffer.append("\\* ").append("CONSTANT").append(" declarations").append("\n");
            this.cfgBuffer.append("CONSTANT").append(" ").append(constant.getLabel());
            this.cfgBuffer.append(" = ").append(constant.getRight()).append("\n");
        }
        if (!symmetrySets.isEmpty()) {
            String label = SpecWriterUtilities.getValidIdentifier("symm");
            this.tlaBuffer.append("\\* ").append("SYMMETRY").append(" definition").append("\n");
            if (this.cfgBuffer != null) {
                this.cfgBuffer.append("\\* ").append("SYMMETRY").append(" definition").append("\n");
            }
            this.tlaBuffer.append(label).append(" == ").append("\n");
            for (int i2 = 0; i2 < symmetrySets.size(); ++i2) {
                this.tlaBuffer.append("Permutations").append("(");
                this.tlaBuffer.append((String)symmetrySets.get(i2)).append(")");
                if (i2 == symmetrySets.size() - 1) continue;
                this.tlaBuffer.append(' ').append("\\union").append(' ');
            }
            this.tlaBuffer.append(CLOSING_SEP).append("\n");
            if (this.cfgBuffer != null) {
                this.cfgBuffer.append("SYMMETRY").append(" ").append(label).append("\n");
            }
        }
    }

    public void addConstantsBis(List<Assignment> constants, String attributeConstants) {
        for (int i = 0; i < constants.size(); ++i) {
            Assignment constant = constants.get(i);
            if (constant.isModelValue()) continue;
            if (this.cfgBuffer != null) {
                this.cfgBuffer.append("\\* ").append("CONSTANT").append(" definitions");
                this.cfgBuffer.append("\n");
            }
            this.tlaBuffer.append("\\* ").append("CONSTANT").append(" definitions ");
            this.tlaBuffer.append("@").append(attributeConstants).append(":");
            this.tlaBuffer.append(i).append(constant.getLeft()).append("\n");
            this.addArrowAssignment(constant, "const");
            this.tlaBuffer.append("----").append("\n").append("\n");
        }
    }

    public void addConstantExpressionEvaluation(String expression, String attributeName) {
        if (expression.trim().length() != 0) {
            String id = SpecWriterUtilities.getValidIdentifier("const_expr");
            this.tlaBuffer.append("\\* ").append("Constant expression definition ");
            this.tlaBuffer.append("@").append(attributeName).append("\n");
            this.tlaBuffer.append(id).append(" == ").append("\n").append(expression);
            this.tlaBuffer.append(CLOSING_SEP).append("\n");
            this.tlaBuffer.append("\\* ").append("Constant expression ASSUME statement ");
            this.tlaBuffer.append("@").append(attributeName).append("\n");
            this.tlaBuffer.append("ASSUME PrintT(").append("<<");
            this.tlaBuffer.append("\"$!@$!@$!@$!@$!\"").append(",").append(id);
            this.tlaBuffer.append(">>").append(")").append(CLOSING_SEP).append("\n");
        }
    }

    public void addNewDefinitions(String definitions, String attributeName) {
        if (definitions.trim().length() == 0) {
            return;
        }
        this.tlaBuffer.append("\\* ").append("New definitions ");
        this.tlaBuffer.append("@").append(attributeName).append("\n");
        this.tlaBuffer.append(definitions).append(CLOSING_SEP);
    }

    public void addFormulaList(String element, String keyword, String attributeName) {
        ArrayList<String[]> elements = new ArrayList<String[]>(1);
        elements.add(new String[]{element, ""});
        this.addFormulaList(elements, keyword, attributeName);
    }

    public void addFormulaList(List<String[]> elements, String keyword, String attributeName) {
        if (elements.isEmpty()) {
            return;
        }
        if (this.cfgBuffer != null) {
            this.cfgBuffer.append("\\* ").append(keyword + " definition").append("\n");
            this.cfgBuffer.append(keyword).append("\n");
        }
        for (int i = 0; i < elements.size(); ++i) {
            String[] element = elements.get(i);
            if (this.cfgBuffer != null) {
                this.cfgBuffer.append(element[0]).append("\n");
            }
            if (element[1].equals("")) continue;
            this.tlaBuffer.append("\\* ").append(keyword + " definition ").append("@");
            this.tlaBuffer.append(attributeName).append(":").append(element.length > 2 ? element[2] : Integer.valueOf(i));
            this.tlaBuffer.append("\n").append(element[1]).append(CLOSING_SEP);
        }
    }

    public void addView(String viewString, String attributeName) {
        if (viewString.trim().length() != 0) {
            String id = SpecWriterUtilities.getValidIdentifier("view");
            if (this.cfgBuffer != null) {
                this.cfgBuffer.append("\\* ").append("VIEW definition").append("\n");
                this.cfgBuffer.append("VIEW").append("\n").append(id).append("\n");
            }
            this.tlaBuffer.append("\\* ").append("VIEW definition ").append("@");
            this.tlaBuffer.append(attributeName).append("\n");
            this.tlaBuffer.append(id).append(" == ").append("\n").append(viewString);
            this.tlaBuffer.append(CLOSING_SEP).append("\n");
        }
    }

    public void addPostCondition(String postConditionString, String attributeName) {
        if (postConditionString.trim().length() != 0) {
            String id = SpecWriterUtilities.getValidIdentifier("postcondition");
            if (this.cfgBuffer != null) {
                this.cfgBuffer.append("\\* ").append("POSTCONDITION definition").append("\n");
                this.cfgBuffer.append("POSTCONDITION").append("\n").append(id).append("\n");
            }
            this.tlaBuffer.append("\\* ").append("POSTCONDITION definition ").append("@");
            this.tlaBuffer.append(attributeName).append("\n");
            this.tlaBuffer.append(id).append(" == ").append("\n").append(postConditionString);
            this.tlaBuffer.append(CLOSING_SEP).append("\n");
        }
    }

    public void addAlias(String aliasString, String attributeName) {
        if (aliasString.trim().length() != 0) {
            String id = SpecWriterUtilities.getValidIdentifier("alias");
            this.addAliasToCfg(id);
            this.tlaBuffer.append("\\* ").append("ALIAS definition ").append("@");
            this.tlaBuffer.append(attributeName).append("\n");
            this.tlaBuffer.append(id).append(" == ").append("\n").append(aliasString);
            this.tlaBuffer.append(CLOSING_SEP).append("\n");
        }
    }

    public void addAliasToCfg(String aliasName) {
        if (this.cfgBuffer != null) {
            this.cfgBuffer.append("\n");
            this.cfgBuffer.append("ALIAS").append("\n");
            this.cfgBuffer.append("    ").append(aliasName).append("\n");
        }
    }

    public String addArrowAssignment(Assignment constant, String schema) {
        return AbstractSpecWriter.addArrowAssignmentToBuffers(this.tlaBuffer, this.cfgBuffer, constant, schema);
    }

    public void addMVTypedSet(TypedSet mvSet, String comment, String attributeName) {
        if (mvSet.getValueCount() != 0) {
            if (comment != null && comment.length() != 0) {
                this.tlaBuffer.append("\\* ").append(comment).append("@");
                this.tlaBuffer.append(attributeName).append("\n");
            }
            this.tlaBuffer.append("CONSTANTS").append("\n").append(mvSet.toStringWithoutBraces());
            this.tlaBuffer.append(CLOSING_SEP).append("\n");
            if (this.cfgBuffer != null) {
                if (comment != null && comment.length() != 0) {
                    this.cfgBuffer.append("\\* ").append(comment).append("\n");
                }
                this.cfgBuffer.append("CONSTANTS").append("\n");
                for (int i = 0; i < mvSet.getValueCount(); ++i) {
                    String mv = mvSet.getValue(i);
                    this.cfgBuffer.append(mv).append(" = ").append(mv).append("\n");
                }
            }
        }
    }

    protected static interface ContentWriter {
        public void writeStreamToFile(InputStream var1, boolean var2) throws IOException;
    }
}

