/*
 * Decompiled with CFR 0.152.
 */
package tlc2;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import model.InJarFilenameToStream;
import model.ModelInJar;
import tlc2.TLCGlobals;
import tlc2.TraceExplorationSpec;
import tlc2.debug.TLCDebugger;
import tlc2.output.EC;
import tlc2.output.ErrorTraceMessagePrinterRecorder;
import tlc2.output.MP;
import tlc2.output.Messages;
import tlc2.tool.DFIDModelChecker;
import tlc2.tool.ITLCCustomHandler;
import tlc2.tool.ITool;
import tlc2.tool.ModelChecker;
import tlc2.tool.Simulator;
import tlc2.tool.SingleThreadedSimulator;
import tlc2.tool.fp.FPSet;
import tlc2.tool.fp.FPSetConfiguration;
import tlc2.tool.fp.FPSetFactory;
import tlc2.tool.impl.DebugTool;
import tlc2.tool.impl.FastTool;
import tlc2.tool.impl.Tool;
import tlc2.tool.management.ModelCheckerMXWrapper;
import tlc2.tool.management.TLCStandardMBean;
import tlc2.util.DotStateWriter;
import tlc2.util.FP64;
import tlc2.util.IStateWriter;
import tlc2.util.NoopStateWriter;
import tlc2.util.RandomGenerator;
import tlc2.util.StateWriter;
import tlc2.value.RandomEnumerableValues;
import util.Assert;
import util.DebugPrinter;
import util.ExecutionStatisticsCollector;
import util.FileUtil;
import util.FilenameToStream;
import util.MailSender;
import util.SimpleFilenameToStream;
import util.TLCRuntime;
import util.ToolIO;
import util.UniqueString;
import util.UsageGenerator;

public class TLC {
    private static boolean MODEL_PART_OF_JAR = false;
    private RunMode runMode;
    private boolean cleanup = false;
    private boolean deadlock = true;
    private boolean noSeed = true;
    private long seed = 0L;
    private long aril = 0L;
    private long startTime;
    private String mainFile = null;
    private String configFile = null;
    private String metadir;
    private IStateWriter stateWriter = new NoopStateWriter();
    private String fromChkpt = null;
    private int fpIndex;
    private static long traceNum = Long.MAX_VALUE;
    private String traceFile = null;
    private String traceActions = null;
    private int traceDepth = 100;
    private FilenameToStream resolver = null;
    private boolean welcomePrinted = false;
    private FPSetConfiguration fpSetConfiguration;
    private int debugPort = -1;
    private boolean suspend = true;
    private boolean halt = true;
    private volatile ITool tool;
    private final ErrorTraceMessagePrinterRecorder recorder = new ErrorTraceMessagePrinterRecorder();
    private TraceExplorationSpec teSpec;

    public TLC() {
        this.runMode = RunMode.MODEL_CHECK;
        this.fpIndex = new Random().nextInt(FP64.Polys.length);
        this.fpSetConfiguration = new FPSetConfiguration();
    }

    public static void main(String[] args) throws Exception {
        TLC tlc = new TLC();
        if (!tlc.handleParameters(args)) {
            System.exit(1);
        }
        if (!tlc.checkEnvironment()) {
            System.exit(1);
        }
        MailSender ms = new MailSender();
        if (MODEL_PART_OF_JAR) {
            tlc.setResolver(new InJarFilenameToStream("/model/"));
        } else {
            String dir = FileUtil.parseDirname(tlc.getMainFile());
            if (!dir.isEmpty()) {
                tlc.setResolver(new SimpleFilenameToStream(dir));
            } else {
                tlc.setResolver(new SimpleFilenameToStream());
            }
        }
        ms.setModelName(tlc.getModelName());
        ms.setSpecName(tlc.getSpecName());
        int errorCode = tlc.process();
        boolean mailSent = ms.send(tlc.getModuleFiles());
        if (!mailSent) {
            System.exit(1);
        }
        System.exit(EC.ExitStatus.errorConstantToExitStatus(errorCode));
    }

    private boolean checkEnvironment() {
        if (!TLCRuntime.getInstance().isThroughputOptimizedGC()) {
            MP.printWarning(2401);
        }
        return true;
    }

    public static void setTraceNum(long aTraceNum) {
        traceNum = aTraceNum;
    }

    public boolean handleParameters(String[] args) {
        String dumpFile = null;
        boolean asDot = false;
        boolean colorize = false;
        boolean actionLabels = false;
        boolean snapshot = false;
        boolean generateTESpec = true;
        Path teSpecOutDir = null;
        int index = 0;
        while (index < args.length) {
            if (args[index].equals("-simulate") || args[index].equals("-generate")) {
                if (args[index].equals("-generate")) {
                    System.setProperty(Tool.class.getName() + ".probabilistic", Boolean.TRUE.toString());
                }
                this.runMode = RunMode.SIMULATE;
                if (++index >= args.length || !args[index].contains("stats=") && !args[index].contains("file=") && !args[index].contains("num=")) continue;
                String[] simArgs = args[index].split(",");
                ++index;
                for (String arg : simArgs) {
                    if (arg.startsWith("num=")) {
                        traceNum = Long.parseLong(arg.replace("num=", ""));
                        continue;
                    }
                    if (arg.startsWith("file=")) {
                        this.traceFile = arg.replace("file=", "");
                        continue;
                    }
                    if (arg.equals("stats=basic")) {
                        this.traceActions = "BASIC";
                        continue;
                    }
                    if (!arg.equals("stats=full")) continue;
                    this.traceActions = "FULL";
                }
                continue;
            }
            if (args[index].equals("-modelcheck")) {
                ++index;
                continue;
            }
            if (args[index].equals("-difftrace")) {
                ++index;
                TLCGlobals.printDiffsOnly = true;
                continue;
            }
            if (args[index].equals("-deadlock")) {
                ++index;
                this.deadlock = false;
                continue;
            }
            if (args[index].equals("-cleanup")) {
                ++index;
                this.cleanup = true;
                continue;
            }
            if (args[index].equals("-nowarning")) {
                ++index;
                TLCGlobals.warn = false;
                continue;
            }
            if (args[index].equals("-gzip")) {
                ++index;
                TLCGlobals.useGZIP = true;
                continue;
            }
            if (args[index].equals("-terse")) {
                ++index;
                TLCGlobals.expand = false;
                continue;
            }
            if (args[index].equals("-continue")) {
                ++index;
                TLCGlobals.continuation = true;
                continue;
            }
            if (args[index].equals("-view")) {
                ++index;
                TLCGlobals.useView = true;
                continue;
            }
            if (args[index].equals("-debug")) {
                ++index;
                TLCGlobals.debug = true;
                continue;
            }
            if (args[index].equals("-debugger")) {
                this.debugPort = 4712;
                if (++index >= args.length || !args[index].contains("port=") && !args[index].contains("nosuspend") && !args[index].contains("nohalt")) continue;
                this.suspend = !args[index].toLowerCase().contains("nosuspend");
                this.halt = !args[index].toLowerCase().contains("nohalt");
                Matcher matcher = Pattern.compile(".*port=([0-9]{1,5}).*").matcher(args[index]);
                if (matcher.find()) {
                    this.debugPort = Integer.parseInt(matcher.group(1));
                }
                ++index;
                continue;
            }
            if (args[index].equals("-tool")) {
                ++index;
                TLCGlobals.tool = true;
                continue;
            }
            if (args[index].equals("-generateSpecTE")) {
                if (++index >= args.length || !args[index].equals("nomonolith")) continue;
                ++index;
                continue;
            }
            if (args[index].equals("-noGenerateSpecTE") || args[index].equalsIgnoreCase("-noTE")) {
                ++index;
                generateTESpec = false;
                continue;
            }
            if (args[index].equals("-teSpecOutDir")) {
                if (++index < args.length) {
                    String path = args[index];
                    try {
                        teSpecOutDir = Paths.get(path, new String[0]);
                    }
                    catch (InvalidPathException e) {
                        this.printErrorMsg("Error: invalid path for -teSpecOutDir option: " + path);
                        return false;
                    }
                    ++index;
                    continue;
                }
                this.printErrorMsg("Error: expected a path for -teSpecOutDir option.");
                return false;
            }
            if (args[index].equals("-help") || args[index].equals("-h")) {
                this.printUsage();
                return false;
            }
            if (args[index].equals("-lncheck")) {
                if (++index < args.length) {
                    TLCGlobals.lnCheck = args[index].toLowerCase();
                    ++index;
                    continue;
                }
                this.printErrorMsg("Error: expect a strategy such as final for -lncheck option.");
                return false;
            }
            if (args[index].equals("-config")) {
                if (++index < args.length) {
                    this.configFile = args[index];
                    if (this.configFile.endsWith(".cfg")) {
                        this.configFile = this.configFile.substring(0, this.configFile.length() - ".cfg".length());
                    }
                    ++index;
                    continue;
                }
                this.printErrorMsg("Error: expect a file name for -config option.");
                return false;
            }
            if (args[index].equals("-dump")) {
                if (++index + 1 < args.length && args[index].startsWith("dot")) {
                    String dotArgs = args[index].toLowerCase();
                    asDot = true;
                    colorize = dotArgs.contains("colorize");
                    actionLabels = dotArgs.contains("actionlabels");
                    snapshot = dotArgs.contains("snapshot");
                    int n = ++index;
                    ++index;
                    dumpFile = TLC.getDumpFile(args[n], ".dot");
                    continue;
                }
                if (index < args.length) {
                    dumpFile = TLC.getDumpFile(args[index++], ".dump");
                    continue;
                }
                this.printErrorMsg("Error: A file name for dumping states required.");
                return false;
            }
            if (args[index].equals("-coverage")) {
                if (++index < args.length) {
                    try {
                        TLCGlobals.coverageInterval = Integer.parseInt(args[index]) * 60 * 1000;
                        if (TLCGlobals.coverageInterval < 0) {
                            this.printErrorMsg("Error: expect a nonnegative integer for -coverage option.");
                            return false;
                        }
                        ++index;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.printErrorMsg("Error: An integer for coverage report interval required. But encountered " + args[index]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: coverage report interval required.");
                return false;
            }
            if (args[index].equals("-checkpoint")) {
                if (++index < args.length) {
                    try {
                        TLCGlobals.chkptDuration = Integer.parseInt(args[index]) * 1000 * 60;
                        if (TLCGlobals.chkptDuration < 0L) {
                            this.printErrorMsg("Error: expect a nonnegative integer for -checkpoint option.");
                            return false;
                        }
                        ++index;
                        continue;
                    }
                    catch (Exception e) {
                        this.printErrorMsg("Error: An integer for checkpoint interval is required. But encountered " + args[index]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: checkpoint interval required.");
                return false;
            }
            if (args[index].equals("-depth")) {
                if (++index < args.length) {
                    try {
                        this.traceDepth = Integer.parseInt(args[index]);
                        ++index;
                        continue;
                    }
                    catch (Exception e) {
                        this.printErrorMsg("Error: An integer for trace length required. But encountered " + args[index]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: trace length required.");
                return false;
            }
            if (args[index].equals("-seed")) {
                if (++index < args.length) {
                    try {
                        this.seed = Long.parseLong(args[index]);
                        ++index;
                        this.noSeed = false;
                        continue;
                    }
                    catch (Exception e) {
                        this.printErrorMsg("Error: An integer for seed required. But encountered " + args[index]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: seed required.");
                return false;
            }
            if (args[index].equals("-aril")) {
                if (++index < args.length) {
                    try {
                        this.aril = Long.parseLong(args[index]);
                        ++index;
                        continue;
                    }
                    catch (Exception e) {
                        this.printErrorMsg("Error: An integer for aril required. But encountered " + args[index]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: aril required.");
                return false;
            }
            if (args[index].equals("-maxSetSize")) {
                if (++index < args.length) {
                    try {
                        int bound = Integer.parseInt(args[index]);
                        if (!TLCGlobals.isValidSetSize(bound)) {
                            int maxValue = Integer.MAX_VALUE;
                            this.printErrorMsg("Error: Value in interval [0, " + maxValue + "] for maxSetSize required. But encountered " + args[index]);
                            return false;
                        }
                        TLCGlobals.setBound = bound;
                        ++index;
                        continue;
                    }
                    catch (Exception e) {
                        this.printErrorMsg("Error: An integer for maxSetSize required. But encountered " + args[index]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: maxSetSize required.");
                return false;
            }
            if (args[index].equals("-recover")) {
                if (++index < args.length) {
                    this.fromChkpt = args[index++] + FileUtil.separator;
                    continue;
                }
                this.printErrorMsg("Error: need to specify the metadata directory for recovery.");
                return false;
            }
            if (args[index].equals("-metadir")) {
                if (++index < args.length) {
                    TLCGlobals.metaDir = args[index++] + FileUtil.separator;
                    continue;
                }
                this.printErrorMsg("Error: need to specify the metadata directory.");
                return false;
            }
            if (args[index].equals("-userFile")) {
                if (++index < args.length) {
                    try {
                        tlc2.module.TLC.OUTPUT = new BufferedWriter(new FileWriter(new File(args[index++])));
                        continue;
                    }
                    catch (IOException e) {
                        this.printErrorMsg("Error: Failed to create user output log file.");
                        return false;
                    }
                }
                this.printErrorMsg("Error: need to specify the full qualified file.");
                return false;
            }
            if (args[index].equals("-workers")) {
                if (++index < args.length) {
                    try {
                        int num;
                        int n = num = args[index].trim().toLowerCase().equals("auto") ? Runtime.getRuntime().availableProcessors() : Integer.parseInt(args[index]);
                        if (num < 1) {
                            this.printErrorMsg("Error: at least one worker required.");
                            return false;
                        }
                        TLCGlobals.setNumWorkers(num);
                        ++index;
                        continue;
                    }
                    catch (Exception e) {
                        this.printErrorMsg("Error: worker number or 'auto' required. But encountered " + args[index]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: expect an integer or 'auto' for -workers option.");
                return false;
            }
            if (args[index].equals("-dfid")) {
                if (++index < args.length) {
                    try {
                        TLCGlobals.DFIDMax = Integer.parseInt(args[index]);
                        if (TLCGlobals.DFIDMax < 0) {
                            this.printErrorMsg("Error: expect a nonnegative integer for -dfid option.");
                            return false;
                        }
                        ++index;
                        continue;
                    }
                    catch (Exception e) {
                        this.printErrorMsg("Error: expect a nonnegative integer for -dfid option. But encountered " + args[index]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: expect a nonnegative integer for -dfid option.");
                return false;
            }
            if (args[index].equals("-fp")) {
                if (++index < args.length) {
                    try {
                        this.fpIndex = Integer.parseInt(args[index]);
                        if (this.fpIndex < 0 || this.fpIndex >= FP64.Polys.length) {
                            this.printErrorMsg("Error: The number for -fp must be between 0 and " + (FP64.Polys.length - 1) + " (inclusive).");
                            return false;
                        }
                        ++index;
                        continue;
                    }
                    catch (Exception e) {
                        this.printErrorMsg("Error: A number for -fp is required. But encountered " + args[index]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: expect an integer for -fp option.");
                return false;
            }
            if (args[index].equals("-fpmem")) {
                if (++index < args.length) {
                    try {
                        double fpMemSize = Double.parseDouble(args[index]);
                        if (fpMemSize < 0.0) {
                            this.printErrorMsg("Error: An positive integer or a fraction for fpset memory size/percentage required. But encountered " + args[index]);
                            return false;
                        }
                        if (fpMemSize > 1.0) {
                            ToolIO.out.println("Using -fpmem with an abolute memory value has been deprecated. Please allocate memory for the TLC process via the JVM mechanisms and use -fpmem to set the fraction to be used for fingerprint storage.");
                            this.fpSetConfiguration.setMemory((long)fpMemSize);
                            this.fpSetConfiguration.setRatio(1.0);
                        } else {
                            this.fpSetConfiguration.setRatio(fpMemSize);
                        }
                        ++index;
                        continue;
                    }
                    catch (Exception e) {
                        this.printErrorMsg("Error: An positive integer or a fraction for fpset memory size/percentage required. But encountered " + args[index]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: fpset memory size required.");
                return false;
            }
            if (args[index].equals("-fpbits")) {
                if (++index < args.length) {
                    try {
                        int fpBits = Integer.parseInt(args[index]);
                        if (!FPSet.isValid(fpBits)) {
                            this.printErrorMsg("Error: Value in interval [0, 30] for fpbits required. But encountered " + args[index]);
                            return false;
                        }
                        this.fpSetConfiguration.setFpBits(fpBits);
                        ++index;
                        continue;
                    }
                    catch (Exception e) {
                        this.printErrorMsg("Error: An integer for fpbits required. But encountered " + args[index]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: fpbits required.");
                return false;
            }
            if (args[index].charAt(0) == '-') {
                this.printErrorMsg("Error: unrecognized option: " + args[index]);
                return false;
            }
            if (this.mainFile != null) {
                this.printErrorMsg("Error: more than one input files: " + this.mainFile + " and " + args[index]);
                return false;
            }
            this.mainFile = args[index++];
            if (!this.mainFile.endsWith(".tla")) continue;
            this.mainFile = this.mainFile.substring(0, this.mainFile.length() - ".tla".length());
        }
        this.startTime = System.currentTimeMillis();
        boolean bl = generateTESpec = generateTESpec && !TLCGlobals.continuation && !TLCGlobals.tool && !TraceExplorationSpec.isTESpecFile(this.mainFile);
        if (generateTESpec) {
            Path specDir = teSpecOutDir == null ? TLC.getTlaFileParentDir(this.mainFile) : teSpecOutDir;
            this.teSpec = new TraceExplorationSpec(specDir, new Date(this.startTime), this.recorder);
        }
        if (this.mainFile == null) {
            if (ModelInJar.hasModel()) {
                MODEL_PART_OF_JAR = true;
                ModelInJar.loadProperties();
                TLCGlobals.tool = true;
                TLCGlobals.chkptDuration = 0L;
                this.mainFile = "MC";
            } else {
                this.printErrorMsg("Error: Missing input TLA+ module.");
                return false;
            }
        }
        File f = new File(this.mainFile);
        String specDir = "";
        if (f.isAbsolute()) {
            specDir = f.getParent() + FileUtil.separator;
            this.mainFile = f.getName();
            ToolIO.setUserDir(specDir);
        }
        if (this.configFile == null) {
            this.configFile = this.mainFile;
        }
        if (this.cleanup && this.fromChkpt == null) {
            FileUtil.deleteDir("states", true);
        }
        this.metadir = FileUtil.makeMetaDir(new Date(this.startTime), specDir, this.fromChkpt);
        if (dumpFile != null) {
            if (dumpFile.startsWith("${metadir}")) {
                dumpFile = dumpFile.replace("${metadir}", this.metadir);
            }
            try {
                this.stateWriter = asDot ? new DotStateWriter(dumpFile, colorize, actionLabels, snapshot) : new StateWriter(dumpFile);
            }
            catch (IOException e) {
                this.printErrorMsg(String.format("Error: Given file name %s for dumping states invalid.", dumpFile));
                return false;
            }
        }
        if (TLCGlobals.debug) {
            StringBuilder buffer = new StringBuilder("TLC arguments:");
            for (int i = 0; i < args.length; ++i) {
                buffer.append(args[i]);
                if (i >= args.length - 1) continue;
                buffer.append(" ");
            }
            buffer.append("\n");
            DebugPrinter.print(buffer.toString());
        }
        this.printWelcome();
        return true;
    }

    private static String getDumpFile(String dumpFile, String suffix) {
        if (dumpFile.endsWith(suffix)) {
            return dumpFile;
        }
        return dumpFile + suffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int process() {
        int instance3222222222;
        TLCStandardMBean modelCheckerMXWrapper;
        block58: {
            int result;
            TLCDebugger instance22222222222;
            String tlcCustomHandler = System.getProperty("TLCCustomHandler");
            ToolIO.out.println(System.getProperty("TLCCustomHandler"));
            if (tlcCustomHandler != null) {
                try {
                    Class<?> klass = Class.forName(tlcCustomHandler);
                    ToolIO.out.println("\n\nASSIGNABLE!111111!\n\n");
                    if (ITLCCustomHandler.class.isAssignableFrom(klass)) {
                        ToolIO.out.println("\n\nASSIGNABLE!222222!\n\n");
                        ITLCCustomHandler handler = (ITLCCustomHandler)klass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        handler.process(this);
                    } else {
                        ToolIO.out.println("\n\nIT DOES NOTTT> IMPLEMENT >><<<\n\n");
                        System.exit(1);
                    }
                }
                catch (ClassNotFoundException e) {
                    ToolIO.out.println("\n\nEXCCEP222444455555\n\n");
                    e.printStackTrace();
                    System.exit(1);
                }
                catch (NoSuchMethodException e) {
                    ToolIO.out.println("\n\nEXCCEP2224444\n\n");
                    e.printStackTrace();
                    System.exit(1);
                }
                catch (InstantiationException e) {
                    ToolIO.out.println("\n\nEXCCEP222\n\n");
                    e.printStackTrace();
                    System.exit(1);
                }
                catch (Exception e) {
                    ToolIO.out.println("\n\nEXCCEP\n\n");
                    e.printStackTrace();
                    System.exit(1);
                }
            }
            MP.setRecorder(this.recorder);
            modelCheckerMXWrapper = TLCStandardMBean.getNullTLCStandardMBean();
            if (this.fromChkpt != null) {
                UniqueString.internTbl.recover(this.fromChkpt);
            }
            FP64.Init(this.fpIndex);
            RandomGenerator rng = new RandomGenerator();
            if (RunMode.SIMULATE.equals((Object)this.runMode)) {
                Simulator simulator;
                if (this.noSeed) {
                    this.seed = rng.nextLong();
                    rng.setSeed(this.seed);
                } else {
                    rng.setSeed(this.seed, this.aril);
                    RandomEnumerableValues.setSeed(this.seed);
                }
                this.printStartupBanner(2188, TLC.getSimulationRuntime(this.seed));
                if (this.debugPort >= 0) {
                    assert (TLCGlobals.getNumWorkers() == 1) : "TLCDebugger does not support running with multiple workers.";
                    TLCDebugger tLCDebugger = instance22222222222 = TLCDebugger.Factory.getInstance(this.suspend, this.halt);
                    synchronized (tLCDebugger) {
                        this.tool = new DebugTool(this.mainFile, this.configFile, this.resolver, Tool.Mode.Simulation, instance22222222222.listen(this.debugPort));
                    }
                    simulator = new SingleThreadedSimulator(this.tool, this.metadir, this.traceFile, this.deadlock, this.traceDepth, traceNum, this.traceActions, rng, this.seed, this.resolver);
                } else {
                    this.tool = new FastTool(this.mainFile, this.configFile, this.resolver, Tool.Mode.Simulation);
                    simulator = new Simulator(this.tool, this.metadir, this.traceFile, this.deadlock, this.traceDepth, traceNum, this.traceActions, rng, this.seed, this.resolver, TLCGlobals.getNumWorkers());
                }
                TLCGlobals.simulator = simulator;
                result = simulator.simulate();
            } else {
                if (this.noSeed) {
                    this.seed = rng.nextLong();
                }
                RandomEnumerableValues.setSeed(this.seed);
                this.printStartupBanner(TLC.isBFS() ? 2187 : 2271, TLC.getModelCheckingRuntime(this.fpIndex, this.fpSetConfiguration));
                if (this.debugPort >= 0) {
                    TLCDebugger instance3222222222;
                    assert (TLCGlobals.getNumWorkers() == 1) : "TLCDebugger does not support running with multiple workers.";
                    instance22222222222 = instance3222222222 = TLCDebugger.Factory.getInstance(this.suspend, this.halt);
                    synchronized (instance22222222222) {
                        this.tool = new DebugTool(this.mainFile, this.configFile, this.resolver, instance3222222222.listen(this.debugPort));
                    }
                } else {
                    this.tool = new FastTool(this.mainFile, this.configFile, this.resolver);
                }
                boolean bl = this.deadlock = this.deadlock && this.tool.getModelConfig().getCheckDeadlock();
                if (TLC.isBFS()) {
                    TLCGlobals.mainChecker = new ModelChecker(this.tool, this.metadir, this.stateWriter, this.deadlock, this.fromChkpt, FPSetFactory.getFPSetInitialized(this.fpSetConfiguration, this.metadir, new File(this.mainFile).getName()), this.startTime);
                    modelCheckerMXWrapper = new ModelCheckerMXWrapper((ModelChecker)TLCGlobals.mainChecker, this);
                    result = TLCGlobals.mainChecker.modelCheck();
                } else {
                    TLCGlobals.mainChecker = new DFIDModelChecker(this.tool, this.metadir, this.stateWriter, this.deadlock, this.fromChkpt, this.startTime);
                    result = TLCGlobals.mainChecker.modelCheck();
                }
            }
            instance3222222222 = result;
            if (tlc2.module.TLC.OUTPUT == null) break block58;
            try {
                tlc2.module.TLC.OUTPUT.flush();
                tlc2.module.TLC.OUTPUT.close();
            }
            catch (IOException instance22222222222) {
                // empty catch block
            }
        }
        modelCheckerMXWrapper.unregister();
        long runtime = System.currentTimeMillis() - this.startTime;
        MP.printMessage(2186, TLCGlobals.tool || Boolean.getBoolean(TLC.class.getName() + ".asMilliSeconds") ? Long.toString(runtime) + "ms" : TLC.convertRuntimeToHumanReadable(runtime));
        if (this.teSpec != null) {
            this.teSpec.generate(this.tool);
        }
        MP.unsubscribeRecorder(this.recorder);
        MP.flush();
        return instance3222222222;
        catch (Throwable e) {
            int n;
            block67: {
                block65: {
                    int n2;
                    block66: {
                        block63: {
                            int n3;
                            block64: {
                                block61: {
                                    int n4;
                                    block62: {
                                        block59: {
                                            int n5;
                                            block60: {
                                                try {
                                                    if (!(e instanceof StackOverflowError)) break block59;
                                                    System.gc();
                                                    n5 = MP.printError(1005, e);
                                                    if (tlc2.module.TLC.OUTPUT == null) break block60;
                                                }
                                                catch (Throwable throwable) {
                                                    if (tlc2.module.TLC.OUTPUT != null) {
                                                        try {
                                                            tlc2.module.TLC.OUTPUT.flush();
                                                            tlc2.module.TLC.OUTPUT.close();
                                                        }
                                                        catch (IOException iOException) {
                                                            // empty catch block
                                                        }
                                                    }
                                                    modelCheckerMXWrapper.unregister();
                                                    long runtime2 = System.currentTimeMillis() - this.startTime;
                                                    MP.printMessage(2186, TLCGlobals.tool || Boolean.getBoolean(TLC.class.getName() + ".asMilliSeconds") ? Long.toString(runtime2) + "ms" : TLC.convertRuntimeToHumanReadable(runtime2));
                                                    if (this.teSpec != null) {
                                                        this.teSpec.generate(this.tool);
                                                    }
                                                    MP.unsubscribeRecorder(this.recorder);
                                                    MP.flush();
                                                    throw throwable;
                                                }
                                                try {
                                                    tlc2.module.TLC.OUTPUT.flush();
                                                    tlc2.module.TLC.OUTPUT.close();
                                                }
                                                catch (IOException instance3222222222) {
                                                    // empty catch block
                                                }
                                            }
                                            modelCheckerMXWrapper.unregister();
                                            long runtime3 = System.currentTimeMillis() - this.startTime;
                                            MP.printMessage(2186, TLCGlobals.tool || Boolean.getBoolean(TLC.class.getName() + ".asMilliSeconds") ? Long.toString(runtime3) + "ms" : TLC.convertRuntimeToHumanReadable(runtime3));
                                            if (this.teSpec != null) {
                                                this.teSpec.generate(this.tool);
                                            }
                                            MP.unsubscribeRecorder(this.recorder);
                                            MP.flush();
                                            return n5;
                                        }
                                        if (!(e instanceof OutOfMemoryError)) break block61;
                                        System.gc();
                                        n4 = MP.printError(1001, e);
                                        if (tlc2.module.TLC.OUTPUT == null) break block62;
                                        try {
                                            tlc2.module.TLC.OUTPUT.flush();
                                            tlc2.module.TLC.OUTPUT.close();
                                        }
                                        catch (IOException runtime3) {
                                            // empty catch block
                                        }
                                    }
                                    modelCheckerMXWrapper.unregister();
                                    long runtime4 = System.currentTimeMillis() - this.startTime;
                                    MP.printMessage(2186, TLCGlobals.tool || Boolean.getBoolean(TLC.class.getName() + ".asMilliSeconds") ? Long.toString(runtime4) + "ms" : TLC.convertRuntimeToHumanReadable(runtime4));
                                    if (this.teSpec != null) {
                                        this.teSpec.generate(this.tool);
                                    }
                                    MP.unsubscribeRecorder(this.recorder);
                                    MP.flush();
                                    return n4;
                                }
                                if (!(e instanceof Assert.TLCRuntimeException)) break block63;
                                n3 = MP.printTLCRuntimeException((Assert.TLCRuntimeException)e);
                                if (tlc2.module.TLC.OUTPUT == null) break block64;
                                try {
                                    tlc2.module.TLC.OUTPUT.flush();
                                    tlc2.module.TLC.OUTPUT.close();
                                }
                                catch (IOException runtime4) {
                                    // empty catch block
                                }
                            }
                            modelCheckerMXWrapper.unregister();
                            long runtime5 = System.currentTimeMillis() - this.startTime;
                            MP.printMessage(2186, TLCGlobals.tool || Boolean.getBoolean(TLC.class.getName() + ".asMilliSeconds") ? Long.toString(runtime5) + "ms" : TLC.convertRuntimeToHumanReadable(runtime5));
                            if (this.teSpec != null) {
                                this.teSpec.generate(this.tool);
                            }
                            MP.unsubscribeRecorder(this.recorder);
                            MP.flush();
                            return n3;
                        }
                        if (!(e instanceof RuntimeException)) break block65;
                        n2 = MP.printError(1000, e);
                        if (tlc2.module.TLC.OUTPUT == null) break block66;
                        try {
                            tlc2.module.TLC.OUTPUT.flush();
                            tlc2.module.TLC.OUTPUT.close();
                        }
                        catch (IOException runtime5) {
                            // empty catch block
                        }
                    }
                    modelCheckerMXWrapper.unregister();
                    long runtime6 = System.currentTimeMillis() - this.startTime;
                    MP.printMessage(2186, TLCGlobals.tool || Boolean.getBoolean(TLC.class.getName() + ".asMilliSeconds") ? Long.toString(runtime6) + "ms" : TLC.convertRuntimeToHumanReadable(runtime6));
                    if (this.teSpec != null) {
                        this.teSpec.generate(this.tool);
                    }
                    MP.unsubscribeRecorder(this.recorder);
                    MP.flush();
                    return n2;
                }
                n = MP.printError(1000, e);
                if (tlc2.module.TLC.OUTPUT == null) break block67;
                try {
                    tlc2.module.TLC.OUTPUT.flush();
                    tlc2.module.TLC.OUTPUT.close();
                }
                catch (IOException runtime6) {
                    // empty catch block
                }
            }
            modelCheckerMXWrapper.unregister();
            long runtime7 = System.currentTimeMillis() - this.startTime;
            MP.printMessage(2186, TLCGlobals.tool || Boolean.getBoolean(TLC.class.getName() + ".asMilliSeconds") ? Long.toString(runtime7) + "ms" : TLC.convertRuntimeToHumanReadable(runtime7));
            if (this.teSpec != null) {
                this.teSpec.generate(this.tool);
            }
            MP.unsubscribeRecorder(this.recorder);
            MP.flush();
            return n;
        }
    }

    private static boolean isBFS() {
        return TLCGlobals.DFIDMax == -1;
    }

    public static Map<String, String> getSimulationRuntime(long seed) {
        Runtime runtime = Runtime.getRuntime();
        long heapMemory = runtime.maxMemory() / 1024L / 1024L;
        TLCRuntime tlcRuntime = TLCRuntime.getInstance();
        long offHeapMemory = tlcRuntime.getNonHeapPhysicalMemory() / 1024L / 1024L;
        long pid = tlcRuntime.pid();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("seed", String.valueOf(seed));
        result.put("workers", String.valueOf(TLCGlobals.getNumWorkers()));
        result.put("plural", TLCGlobals.getNumWorkers() == 1 ? "" : "s");
        result.put("cores", Integer.toString(runtime.availableProcessors()));
        result.put("osName", System.getProperty("os.name"));
        result.put("osVersion", System.getProperty("os.version"));
        result.put("osArch", System.getProperty("os.arch"));
        result.put("jvmVendor", System.getProperty("java.vendor"));
        result.put("jvmVersion", System.getProperty("java.version"));
        result.put("jvmArch", tlcRuntime.getArchitecture().name());
        result.put("jvmHeapMem", Long.toString(heapMemory));
        result.put("jvmOffHeapMem", Long.toString(offHeapMemory));
        result.put("jvmPid", pid == -1L ? "" : String.valueOf(pid));
        return result;
    }

    public static Map<String, String> getModelCheckingRuntime(int fpIndex, FPSetConfiguration fpSetConfig) {
        Runtime runtime = Runtime.getRuntime();
        long heapMemory = runtime.maxMemory() / 1024L / 1024L;
        TLCRuntime tlcRuntime = TLCRuntime.getInstance();
        long offHeapMemory = tlcRuntime.getNonHeapPhysicalMemory() / 1024L / 1024L;
        long pid = tlcRuntime.pid();
        String fpSetClassSimpleName = fpSetConfig.getImplementation().substring(fpSetConfig.getImplementation().lastIndexOf(".") + 1);
        String stateQueueClassSimpleName = ModelChecker.getStateQueueName();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("workers", String.valueOf(TLCGlobals.getNumWorkers()));
        result.put("plural", TLCGlobals.getNumWorkers() == 1 ? "" : "s");
        result.put("cores", Integer.toString(runtime.availableProcessors()));
        result.put("osName", System.getProperty("os.name"));
        result.put("osVersion", System.getProperty("os.version"));
        result.put("osArch", System.getProperty("os.arch"));
        result.put("jvmVendor", System.getProperty("java.vendor"));
        result.put("jvmVersion", System.getProperty("java.version"));
        result.put("jvmArch", tlcRuntime.getArchitecture().name());
        result.put("jvmHeapMem", Long.toString(heapMemory));
        result.put("jvmOffHeapMem", Long.toString(offHeapMemory));
        result.put("seed", Long.toString(RandomEnumerableValues.getSeed()));
        result.put("fpidx", Integer.toString(fpIndex));
        result.put("jvmPid", pid == -1L ? "" : String.valueOf(pid));
        result.put("fpset", fpSetClassSimpleName);
        result.put("queue", stateQueueClassSimpleName);
        return result;
    }

    public static String convertRuntimeToHumanReadable(long runtime) {
        SimpleDateFormat df = null;
        if (runtime > 86400000L) {
            df = new SimpleDateFormat("D'd' HH'h'");
            runtime -= 86400000L;
        } else if (runtime > 86400000L) {
            df = new SimpleDateFormat("D'd' HH'h'");
            runtime -= 86400000L;
        } else {
            df = runtime > 3600000L ? new SimpleDateFormat("HH'h' mm'min'") : (runtime > 60000L ? new SimpleDateFormat("mm'min' ss's'") : new SimpleDateFormat("ss's'"));
        }
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(runtime);
    }

    public List<File> getModuleFiles() {
        ArrayList<File> result = new ArrayList<File>();
        if (TLCGlobals.mainChecker instanceof ModelChecker) {
            ModelChecker mc = (ModelChecker)TLCGlobals.mainChecker;
            result.addAll(mc.getModuleFiles(this.resolver));
            if (ModelInJar.hasCfg()) {
                result.add(ModelInJar.getCfg());
            }
        }
        return result;
    }

    public void setResolver(FilenameToStream resolver) {
        this.resolver = resolver;
        ToolIO.setDefaultResolver(resolver);
    }

    public FilenameToStream getResolver() {
        return this.resolver;
    }

    public void setStateWriter(IStateWriter sw) {
        this.stateWriter = sw;
    }

    private void printErrorMsg(String msg) {
        this.printWelcome();
        MP.printError(1102, msg);
    }

    private void printWelcome() {
        if (!this.welcomePrinted) {
            this.welcomePrinted = true;
            if (TLCGlobals.getRevision() == null) {
                MP.printMessage(2262, TLCGlobals.versionOfTLC);
            } else {
                MP.printMessage(2262, TLCGlobals.versionOfTLC + " (rev: " + TLCGlobals.getRevision() + ")");
            }
        }
    }

    private void printStartupBanner(int mode, Map<String, String> parameters) {
        MP.printMessage(mode, parameters.values().toArray(new String[parameters.size()]));
        LinkedHashMap<String, String> udc = new LinkedHashMap<String, String>();
        udc.put("ver", TLCGlobals.getRevisionOrDev());
        udc.put("mode", TLC.mode2String(mode));
        parameters.remove("plural");
        parameters.remove("jvmPid");
        parameters.remove("fpidx");
        parameters.remove("seed");
        udc.putAll(parameters);
        udc.put("toolbox", Boolean.toString(TLCGlobals.tool));
        udc.put("ide", System.getProperty(TLC.class.getName() + ".ide", TLCGlobals.tool ? "toolbox" : "cli"));
        new ExecutionStatisticsCollector().collect(udc);
    }

    private static Path getTlaFileParentDir(String tlaFilePath) {
        if (null == tlaFilePath) {
            return Paths.get(".", new String[0]);
        }
        try {
            Path tlaDirPath = Paths.get(tlaFilePath, new String[0]).getParent();
            return null == tlaDirPath ? Paths.get(".", new String[0]) : tlaDirPath;
        }
        catch (InvalidPathException e) {
            return Paths.get(".", new String[0]);
        }
    }

    private static String mode2String(int mode) {
        switch (mode) {
            case 2187: {
                return "bfs";
            }
            case 2271: {
                return "dfs";
            }
            case 2188: {
                return "simulation";
            }
        }
        return "unknown";
    }

    private void printUsage() {
        ArrayList<List<UsageGenerator.Argument>> commandVariants = new ArrayList<List<UsageGenerator.Argument>>();
        ArrayList<UsageGenerator.Argument> sharedArguments = new ArrayList<UsageGenerator.Argument>();
        sharedArguments.add(new UsageGenerator.Argument("-checkpoint", "minutes", "interval between check point; defaults to 30", true));
        sharedArguments.add(new UsageGenerator.Argument("-cleanup", "clean up the states directory", true));
        sharedArguments.add(new UsageGenerator.Argument("-config", "file", "provide the configuration file; defaults to SPEC.cfg", true));
        sharedArguments.add(new UsageGenerator.Argument("-continue", "continue running even when an invariant is violated; default\nbehavior is to halt on first violation", true));
        sharedArguments.add(new UsageGenerator.Argument("-coverage", "minutes", "interval between the collection of coverage information;\nif not specified, no coverage will be collected", true));
        sharedArguments.add(new UsageGenerator.Argument("-deadlock", "if specified DO NOT CHECK FOR DEADLOCK. Setting the flag is\nthe same as setting CHECK_DEADLOCK to FALSE in config\nfile. When -deadlock is specified, config entry is\nignored; default behavior is to check for deadlocks", true));
        sharedArguments.add(new UsageGenerator.Argument("-difftrace", "show only the differences between successive states when\nprinting trace information; defaults to printing\nfull state descriptions", true));
        sharedArguments.add(new UsageGenerator.Argument("-debug", "print various debugging information - not for production use\n", true));
        sharedArguments.add(new UsageGenerator.Argument("-dump", "file", "dump all states into the specified file; this parameter takes\noptional parameters for dot graph generation. Specifying\n'dot' allows further options, comma delimited, of zero\nor more of 'actionlabels', 'colorize', 'snapshot' to be\nspecified before the '.dot'-suffixed filename", true, "dot actionlabels,colorize,snapshot"));
        sharedArguments.add(new UsageGenerator.Argument("-fp", "N", "use the Nth irreducible polynomial from the list stored\nin the class FP64", true));
        sharedArguments.add(new UsageGenerator.Argument("-fpbits", "num", "the number of MSB used by MultiFPSet to create nested\nFPSets; defaults to 1", true));
        sharedArguments.add(new UsageGenerator.Argument("-fpmem", "num", "a value in (0.0,1.0) representing the ratio of total\nphysical memory to devote to storing the fingerprints\nof found states; defaults to 0.25", true));
        sharedArguments.add(new UsageGenerator.Argument("-noGenerateSpecTE", "Whether to skip generating a trace exploration (TE) spec in\nthe event of TLC finding a state or behavior that does\nnot satisfy the invariants; TLC's default behavior is to\ngenerate this spec.", true));
        sharedArguments.add(new UsageGenerator.Argument("-teSpecOutDir", "some-dir-name", "Directory to which to output the TE spec if TLC generates\nan error trace. Can be a relative (to root spec dir)\nor absolute path. By default the TE spec is output\nto the same directory as the main spec.", true));
        sharedArguments.add(new UsageGenerator.Argument("-gzip", "control if gzip is applied to value input/output streams;\ndefaults to 'off'", true));
        sharedArguments.add(new UsageGenerator.Argument("-h", "display these help instructions", true));
        sharedArguments.add(new UsageGenerator.Argument("-maxSetSize", "num", "the size of the largest set which TLC will enumerate; defaults\nto 1000000 (10^6)", true));
        sharedArguments.add(new UsageGenerator.Argument("-metadir", "path", "specify the directory in which to store metadata; defaults to\nSPEC-directory/states if not specified", true));
        sharedArguments.add(new UsageGenerator.Argument("-nowarning", "disable all warnings; defaults to reporting warnings", true));
        sharedArguments.add(new UsageGenerator.Argument("-recover", "id", "recover from the checkpoint with the specified id", true));
        sharedArguments.add(new UsageGenerator.Argument("-terse", "do not expand values in Print statements; defaults to\nexpanding values", true));
        sharedArguments.add(new UsageGenerator.Argument("-tool", "run in 'tool' mode, surrounding output with message codes;\nif '-generateSpecTE' is specified, this is enabled\nautomatically", true));
        sharedArguments.add(new UsageGenerator.Argument("-userFile", "file", "an absolute path to a file in which to log user output (for\nexample, that which is produced by Print)", true));
        sharedArguments.add(new UsageGenerator.Argument("-workers", "num", "the number of TLC worker threads; defaults to 1. Use 'auto'\nto automatically select the number of threads based on the\nnumber of available cores.", true));
        sharedArguments.add(new UsageGenerator.Argument("-debugger", "nosuspend", "run simulation or model-checking in debug mode such that TLC's\nstate-space exploration can be temporarily halted and variables\nbe inspected. The only debug front-end so far is the TLA+\nVSCode extension, which has to be downloaded and configured\nseparately, though other front-ends could be implemeted via the\ndebug-adapter-protocol.\nSpecifying the optional parameter 'nosuspend' causes\nTLC to start state-space exploration without waiting for a\ndebugger front-end to connect. Without 'nosuspend', TLC\nsuspends state-space exploration before the first ASSUME is\nevaluated (but after constants are processed). With 'nohalt',\nTLC does not halt state-space exploration when an evaluation\nor runtime error is caught. Without 'nohalt', evaluation or\nruntime errors can be inspected in the debugger before TLC\nterminates. The optional parameter 'port=1274' makes the\ndebugger listen on port 1274 instead of on the standard\nport 4712, and 'port=0' lets the debugger choose a port.\nMultiple optional parameters must be comma-separated.\nSpecifying '-debugger' implies '-workers 1'.", false, "nosuspend"));
        sharedArguments.add(new UsageGenerator.Argument("SPEC", null));
        ArrayList<UsageGenerator.Argument> modelCheckVariant = new ArrayList<UsageGenerator.Argument>(sharedArguments);
        modelCheckVariant.add(new UsageGenerator.Argument("-dfid", "num", "run the model check in depth-first iterative deepening\nstarting with an initial depth of 'num'", true));
        modelCheckVariant.add(new UsageGenerator.Argument("-view", "apply VIEW (if provided) when printing out states", true));
        commandVariants.add(modelCheckVariant);
        ArrayList<UsageGenerator.Argument> simulateVariant = new ArrayList<UsageGenerator.Argument>(sharedArguments);
        simulateVariant.add(new UsageGenerator.Argument("-depth", "num", "specifies the depth of random simulation; defaults to 100", true));
        simulateVariant.add(new UsageGenerator.Argument("-seed", "num", "provide the seed for random simulation; defaults to a\nrandom long pulled from a pseudo-RNG", true));
        simulateVariant.add(new UsageGenerator.Argument("-aril", "num", "adjust the seed for random simulation; defaults to 0", true));
        simulateVariant.add(new UsageGenerator.Argument("-simulate", null, "run in simulation mode; optional parameters may be specified\ncomma delimited: 'num=X' where X is the maximum number of\ntotal traces to generate and/or 'file=Y' where Y is the\nabsolute-pathed prefix for trace file modules to be written\nby the simulation workers; for example Y='/a/b/c/tr' would\nproduce, e.g, '/a/b/c/tr_1_15'", false, "file=X,num=Y"));
        commandVariants.add(simulateVariant);
        ArrayList<String> tips = new ArrayList<String>();
        tips.add("When using the  '-generateSpecTE' you can version the generated specification by doing:\n\t./tla2tools.jar -generateSpecTE MySpec.tla && NAME=\"SpecTE-$(date +%s)\" && sed -e \"s/MODULE SpecTE/MODULE $NAME/g\" SpecTE.tla > $NAME.tla");
        tips.add("If, while checking a SpecTE created via '-generateSpecTE', you get an error message concerning\nCONSTANT declaration and you've previous used 'integers' as model values, rename your\nmodel values to start with a non-numeral and rerun the model check to generate a new SpecTE.");
        tips.add("If, while checking a SpecTE created via '-generateSpecTE', you get a warning concerning\nduplicate operator definitions, this is likely due to the 'monolith' specification\ncreation. Try re-running TLC adding the 'nomonolith' option to the '-generateSpecTE'\nparameter.");
        UsageGenerator.displayUsage(ToolIO.out, "TLC", TLCGlobals.versionOfTLC, "provides model checking and simulation of TLA+ specifications", Messages.getString("TLCDescription"), commandVariants, tips, ' ');
    }

    FPSetConfiguration getFPSetConfiguration() {
        return this.fpSetConfiguration;
    }

    public RunMode getRunMode() {
        return this.runMode;
    }

    public String getMainFile() {
        return this.mainFile;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getModelName() {
        return System.getProperty("modelName", this.mainFile);
    }

    public String getSpecName() {
        return System.getProperty("specName", this.mainFile);
    }

    public static enum RunMode {
        MODEL_CHECK,
        SIMULATE;

    }
}

