/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.modanalyzer;

import tla2sany.modanalyzer.ModuleContext;
import tla2sany.modanalyzer.ModuleRelatives;
import tla2sany.modanalyzer.ParseUnit;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Vector;

public class ModulePointer {
    private SpecObj spec;
    private ParseUnit parseUnit;
    private TreeNode treeNode;
    private ModuleRelatives moduleRelatives;

    ModulePointer(SpecObj spec2, ParseUnit p, TreeNode t) {
        this.spec = spec2;
        this.parseUnit = p;
        this.treeNode = t;
    }

    final ParseUnit getParseUnit() {
        return this.parseUnit;
    }

    final TreeNode getTreeNode() {
        return this.treeNode;
    }

    final String getName() {
        return this.treeNode.heirs()[0].heirs()[1].getImage();
    }

    final ModuleContext getContext() {
        return this.moduleRelatives.context;
    }

    final ModuleRelatives getRelatives() {
        return this.moduleRelatives;
    }

    final void putRelatives(ModuleRelatives relatives) {
        this.moduleRelatives = relatives;
        this.spec.getModuleRelationships().putRelatives(this, relatives);
    }

    Vector getNamesOfModulesExtended() {
        return this.moduleRelatives.directlyExtendedModuleNames;
    }

    Vector getNamesOfModulesInstantiated() {
        return this.moduleRelatives.directlyInstantiatedModuleNames;
    }

    Vector getDirectInnerModules() {
        return this.moduleRelatives.directInnerModules;
    }

    TreeNode getExtendsDecl() {
        return this.treeNode.heirs()[1];
    }

    TreeNode getBody() {
        return this.treeNode.heirs()[2];
    }

    public String toString() {
        return "ModulePointer (" + this.parseUnit.getFileName() + ",$" + this.getName() + "," + this.treeNode + ")\nRelatives:\n" + this.moduleRelatives.toString();
    }

    public String toStringAbbrev() {
        return "ModPtr(" + this.parseUnit.getFileName() + ",$" + this.getName() + "," + this.treeNode + ")\n";
    }
}

