/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.xml.SymbolContext;

public class NewSymbNode
extends LevelNode {
    private OpDeclNode opDeclNode = null;
    private ExprNode set = null;

    public NewSymbNode(OpDeclNode opDeclNode, ExprNode set, TreeNode stn) {
        super(22, stn);
        this.set = set;
        this.opDeclNode = opDeclNode;
    }

    public final ExprNode getSet() {
        return this.set;
    }

    public final OpDeclNode getOpDeclNode() {
        return this.opDeclNode;
    }

    @Override
    public boolean levelCheck(int iter) {
        if (this.levelChecked < iter) {
            this.levelChecked = iter;
            boolean opDeclLevelCheck = this.opDeclNode.levelCheck(iter);
            this.level = this.opDeclNode.getLevel();
            if (this.set != null) {
                this.levelCorrect = this.set.levelCheck(iter);
                this.level = Math.max(this.set.getLevel(), this.level);
                if (this.level == 3) {
                    this.levelCorrect = false;
                    errors.addError(this.stn.getLocation(), "Level error:\nTemporal formula used as set.");
                }
            }
            boolean bl = this.levelCorrect = this.levelCorrect && opDeclLevelCheck;
            if (this.set != null) {
                this.levelParams = this.set.getLevelParams();
                this.allParams = this.set.getAllParams();
                this.levelConstraints = this.set.getLevelConstraints();
                this.argLevelConstraints = this.set.getArgLevelConstraints();
                this.argLevelParams = this.set.getArgLevelParams();
            }
        }
        return this.levelCorrect;
    }

    @Override
    public SemanticNode[] getChildren() {
        if (this.set == null) {
            return null;
        }
        return new SemanticNode[]{this.set};
    }

    @Override
    public final void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        Integer uid = this.myUID;
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        visitor.preVisit(this);
        if (this.set != null) {
            this.set.walkGraph(semNodesTable, visitor);
        }
        visitor.postVisit(this);
    }

    @Override
    public final String toString(int depth) {
        if (depth <= 0) {
            return "";
        }
        String setString = "";
        if (this.set != null) {
            setString = Strings.indent(2, "\nSet:" + Strings.indent(2, this.set.toString(depth - 1)));
        }
        return "\n*NewSymbNode:   " + super.toString(depth) + Strings.indent(2, "\nKind: " + this.getKind() + "\nopDeclNode:" + Strings.indent(2, this.opDeclNode.toString(depth - 1)) + setString);
    }

    @Override
    protected Element getLevelElement(Document doc, SymbolContext context) {
        Element e = doc.createElement("NewSymbNode");
        e.appendChild(this.getOpDeclNode().export(doc, context));
        if (this.getSet() != null) {
            e.appendChild(this.getSet().export(doc, context));
        }
        return e;
    }
}

