/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import tlc2.TLCGlobals;
import tlc2.util.BigInt;
import tlc2.util.ByteUtils;
import util.Assert;
import util.BufferedDataInputStream;
import util.BufferedDataOutputStream;
import util.FilenameToStream;
import util.MonolithSpecExtractor;
import util.NamedInputStream;
import util.ToolIO;

public class FileUtil {
    public static final char separatorChar = File.separatorChar;
    public static final String separator = File.separator;
    public static final String pathSeparator = File.pathSeparator;

    public static String parseDirname(String filename) {
        int lastSep = filename.lastIndexOf(separatorChar);
        if (lastSep == -1) {
            return "";
        }
        return filename.substring(0, lastSep + 1);
    }

    public static boolean deleteDir(File file, boolean recurse) {
        return FileUtil.doDeleteDir(file, recurse);
    }

    public static boolean deleteDir(String filename, boolean recurse) {
        return FileUtil.doDeleteDir(new File(filename), recurse);
    }

    private static boolean doDeleteDir(File file, boolean recurse) {
        if (file != null && file.exists()) {
            if (file.isFile() || !recurse) {
                return file.delete();
            }
            String[] fnames = file.list();
            File child = null;
            for (int i = 0; i < fnames.length; ++i) {
                child = new File(file, fnames[i]);
                if (FileUtil.doDeleteDir(child, recurse)) continue;
                return false;
            }
            return file.delete();
        }
        return true;
    }

    public static InputStream newBZFileInputStream(String file, boolean useGzip, boolean useIBuffers, int buffersize) throws IOException {
        if (useGzip) {
            return new GZIPInputStream((InputStream)new FileInputStream(file), buffersize);
        }
        if (useIBuffers) {
            return new BufferedInputStream(new FileInputStream(file), buffersize);
        }
        return new FileInputStream(file);
    }

    public static InputStream newZFileInputStream(String file) throws FileNotFoundException, IOException {
        return new GZIPInputStream(new FileInputStream(file));
    }

    public static OutputStream newBZFileOutputStream(String file, boolean useGzip, boolean useOBuffers, int buffersize) throws IOException {
        return FileUtil.newBZFileOutputStream(file, useGzip, useOBuffers, buffersize, false);
    }

    public static OutputStream newBZFileOutputStream(String file, boolean useGzip, boolean useOBuffers, int buffersize, boolean app) throws IOException {
        if (useGzip) {
            return new GZIPOutputStream((OutputStream)new FileOutputStream(file, app), buffersize);
        }
        if (useOBuffers) {
            return new BufferedOutputStream(new FileOutputStream(file, app), buffersize);
        }
        return new FileOutputStream(file, app);
    }

    public static void printArrayOfBigInts(InputStream in) throws IOException {
        BigInt[] A = ByteUtils.readSizeArrayOfSizeBigInts(in);
        for (int i = 0; i < A.length; ++i) {
            ToolIO.out.println(A[i]);
        }
    }

    public static void printSizeArrayOfSizeBigIntegers(InputStream in) throws IOException {
        BigInt[] A = ByteUtils.readSizeArrayOfSizeBigInts(in);
        for (int i = 0; i < A.length; ++i) {
            ToolIO.out.println(A[i]);
        }
    }

    public static void copyFile(String fromName, String toName) throws IOException {
        FileUtil.copyFile(new File(fromName), new File(toName));
    }

    public static void copyFile(File source, File destination) throws IOException {
        Files.copy(source.toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void replaceFile(String sourceName, String targetName) throws IOException {
        Files.move(new File(sourceName).toPath(), new File(targetName).toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static String makeMetaDir(String specDir, String fromChkpt) {
        return FileUtil.makeMetaDir(new Date(), specDir, fromChkpt);
    }

    public static String makeMetaDir(Date date, String specDir, String fromChkpt) {
        String highres;
        if (fromChkpt != null) {
            return fromChkpt;
        }
        String metadir = TLCGlobals.metaDir;
        if (metadir == null) {
            metadir = specDir + "states" + separator;
        }
        SimpleDateFormat sdf = Boolean.valueOf(highres = System.getProperty(FileUtil.class.getName() + ".milliseconds", "true")) != false ? new SimpleDateFormat("yy-MM-dd-HH-mm-ss.SSS") : new SimpleDateFormat("yy-MM-dd-HH-mm-ss");
        metadir = metadir + sdf.format(date);
        File filedir = new File(metadir);
        Assert.check(!filedir.exists(), 2162, filedir.getAbsolutePath());
        Assert.check(filedir.mkdirs(), 2163, filedir.getAbsolutePath());
        return metadir;
    }

    public static NamedInputStream createNamedInputStream(String name, FilenameToStream resolver) {
        return FileUtil.createNamedInputStream(name, resolver, null);
    }

    public static NamedInputStream createNamedInputStream(String name, FilenameToStream resolver, NamedInputStream rootFileNis) {
        int n = name.indexOf(10);
        if (n >= 0) {
            ToolIO.out.println("*** Warning: module name '" + name + "' contained NEWLINE; Only the part before NEWLINE is considered.");
            name = name.substring(0, n);
        }
        if (name.toLowerCase().endsWith(".tla")) {
            name = name.substring(0, name.length() - ".tla".length());
        }
        String sourceFileName = name + ".tla";
        String sourceModuleName = name.substring(name.lastIndexOf(separator) + 1);
        File sourceFile = resolver.resolve(sourceFileName, true);
        if (sourceFile != null && sourceFile.exists()) {
            try {
                NamedInputStream nis = new NamedInputStream(sourceFileName, sourceModuleName, sourceFile);
                return nis;
            }
            catch (FileNotFoundException e) {
                ToolIO.out.println("***Internal error: Unable to create NamedInputStream in toIStream method");
            }
        }
        if (rootFileNis != null) {
            File rootSourceFile = rootFileNis.sourceFile();
            if (rootSourceFile != null) {
                try {
                    NamedInputStream nis = MonolithSpecExtractor.module(rootSourceFile, name);
                    return nis;
                }
                catch (IOException iOException) {}
            }
        } else if (sourceFile != null) {
            ToolIO.err.println("File does not exist: " + sourceFile.getAbsolutePath() + " while looking in these directories: " + resolver.getFullPath());
        } else {
            ToolIO.err.println("Cannot locate " + sourceFileName + " in path: " + resolver.getFullPath());
        }
        return null;
    }

    public static FileInputStream newFIS(File file) {
        if (file != null && file.exists()) {
            try {
                FileInputStream fis = new FileInputStream(file);
                return fis;
            }
            catch (FileNotFoundException e) {
                ToolIO.out.println("***Internal error: Unable to create FileInputStream");
            }
        }
        return null;
    }

    public static FileOutputStream newFOS(File file) {
        if (file != null && file.exists()) {
            try {
                FileOutputStream fos = new FileOutputStream(file);
                return fos;
            }
            catch (FileNotFoundException e) {
                ToolIO.out.println("***Internal error: Unable to create FileOutStream");
            }
        }
        return null;
    }

    public static OutputStream newBFOS(String name) throws FileNotFoundException {
        try {
            return new FileOutputStream(new File(name));
        }
        catch (FileNotFoundException e) {
            ToolIO.out.println("Error: Unable to write to file " + name);
            throw e;
        }
    }

    public static BufferedDataInputStream newBdFIS(boolean useGZIP, File file) throws IOException {
        if (useGZIP) {
            return new BufferedDataInputStream(new GZIPInputStream(new FileInputStream(file)));
        }
        return new BufferedDataInputStream(new FileInputStream(file));
    }

    public static BufferedDataInputStream newBdFIS(boolean useGZIP, String filename) throws IOException {
        return FileUtil.newBdFIS(useGZIP, new File(filename));
    }

    public static BufferedDataOutputStream newBdFOS(boolean useGZIP, File file) throws FileNotFoundException, IOException {
        if (useGZIP) {
            return new BufferedDataOutputStream(new GZIPOutputStream(new FileOutputStream(file)));
        }
        return new BufferedDataOutputStream(new FileOutputStream(file));
    }

    public static BufferedDataOutputStream newBdFOS(boolean useGZIP, String filename) throws IOException {
        return FileUtil.newBdFOS(useGZIP, new File(filename));
    }

    public static ObjectInputStream newOBFIS(File file) throws FileNotFoundException, IOException {
        return new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
    }

    public static ObjectInputStream newOBFIS(String filename) throws FileNotFoundException, IOException {
        return FileUtil.newOBFIS(new File(filename));
    }

    public static ObjectOutputStream newOBFOS(File file) throws FileNotFoundException, IOException {
        return new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
    }

    public static ObjectOutputStream newOBFOS(String filename) throws FileNotFoundException, IOException {
        return FileUtil.newOBFOS(new File(filename));
    }

    public static DataInputStream newDFIS(String filename) throws FileNotFoundException {
        return new DataInputStream(new FileInputStream(new File(filename)));
    }

    public static DataOutputStream newDFOS(String filename) throws FileNotFoundException {
        return new DataOutputStream(new FileOutputStream(new File(filename)));
    }

    public static File createTempFile(String fileName) {
        File file;
        if (TLCGlobals.metaDir != null) {
            file = new File(TLCGlobals.metaDir + separatorChar + fileName);
        } else {
            String tDir = System.getProperty("java.io.tmpdir");
            file = new File(tDir + separatorChar + fileName);
        }
        file.deleteOnExit();
        return file;
    }

    public static long copyStream(InputStream is, OutputStream os) throws IOException {
        int n;
        BufferedOutputStream bos;
        byte[] buffer = new byte[4096];
        long byteCount = 0L;
        BufferedInputStream bis = is instanceof BufferedInputStream ? (BufferedInputStream)is : new BufferedInputStream(is);
        BufferedOutputStream bufferedOutputStream = bos = os instanceof BufferedOutputStream ? (BufferedOutputStream)os : new BufferedOutputStream(os);
        while ((n = bis.read(buffer)) != -1) {
            bos.write(buffer, 0, n);
            byteCount += (long)n;
        }
        bos.flush();
        return byteCount;
    }
}

