/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.impl;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tla2sany.modanalyzer.ParseUnit;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.semantic.APSubstInNode;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.FrontEnd;
import tla2sany.semantic.LabelNode;
import tla2sany.semantic.LetInNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.Subst;
import tla2sany.semantic.SubstInNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.ThmOrAssumpDefNode;
import tlc2.TLCGlobals;
import tlc2.tool.Action;
import tlc2.tool.BuiltInOPs;
import tlc2.tool.Defns;
import tlc2.tool.TLCState;
import tlc2.tool.ToolGlobals;
import tlc2.tool.impl.ModelConfig;
import tlc2.tool.impl.OpDefEvaluator;
import tlc2.tool.impl.ParameterizedSpecObj;
import tlc2.tool.impl.SpecProcessor;
import tlc2.tool.impl.SymbolNodeValueLookupProvider;
import tlc2.tool.impl.TLAClass;
import tlc2.tool.impl.Tool;
import tlc2.util.Context;
import tlc2.util.ObjLongTable;
import tlc2.util.Vect;
import tlc2.value.ValueConstants;
import tlc2.value.impl.EvaluatingValue;
import tlc2.value.impl.LazyValue;
import tlc2.value.impl.ModelValue;
import util.Assert;
import util.FilenameToStream;
import util.MonolithSpecExtractor;
import util.UniqueString;

abstract class Spec
implements ValueConstants,
ToolGlobals,
Serializable,
OpDefEvaluator,
SymbolNodeValueLookupProvider {
    private static final long serialVersionUID = 1L;
    protected static final boolean coverage = TLCGlobals.isCoverageEnabled();
    protected static final int toolId = FrontEnd.getToolId();
    protected final String specDir;
    protected final String rootFile;
    protected final String configFile;
    protected final Set<OpDefNode> processedDefs;
    protected final Defns defns;
    protected final Defns unprocessedDefns;
    protected final TLAClass tlaClass;
    private final FilenameToStream resolver;
    protected final ModelConfig config;
    private final SpecProcessor specProcessor;

    public Spec(String specDir, String specFile, String configFile, FilenameToStream resolver, Tool.Mode mode, Map<String, Object> params) {
        this.specDir = specDir;
        this.rootFile = specFile;
        this.defns = new Defns();
        this.tlaClass = new TLAClass("tlc2.module", resolver);
        this.processedDefs = new HashSet<OpDefNode>();
        this.resolver = resolver;
        ModelValue.init();
        this.configFile = configFile;
        this.config = new ModelConfig(MonolithSpecExtractor.getConfig(configFile), resolver);
        this.config.parse();
        ModelValue.setValues();
        SpecObj specObj = params.isEmpty() ? new SpecObj(this.rootFile, resolver) : new ParameterizedSpecObj(this, resolver, params);
        this.specProcessor = new SpecProcessor(this.getRootName(), resolver, toolId, this.defns, this.config, this, this, this.tlaClass, mode, specObj);
        this.unprocessedDefns = this.specProcessor.getUnprocessedDefns();
    }

    protected Spec(Spec other) {
        this.specDir = other.specDir;
        this.rootFile = other.rootFile;
        this.configFile = other.configFile;
        this.processedDefs = other.processedDefs;
        this.defns = other.defns;
        this.tlaClass = other.tlaClass;
        this.resolver = other.resolver;
        this.unprocessedDefns = other.unprocessedDefns;
        this.config = other.config;
        this.specProcessor = other.specProcessor;
    }

    public ModelConfig getModelConfig() {
        return this.config;
    }

    public SpecProcessor getSpecProcessor() {
        return this.specProcessor;
    }

    public final SymbolNode getPrimedVar(SemanticNode expr, Context c, boolean cutoff) {
        if (expr instanceof OpApplNode) {
            OpApplNode expr1 = (OpApplNode)expr;
            SymbolNode opNode = expr1.getOperator();
            if (BuiltInOPs.getOpCode(opNode.getName()) == 48) {
                return this.getVar(expr1.getArgs()[0], c, cutoff, toolId);
            }
            if (opNode.getArity() == 0) {
                boolean isVarDecl = opNode.getKind() == 3;
                Object val = this.lookup(opNode, c, cutoff && isVarDecl, toolId);
                if (val instanceof LazyValue) {
                    LazyValue lval = (LazyValue)val;
                    return this.getPrimedVar(lval.expr, lval.con, cutoff);
                }
                if (val instanceof OpDefNode) {
                    return this.getPrimedVar(((OpDefNode)val).getBody(), c, cutoff);
                }
            }
        }
        return null;
    }

    public final ExprNode[] getModelConstraints() {
        return this.specProcessor.getModelConstraints();
    }

    public final ExprNode[] getActionConstraints() {
        return this.specProcessor.getActionConstraints();
    }

    public final Vect<Action> getInitStateSpec() {
        return this.specProcessor.getInitPred();
    }

    public final Action getNextStateSpec() {
        return this.specProcessor.getNextPred();
    }

    public final SemanticNode getViewSpec() {
        OpDefNode def;
        String name = this.config.getView();
        if (name.length() == 0) {
            return null;
        }
        Object view = this.defns.get(name);
        if (view == null) {
            Assert.fail(2229, new String[]{"view function", name});
        }
        if (!(view instanceof OpDefNode)) {
            Assert.fail(2233, new String[]{"view function", name});
        }
        if ((def = (OpDefNode)view).getArity() != 0) {
            Assert.fail(2228, new String[]{"view function", name});
        }
        return def.getBody();
    }

    public final boolean hasAlias() {
        return !"".equals(this.config.getAlias());
    }

    public final SemanticNode getAliasSpec() {
        OpDefNode def;
        Object type;
        String name = this.config.getAlias();
        if (name.length() == 0) {
            Assert.fail(2243);
        }
        if ((type = this.defns.get(name)) == null) {
            Assert.fail(2229, new String[]{"alias", name});
        }
        if (!(type instanceof OpDefNode)) {
            Assert.fail(2233, new String[]{"alias", name});
        }
        if ((def = (OpDefNode)type).getArity() != 0) {
            Assert.fail(2228, new String[]{"alias", name});
        }
        return def.getBody();
    }

    public final ExprNode[] getPostConditionSpecs() {
        List<ExprNode> res = this.specProcessor.getPostConditionSpecs();
        String name = this.config.getPostCondition();
        if (name.length() != 0) {
            OpDefNode def;
            Object type = this.defns.get(name);
            if (type == null) {
                Assert.fail(2229, new String[]{"post condition", name});
            }
            if (!(type instanceof OpDefNode)) {
                Assert.fail(2233, new String[]{"post condition", name});
            }
            if ((def = (OpDefNode)type).getArity() != 0) {
                Assert.fail(2228, new String[]{"post condition", name});
            }
            res.add(def.getBody());
        }
        return (ExprNode[])res.toArray(ExprNode[]::new);
    }

    public final OpDefNode getCounterExampleDef() {
        OpDefNode def;
        Object type = this.defns.get("CounterExample");
        if (type == null) {
            return null;
        }
        if (!(type instanceof EvaluatingValue)) {
            Assert.fail(1000);
        }
        if ((def = ((EvaluatingValue)type).getOpDef()).getArity() != 0) {
            Assert.fail(1000);
        }
        return def;
    }

    public final boolean livenessIsTrue() {
        return this.getImpliedTemporals().length == 0;
    }

    public final Action[] getTemporals() {
        return this.specProcessor.getTemporal();
    }

    public final String[] getTemporalNames() {
        return this.specProcessor.getTemporalNames();
    }

    public final Action[] getImpliedTemporals() {
        return this.specProcessor.getImpliedTemporals();
    }

    public final String[] getImpliedTemporalNames() {
        return this.specProcessor.getImpliedTemporalNames();
    }

    public final Action[] getInvariants() {
        return this.specProcessor.getInvariants();
    }

    public final String[] getInvNames() {
        return this.specProcessor.getInvariantsNames();
    }

    public final Action[] getImpliedInits() {
        return this.specProcessor.getImpliedInits();
    }

    public final String[] getImpliedInitNames() {
        return this.specProcessor.getImpliedInitNames();
    }

    public final Action[] getImpliedActions() {
        return this.specProcessor.getImpliedActions();
    }

    public final String[] getImpliedActNames() {
        return this.specProcessor.getImpliedActionNames();
    }

    public final ExprNode[] getAssumptions() {
        return this.specProcessor.getAssumptions();
    }

    public final boolean[] getAssumptionIsAxiom() {
        return this.specProcessor.getAssumptionIsAxiom();
    }

    public final Object lookup(SymbolNode opNode, Context c, TLCState s, boolean cutoff) {
        Object result = this.lookup(opNode, c, cutoff, toolId);
        if (result != opNode) {
            return result;
        }
        if (opNode.getKind() != 5 && (result = s.lookup(opNode.getName())) != null) {
            return result;
        }
        return opNode;
    }

    public final Object lookup(SymbolNode opNode) {
        return this.lookup(opNode, Context.Empty, false, toolId);
    }

    public final Context getOpContext(ThmOrAssumpDefNode opDef, ExprOrOpArgNode[] args, Context c, boolean cachable) {
        FormalParamNode[] formals = opDef.getParams();
        int alen = args.length;
        Context c1 = c;
        for (int i = 0; i < alen; ++i) {
            Object aval = this.getVal(args[i], c, cachable, toolId);
            c1 = c1.cons(formals[i], aval);
        }
        return c1;
    }

    public final ObjLongTable<SemanticNode> getPrimedLocs() {
        ObjLongTable<SemanticNode> tbl = new ObjLongTable<SemanticNode>(10);
        Action act = this.getNextStateSpec();
        if (act == null) {
            return tbl;
        }
        this.collectPrimedLocs(act.pred, act.con, tbl);
        return tbl;
    }

    public final void collectPrimedLocs(SemanticNode pred, Context c, ObjLongTable<SemanticNode> tbl) {
        switch (pred.getKind()) {
            case 9: {
                OpApplNode pred1 = (OpApplNode)pred;
                this.collectPrimedLocsAppl(pred1, c, tbl);
                return;
            }
            case 10: {
                LetInNode pred1 = (LetInNode)pred;
                this.collectPrimedLocs(pred1.getBody(), c, tbl);
                return;
            }
            case 13: {
                SubstInNode pred1 = (SubstInNode)pred;
                Subst[] subs = pred1.getSubsts();
                Context c1 = c;
                for (int i = 0; i < subs.length; ++i) {
                    Subst sub = subs[i];
                    c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, true, toolId));
                }
                this.collectPrimedLocs(pred1.getBody(), c, tbl);
                return;
            }
            case 30: {
                APSubstInNode pred1 = (APSubstInNode)pred;
                Subst[] subs = pred1.getSubsts();
                Context c1 = c;
                for (int i = 0; i < subs.length; ++i) {
                    Subst sub = subs[i];
                    c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, true, toolId));
                }
                this.collectPrimedLocs(pred1.getBody(), c, tbl);
                return;
            }
            case 29: {
                LabelNode pred1 = (LabelNode)pred;
                this.collectPrimedLocs(pred1.getBody(), c, tbl);
                return;
            }
        }
    }

    private final void collectPrimedLocsAppl(OpApplNode pred, Context c, ObjLongTable<SemanticNode> tbl) {
        ExprOrOpArgNode[] args = pred.getArgs();
        SymbolNode opNode = pred.getOperator();
        int opcode = BuiltInOPs.getOpCode(opNode.getName());
        switch (opcode) {
            case 9: {
                this.collectPrimedLocs(args[0], c, tbl);
                break;
            }
            case 11: {
                this.collectPrimedLocs(args[1], c, tbl);
                this.collectPrimedLocs(args[2], c, tbl);
                break;
            }
            case 4: {
                for (int i = 0; i < args.length; ++i) {
                    OpApplNode pair2 = (OpApplNode)args[i];
                    this.collectPrimedLocs(pair2.getArgs()[1], c, tbl);
                }
                break;
            }
            case 35: 
            case 42: {
                SymbolNode var = this.getPrimedVar(args[0], c, false);
                if (var == null || var.getName().getVarLoc() == -1) break;
                tbl.put(pred, 0L);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 36: 
            case 37: 
            case 38: 
            case 46: {
                for (int i = 0; i < args.length; ++i) {
                    this.collectPrimedLocs(args[i], c, tbl);
                }
                break;
            }
            case 49: {
                this.collectUnchangedLocs(args[0], c, tbl);
                break;
            }
            case 50: {
                this.collectPrimedLocs(args[0], c, tbl);
                break;
            }
            case 51: {
                this.collectPrimedLocs(args[0], c, tbl);
                tbl.put(args[1], 0L);
                break;
            }
            default: {
                if (opcode != 0) break;
                Object val = this.lookup(opNode, c, false, toolId);
                if (val instanceof OpDefNode) {
                    OpDefNode opDef = (OpDefNode)val;
                    if (opDef.getInRecursive()) {
                        return;
                    }
                    Context c1 = this.getOpContext(opDef, args, c, true, toolId);
                    this.collectPrimedLocs(opDef.getBody(), c1, tbl);
                    break;
                }
                if (!(val instanceof LazyValue)) break;
                LazyValue lv = (LazyValue)val;
                this.collectPrimedLocs(lv.expr, lv.con, tbl);
            }
        }
    }

    private final void collectUnchangedLocs(SemanticNode expr, Context c, ObjLongTable<SemanticNode> tbl) {
        if (expr instanceof OpApplNode) {
            Object val;
            OpApplNode expr1 = (OpApplNode)expr;
            SymbolNode opNode = expr1.getOperator();
            UniqueString opName = opNode.getName();
            int opcode = BuiltInOPs.getOpCode(opName);
            if (opName.getVarLoc() >= 0) {
                tbl.put(expr, 0L);
                return;
            }
            ExprOrOpArgNode[] args = expr1.getArgs();
            if (opcode == 23) {
                for (int i = 0; i < args.length; ++i) {
                    this.collectUnchangedLocs(args[i], c, tbl);
                }
                return;
            }
            if (opcode == 0 && args.length == 0 && (val = this.lookup(opNode, c, false, toolId)) instanceof OpDefNode) {
                this.collectUnchangedLocs(((OpDefNode)val).getBody(), c, tbl);
                return;
            }
        }
    }

    public FilenameToStream getResolver() {
        return this.resolver;
    }

    public String getRootName() {
        return new File(this.rootFile).getName();
    }

    public String getRootFile() {
        return this.rootFile;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public String getSpecDir() {
        return this.specDir;
    }

    public int getId() {
        return toolId;
    }

    public ModuleNode getModule(String moduleName) {
        return this.getSpecProcessor().getSpecObj().getExternalModuleTable().getModuleNode(moduleName);
    }

    public List<File> getModuleFiles(FilenameToStream resolver) {
        ArrayList<File> result = new ArrayList<File>();
        Enumeration<ParseUnit> parseUnitContext = this.specProcessor.getSpecObj().parseUnitContext.elements();
        while (parseUnitContext.hasMoreElements()) {
            ParseUnit pu = parseUnitContext.nextElement();
            File resolve = resolver.resolve(pu.getFileName(), false);
            result.add(resolve);
        }
        return result;
    }
}

