/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.ThmOrAssumpDefNode;
import tla2sany.st.TreeNode;
import tla2sany.xml.SymbolContext;
import util.UniqueString;

public abstract class SymbolNode
extends LevelNode {
    protected final UniqueString name;

    protected SymbolNode(int kind, TreeNode stn, UniqueString name2) {
        super(kind, stn);
        this.name = name2;
    }

    public final UniqueString getName() {
        return this.name;
    }

    public abstract int getArity();

    public abstract boolean isLocal();

    public abstract boolean match(OpApplNode var1, ModuleNode var2) throws AbortException;

    public final boolean occur(SymbolNode[] params) {
        for (int i = 0; i < params.length; ++i) {
            if (this != params[i]) continue;
            return true;
        }
        return false;
    }

    public final boolean isParam() {
        return this instanceof OpDeclNode || this instanceof FormalParamNode;
    }

    public String getSignature() {
        return this.getName().toString();
    }

    public final boolean sameOriginallyDefinedInModule(SymbolNode otherNode) {
        if (this.getClass() == otherNode.getClass()) {
            ModuleNode thisModule = null;
            if (this instanceof OpDefNode) {
                OpDefNode thisSrc = ((OpDefNode)this).getSource();
                if (thisSrc != ((OpDefNode)otherNode).getSource()) {
                    return false;
                }
                thisModule = thisSrc.getOriginallyDefinedInModuleNode();
            } else if (this instanceof ThmOrAssumpDefNode) {
                ThmOrAssumpDefNode thisSrc = ((ThmOrAssumpDefNode)this).getSource();
                if (thisSrc != ((ThmOrAssumpDefNode)otherNode).getSource()) {
                    return false;
                }
                thisModule = thisSrc.getOriginallyDefinedInModuleNode();
            } else {
                return false;
            }
            return thisModule == null || thisModule.getConstantDecls().length == 0 && thisModule.getVariableDecls().length == 0;
        }
        return false;
    }

    public Element exportDefinition(Document doc2, SymbolContext context) {
        if (!context.isTop_level_entry()) {
            throw new IllegalArgumentException("Exporting definition " + this.getName() + " ref " + this.getNodeRef() + " twice!");
        }
        context.resetTop_level_entry();
        try {
            Element e2 = this.getSymbolElement(doc2, context);
            try {
                Element l = this.appendText(doc2, "level", Integer.toString(this.getLevel()));
                e2.insertBefore(l, e2.getFirstChild());
            }
            catch (RuntimeException l) {
                // empty catch block
            }
            try {
                Element loc = this.getLocationElement(doc2);
                e2.insertBefore(loc, e2.getFirstChild());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return e2;
        }
        catch (RuntimeException ee) {
            System.err.println("failed for node.toString(): " + this.toString() + "\n with error ");
            ee.printStackTrace();
            throw ee;
        }
    }

    protected abstract Element getSymbolElement(Document var1, SymbolContext var2);

    protected abstract String getNodeRef();

    @Override
    protected Element getLevelElement(Document doc2, SymbolContext context) {
        throw new UnsupportedOperationException("implementation Error: A symbol node may not be called for its level element.");
    }

    @Override
    public Element export(Document doc2, SymbolContext context) {
        context.put(this, doc2);
        Element e2 = doc2.createElement(this.getNodeRef());
        e2.appendChild(this.appendText(doc2, "UID", Integer.toString(this.myUID)));
        return e2;
    }
}

