(ns mig.core
  (:require [clojure.java.io :as io]
            [clojure.tools.namespace :refer [find-clojure-sources-in-dir read-file-ns-decl]]
            [slingshot.slingshot :refer [throw+]]))

(defn find-migration-files
  "Simply find all clojure files beneath `base-dir`."
  [base-dir]
  (find-clojure-sources-in-dir base-dir))

(def read-ns-decl (memoize read-file-ns-decl))

(defn extract-function
  "Fetch function `fn-sym` from `file`."
  [file fn-sym]
  (if-let [n (second (read-file-ns-decl file))]
    (do
      (load-file (str file))
      (ns-resolve n fn-sym))
    (throw+ {:type :namespace-extraction-error
             :file (str file)
             :message "Failed to load ns."})))

(defn extract-predicate [cur-file direction]
  (or (extract-function cur-file (symbol (str direction "-applied?")))
      (constantly nil)))

(defn load-files
  "Run through `files`, from each extracting a function `direction`
  and `direction`-applied?. If pred passes, then the main function
  will be run, threading whatever `ctx` is through each run."
  [ctx files direction]
  (loop [ctx ctx
         files files]
    (let [cur-file (first files)
          pred     (extract-predicate cur-file direction)
          runner   (extract-function cur-file direction)
          t-ctx    (if-let [n-ctx (pred ctx)] (runner n-ctx) ctx)]
      (if (> (count (rest files)) 0)
        (recur t-ctx (rest files))
        t-ctx))))
