(ns mig.pipe)

(defn pipe [value & fns]
  (reduce (fn [acc cur] (cur acc)) value fns))

(defn tap [msg]
  (fn [x]
    (do
      (println (str msg ": " x))
      x)))

(defn given [pred f]
  (fn [x]
    (if (pred x)
      (f x)
      x)))

(defn unless-nil [f]
  (fn [x]
    (if (nil? x)
      nil
      (f x))))
