/*
 * Decompiled with CFR 0.152.
 */
package piotr_yuxuan;

import clojure.lang.AFn;
import clojure.lang.AFunction;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;

public final class closeable_map$fn__880
extends AFunction {
    public static final Var const__0 = RT.var((String)"clojure.core", (String)"commute");
    public static final Var const__1 = RT.var((String)"clojure.core", (String)"deref");
    public static final Var const__2 = RT.var((String)"clojure.core", (String)"*loaded-libs*");
    public static final Var const__3 = RT.var((String)"clojure.core", (String)"conj");
    public static final AFn const__4 = (AFn)((IObj)Symbol.intern(null, (String)"piotr-yuxuan.closeable-map")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"doc"), "In your project, require:\n\n``` clojure\n(require '[piotr-yuxuan.closeable-map :as closeable-map :refer [with-tag]])\n```\n\nThen you can define an application that can be started, and closed.\n\n``` clojure\n(defn start\n  \"Return a running context with values that can be closed.\"\n  [config]\n  (closeable-map/closeable-map\n    {;; Kafka producers/consumers are `java.io.Closeable`.\n     :producer (kafka-producer config)\n     :consumer (kafka-consumer config)\n\n     ;; Closeable maps can be nested.\n     :backend/api {:response-executor (flow/utilization-executor (:executor config))\n                   :connection-pool (http/connection-pool {:pool-opts config})\n\n                   ;; File streams are `java.io.Closeable` too:\n                   :logfile (io/output-stream (io/file \"/tmp/log.txt\"))\n\n                   ;; This will be called as final closing step for\n                   ;; this nested map backend/api. See also\n                   ;; `::closeable-map/before-close` which is called\n                   ;; before closing a map.\n                   ::closeable-map/after-close\n                   (fn [m]\n                     ;; Some classes have similar semantic, but do not\n                     ;; implement `java.io.Closeable`. We can handle\n                     ;; them anyway.\n                     (.shutdown ^ExecutorService (:response-executor m))\n                     (.shutdown ^IPool (:connection-pool m)))}\n\n     ;; Any exception when closing this nested map will be swallowed\n     ;; and not bubbled up.\n     :db ^::closeable-map/swallow {;; Connection are `java.io.Closeable`, too:\n                                   :db-conn (jdbc/get-connection (:db config))}\n\n     ;; Some libs return a zero-argument function which when called\n     ;; stops the server, like:\n     :server (with-tag ::closeable-map/fn (http/start-server (api config) (:server config)))\n     ;; Gotcha: Clojure meta data can only be attached on 'concrete'\n     ;; objects; they are lost on literal forms (see above).\n     :forensic ^::closeable-map/fn #(metrics/report-death!)\n\n     ::closeable-map/ex-handler\n     (fn [ex]\n       ;; Will be called for all exceptions thrown when closing this\n       ;; map and nested items.\n       (println (ex-message ex)))}))\n```\n\nThen you can start/stop the app in the repl with:\n\n``` clojure\n(comment\n  (def config (load-config))\n  (def system (start config))\n\n  ;; Stop/close all processes/resources with:\n  (.close system)\n)\n```\n\nYou can use it in conjunction with `with-open` like in test file:\n\n``` clojure\n(with-open [system (start config)]\n  (testing \"unit test with isolated, repeatable context\"\n    (is (= :yay/\ud83d\ude80 (some-business/function context)))))\n```\n\nWhen `(.close system)` is executed, it will:\n\n  - Recursively close all instances of `java.io.Closeable` and `java.lang.AutoCloseable`;\n\n  - Recursively call all stop zero-argument functions tagged with `^::closeable-map/fn`;\n\n  - Skip all nested `Closeable` under a `^::closeable-map/ignore`;\n\n  - Silently swallow any exception with `^::closeable-map/swallow`;\n\n  - Exceptions to optional `::closeable-map/ex-handler` in key or\n    metadata;\n\n  - If keys (or metadata) `::closeable-map/before-close` or\n    `::closeable-map/after-close` are present, they will be assumed as\n    a function which takes one argument (the map itself) and used run\n    additional closing logic:\n\n    ``` clojure\n    (closeable-map\n      {;; This function will be executed before the auto close.\n       ::closeable-map/before-close (fn [this-map] (flush!))\n\n       ;; Kafka producers/consumers are java.io.Closeable\n       :producer (kafka-producer config)\n       :consumer (kafka-consumer config)\n\n       ;; This function will be executed after the auto close.\n       ::closeable-map/after-close (fn [this-map] (garbage/collect!))\n      }\n    )\n    ```\n\n  - You can easily extend this library by giving new dispatch values\n    to multimethod [[piotr-yuxuan.closeable-map/close!]]. It is\n    dispatched on the concrete class of its argument.\n\n    ``` clojure\n    (import '(java.util.concurrent ExecutorService))\n    (defmethod closeable-map/close! ExecutorService\n      [x]\n      (.shutdown ^ExecutorService x))\n\n    (import '(io.aleph.dirigiste IPool))\n    (defmethod closeable-map/close! IPool\n      [x]\n      (.shutdown ^IPool x))\n    ```\n"}));

    public static Object invokeStatic() {
        return ((IFn)const__0.getRawRoot()).invoke(((IFn)const__1.getRawRoot()).invoke((Object)const__2), const__3.getRawRoot(), (Object)const__4);
    }

    public Object invoke() {
        return closeable_map$fn__880.invokeStatic();
    }
}

