/*
 * Decompiled with CFR 0.152.
 */
package piotr_yuxuan;

import clojure.lang.AFn;
import clojure.lang.AFunction;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;

public final class closeable_map$fn__878
extends AFunction {
    public static final Var const__0 = RT.var((String)"clojure.core", (String)"commute");
    public static final Var const__1 = RT.var((String)"clojure.core", (String)"deref");
    public static final Var const__2 = RT.var((String)"clojure.core", (String)"*loaded-libs*");
    public static final Var const__3 = RT.var((String)"clojure.core", (String)"conj");
    public static final AFn const__4 = (AFn)((IObj)Symbol.intern(null, (String)"piotr-yuxuan.closeable-map")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"doc"), "In your project, require:\n\n``` clojure\n(require '[piotr-yuxuan.closeable-map :as closeable-map :refer [close-with with-tag]])\n```\n\nDefine an application that can be started, and closed.\n\n``` clojure\n(defn start\n  \"Return a map describing a running application, and which values may\n  be closed.\"\n  [config]\n  (closeable-map/closeable-map\n    {;; Kafka producers/consumers are `java.io.Closeable`.\n     :producer (kafka-producer config)\n     :consumer (kafka-consumer config)}))\n```\n\nYou can start/stop the app in the repl with:\n\n``` clojure\n(comment\n  (def config (load-config))\n  (def system (start config))\n\n  ;; Stop/close all processes/resources with:\n  (.close system)\n)\n```\n\nIt can be used in conjunction with `with-open` in test file to create\nwell-contained, independent tests:\n\n``` clojure\n(with-open [{:keys [consumer] :as app} (start config)]\n  (testing \"unit test with isolated, repeatable context\"\n    (is (= :yay/\ud83d\ude80 (some-business/function consumer)))))\n```\n\nYou could also use thi library while live-coding to stop and restart\nyour application whenever a file is changed.\n\n## More details\n\n``` clojure\n(defn start\n  \"Return a map describing a running application, and which values may\n  be closed.\"\n  [config]\n  (closeable-map/closeable-map\n    {;; Kafka producers/consumers are `java.io.Closeable`.\n     :producer (kafka-producer config)\n     :consumer (kafka-consumer config)\n\n     ;; File streams are `java.io.Closeable` too:\n     :logfile (io/output-stream (io/file \"/tmp/log.txt\"))\n\n     ;; Closeable maps can be nested. Nested maps will be closed before the outer map.\n     :backend/api {:response-executor (close-with (memfn ^ExecutorService .shutdown)\n                                        (flow/utilization-executor (:executor config)))\n                   :connection-pool (close-with (memfn ^IPool .shutdown)\n                                      (http/connection-pool {:pool-opts config}))\n\n                   ;; These functions receive their map as argument.\n                   ::closeable-map/before-close (fn [m] (backend/give-up-leadership config m))\n                   ::closeable-map/after-close (fn [m] (backend/close-connection config m))}\n\n     ;; Any exception when closing this nested map will be swallowed\n     ;; and not bubbled up.\n     :db ^::closeable-map/swallow {;; Connection are `java.io.Closeable`, too:\n                                   :db-conn (jdbc/get-connection (:db config))}\n\n     ;; Some libs return a zero-argument function which when called\n     ;; stops the server, like:\n     :server (with-tag ::closeable-map/fn (http/start-server (api config) (:server config)))\n     ;; Gotcha: Clojure meta data can only be attached on 'concrete'\n     ;; objects; they are lost on literal forms (see above).\n     :forensic ^::closeable-map/fn #(metrics/report-death!)\n\n     ::closeable-map/ex-handler\n     (fn [ex]\n       ;; Will be called for all exceptions thrown when closing this\n       ;; map and nested items.\n       (println (ex-message ex)))}))\n```\n\nWhen `(.close system)` is executed, it will:\n\n  - Recursively close all instances of `java.io.Closeable` and\n    `java.lang.AutoCloseable`;\n\n  - Recursively call all stop zero-argument functions tagged with\n    `^::closeable-map/fn`;\n\n  - Skip all nested `Closeable` under a `^::closeable-map/ignore`;\n\n  - Silently swallow any exception with `^::closeable-map/swallow`;\n\n  - Exceptions to optional `::closeable-map/ex-handler` in key or\n    metadata;\n\n  - If keys (or metadata) `::closeable-map/before-close` or\n    `::closeable-map/after-close` are present, they will be assumed as\n    a function which takes one argument (the map itself) and used run\n    additional closing logic:\n\n    ``` clojure\n    (closeable-map\n      {;; This function will be executed before the auto close.\n       ::closeable-map/before-close (fn [this-map] (flush!))\n\n       ;; Kafka producers/consumers are java.io.Closeable\n       :producer (kafka-producer config)\n       :consumer (kafka-consumer config)\n\n       ;; This function will be executed after the auto close.\n       ::closeable-map/after-close (fn [this-map] (garbage/collect!))\n      }\n    )\n    ```\n\nSome classes do not implement `java.lang.AutoCloseable` but present\nsome similar method. For example instances of\n`java.util.concurrent.ExecutorService` can't be closed but they can be\n`.shutdown`:\n\n``` clojure\n{:response-executor (close-with (memfn ^ExecutorService .shutdown)\n                      (flow/utilization-executor (:executor config)))\n :connection-pool (close-with (memfn ^IPool .shutdown)\n                    (http/connection-pool {:pool-opts config}))}\n```\n\nYou may also extend this library by giving new dispatch values to\nmultimethod [[piotr-yuxuan.closeable-map/close!]]. Once evaluated,\nthis will work accross all your code. The multimethod is dispatched on\nthe concrete class of its argument:\n\n``` clojure\n(import '(java.util.concurrent ExecutorService))\n(defmethod closeable-map/close! ExecutorService\n  [x]\n  (.shutdown ^ExecutorService x))\n\n(import '(io.aleph.dirigiste IPool))\n(defmethod closeable-map/close! IPool\n  [x]\n  (.shutdown ^IPool x))\n\n## All or nothing: opening a map atomically\n\nIn some circumstances you may need to handle exception on the creation\nof a closeable map. If an exception happens during the creation of the\nmap, values already evaluated will be closed. No closeable objects\nwill be left open with no references to them.\n\nFor instance, this form would throw an exception:\n\n``` clojure\n(closeable-map/closeable-map {:server (http/start-server (api config))\n                              :kafka {:consumer (kafka-consumer config)\n                                      :producer (throw (ex-info \"Exception\" {}))}})\n;; => (ex-info \"Exception\" {})\n```\n\nThe problem is: `consumer` and `server` stay open but with no\nreferences. Kafka messages keep being consumed and the port stays\nlocked. Using `with-closeable` prevents that kind of broken, partially\nopen maps:\n\n``` clojure\n(closeable-map/with-closeable [server (http/start-server (api config))\n                               consumer (kafka-consumer config)\n                               producer (throw (ex-info \"Exception\" {}))]\n  (closeable-map/closeable-map {:server server\n                                :kafka {:consumer consumer\n                                        :producer producer}}))\n;; `consumer` is closed, then `server` is closed, and finally the\n;; exception is bubbled up.\n;; => (ex-info \"Exception\" {})\n```"}));

    public static Object invokeStatic() {
        return ((IFn)const__0.getRawRoot()).invoke(((IFn)const__1.getRawRoot()).invoke((Object)const__2), const__3.getRawRoot(), (Object)const__4);
    }

    public Object invoke() {
        return closeable_map$fn__878.invokeStatic();
    }
}

