# futils – Function Utilities Library

[![Build Status](https://travis-ci.org/siefca/futils.png?branch=master)](https://travis-ci.org/siefca/futils)

This library defines forms that abstract some common operations on functions,
like counting their arguments, creating wrappers, passing proper number of
arguments, transforming positional-based arities into named ones and so on.

## Installation

The current release is 1.0.2. To use futils in your project, add the following
to the `dependencies` section of `project.clj`:

```
[pl.randomseed/futils "1.0.2"]
```

## Components

Currently prvided macros and functions are:

* [`argc`][argc] – counts arguments a function takes (for all arities),
* [`relax`][relax] – wraps a function in a way that it accepts any number of
  arguments,
* [`relax*`][relax*] – like `relax` but it requires to explicitly
  describe the accepted arities,
* [`nameize`][nameize] – transforms a function so it accepts named arguments,
* [`nameize*`][nameize*] – like `nameize` but requires symbols to be quoted,
* [`frepeat`][frepeat] – creates a sequence of returned values using a function
  with named parameters,
* [`mapply`][mapply] – works like apply but for named arguments.

## Documentation

Full documentation with usage examples is available on:

* https://randomseed.pl/software/futils/

## Sneak peeks

```clojure
(require 'futils.args)
(require 'futils.named)

;; counting arities
;;
(futils.args/argc reduce)
; => {:arities (2 3)
      :engine :jvm
      :variadic false}

;; relaxing arities
;;
(def f (futils.args/relax reduce))
(f + 0 [1 2 3 4] :ignored :args)
; => 10

(def f (futils.args/relax #(vector %1 %2)))
(f 1)
; => [1 nil]

(def f (futils.args/relax #(vector %1 %2) :verbose true))
(f 1)
; => {:argc-cutted 0
; =>  :argc-padded 1
; =>  :argc-received 1
; =>  :argc-sent 2
; =>  :args-received (1)
; =>  :args-sent (1 nil)
; =>  :arities (2)
; =>  :arity-matched 2
; =>  :engine :jvm
; =>  :result [1 nil]
; =>  :variadic false
; =>  :variadic-used false
; =>  :verbose true}

;; nameization
;;
(def f (futils.named/nameize
        reduce
        [f coll]
        [f val coll]))

(f :f +
   :coll [1 1 2 3])
; => 7

(f :f +
   :val 1
   :coll [1 1 2 3])
; => 8
```

## Examples

Examples can be found in the documentation or in test files located under
`test/futils` subdirectory of the sources.

## License

Copyright © 2015 Paweł Wilk

Futils is copyrighted software owned by Paweł Wilk (pw@gnu.org). You may
redistribute and/or modify this software as long as you comply with the terms of
the [GNU Lesser General Public License][LICENSE] (version 3).

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

[NEWS.md]:    https://github.com/siefca/futils/blob/master/NEWS.md
[LICENSE]:    https://github.com/siefca/futils/blob/master/LICENSE
[argc]:       https://randomseed.pl/software/futils/#argc
[relax]:      https://randomseed.pl/software/futils/#relax
[relax*]:     https://randomseed.pl/software/futils/#relax*
[nameize]:    https://randomseed.pl/software/futils/#nameize
[nameize*]:   https://randomseed.pl/software/futils/#nameize*
[frepeat]:    https://randomseed.pl/software/futils/#frepeat
[mapply]:     https://randomseed.pl/software/futils/#mapply

