/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.RegularImmutableMap;
import java.util.Map;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableBiMap<K, V>
extends ImmutableBiMap<K, V> {
    static final RegularImmutableBiMap<Object, Object> EMPTY = new RegularImmutableBiMap();
    private final transient int[] keyHashTable;
    @VisibleForTesting
    final transient Object[] alternatingKeysAndValues;
    private final transient int keyOffset;
    private final transient int size;
    private final transient RegularImmutableBiMap<V, K> inverse;

    private RegularImmutableBiMap() {
        this.keyHashTable = null;
        this.alternatingKeysAndValues = new Object[0];
        this.keyOffset = 0;
        this.size = 0;
        this.inverse = this;
    }

    RegularImmutableBiMap(Object[] alternatingKeysAndValues, int size2) {
        this.alternatingKeysAndValues = alternatingKeysAndValues;
        this.size = size2;
        this.keyOffset = 0;
        int tableSize = size2 >= 2 ? ImmutableSet.chooseTableSize(size2) : 0;
        this.keyHashTable = RegularImmutableMap.createHashTable(alternatingKeysAndValues, size2, tableSize, 0);
        int[] valueHashTable = RegularImmutableMap.createHashTable(alternatingKeysAndValues, size2, tableSize, 1);
        this.inverse = new RegularImmutableBiMap<K, V>(valueHashTable, alternatingKeysAndValues, size2, this);
    }

    private RegularImmutableBiMap(int[] valueHashTable, Object[] alternatingKeysAndValues, int size2, RegularImmutableBiMap<V, K> inverse) {
        this.keyHashTable = valueHashTable;
        this.alternatingKeysAndValues = alternatingKeysAndValues;
        this.keyOffset = 1;
        this.size = size2;
        this.inverse = inverse;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ImmutableBiMap<V, K> inverse() {
        return this.inverse;
    }

    @Override
    public V get(@NullableDecl Object key2) {
        return (V)RegularImmutableMap.get(this.keyHashTable, this.alternatingKeysAndValues, this.size, this.keyOffset, key2);
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new RegularImmutableMap.EntrySet(this, this.alternatingKeysAndValues, this.keyOffset, this.size);
    }

    @Override
    ImmutableSet<K> createKeySet() {
        RegularImmutableMap.KeysOrValuesAsList keyList = new RegularImmutableMap.KeysOrValuesAsList(this.alternatingKeysAndValues, this.keyOffset, this.size);
        return new RegularImmutableMap.KeySet<Object>(this, keyList);
    }

    @Override
    boolean isPartialView() {
        return false;
    }
}

