/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.conn.util.DomainType;
import org.apache.http.conn.util.PublicSuffixList;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class PublicSuffixListParser {
    public PublicSuffixList parse(Reader reader2) throws IOException {
        String line2;
        ArrayList<String> rules = new ArrayList<String>();
        ArrayList<String> exceptions = new ArrayList<String>();
        BufferedReader r = new BufferedReader(reader2);
        while ((line2 = r.readLine()) != null) {
            boolean isException;
            if (line2.isEmpty() || line2.startsWith("//")) continue;
            if (line2.startsWith(".")) {
                line2 = line2.substring(1);
            }
            if (isException = line2.startsWith("!")) {
                line2 = line2.substring(1);
            }
            if (isException) {
                exceptions.add(line2);
                continue;
            }
            rules.add(line2);
        }
        return new PublicSuffixList(DomainType.UNKNOWN, rules, exceptions);
    }

    public List<PublicSuffixList> parseByType(Reader reader2) throws IOException {
        String line2;
        ArrayList<PublicSuffixList> result = new ArrayList<PublicSuffixList>(2);
        BufferedReader r = new BufferedReader(reader2);
        StringBuilder sb = new StringBuilder(256);
        DomainType domainType = null;
        ArrayList<String> rules = null;
        ArrayList<String> exceptions = null;
        while ((line2 = r.readLine()) != null) {
            boolean isException;
            if (line2.isEmpty()) continue;
            if (line2.startsWith("//")) {
                if (domainType == null) {
                    if (line2.contains("===BEGIN ICANN DOMAINS===")) {
                        domainType = DomainType.ICANN;
                        continue;
                    }
                    if (!line2.contains("===BEGIN PRIVATE DOMAINS===")) continue;
                    domainType = DomainType.PRIVATE;
                    continue;
                }
                if (!line2.contains("===END ICANN DOMAINS===") && !line2.contains("===END PRIVATE DOMAINS===")) continue;
                if (rules != null) {
                    result.add(new PublicSuffixList(domainType, rules, exceptions));
                }
                domainType = null;
                rules = null;
                exceptions = null;
                continue;
            }
            if (domainType == null) continue;
            if (line2.startsWith(".")) {
                line2 = line2.substring(1);
            }
            if (isException = line2.startsWith("!")) {
                line2 = line2.substring(1);
            }
            if (isException) {
                if (exceptions == null) {
                    exceptions = new ArrayList<String>();
                }
                exceptions.add(line2);
                continue;
            }
            if (rules == null) {
                rules = new ArrayList<String>();
            }
            rules.add(line2);
        }
        return result;
    }
}

