/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.classrealm;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.classrealm.ArtifactClassRealmConstituent;
import org.apache.maven.classrealm.ClassRealmConstituent;
import org.apache.maven.classrealm.ClassRealmManager;
import org.apache.maven.classrealm.ClassRealmManagerDelegate;
import org.apache.maven.classrealm.ClassRealmRequest;
import org.apache.maven.classrealm.DefaultClassRealmRequest;
import org.apache.maven.extension.internal.CoreExportsProvider;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.artifact.Artifact;

@Named
@Singleton
public class DefaultClassRealmManager
implements ClassRealmManager {
    public static final String API_REALMID = "maven.api";
    private static final ClassLoader PARENT_CLASSLOADER = ClassWorld.class.getClassLoader();
    private final Logger logger;
    private final ClassWorld world;
    private final ClassRealm containerRealm;
    private final List<ClassRealmManagerDelegate> delegates;
    private final ClassRealm mavenApiRealm;
    private final Set<String> providedArtifacts;

    @Inject
    public DefaultClassRealmManager(Logger logger, PlexusContainer container, List<ClassRealmManagerDelegate> delegates, CoreExportsProvider exports) {
        this.logger = logger;
        this.world = ((MutablePlexusContainer)container).getClassWorld();
        this.containerRealm = container.getContainerRealm();
        this.delegates = delegates;
        Map<String, ClassLoader> foreignImports = exports.get().getExportedPackages();
        this.mavenApiRealm = this.createRealm(API_REALMID, ClassRealmRequest.RealmType.Core, null, null, foreignImports, null);
        this.providedArtifacts = exports.get().getExportedArtifacts();
    }

    private ClassRealm newRealm(String id) {
        ClassWorld classWorld = this.world;
        synchronized (classWorld) {
            String realmId = id;
            Random random = new Random();
            while (true) {
                try {
                    ClassRealm classRealm = this.world.newRealm(realmId, null);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Created new class realm " + realmId);
                    }
                    return classRealm;
                }
                catch (DuplicateRealmException e2) {
                    realmId = id + '-' + random.nextInt();
                    continue;
                }
                break;
            }
        }
    }

    @Override
    public ClassRealm getMavenApiRealm() {
        return this.mavenApiRealm;
    }

    private ClassRealm createRealm(String baseRealmId, ClassRealmRequest.RealmType type2, ClassLoader parent2, List<String> parentImports, Map<String, ClassLoader> foreignImports, List<Artifact> artifacts) {
        LinkedHashSet<String> artifactIds = new LinkedHashSet<String>();
        ArrayList<ClassRealmConstituent> constituents = new ArrayList<ClassRealmConstituent>();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                if (this.isProvidedArtifact(artifact)) continue;
                artifactIds.add(DefaultClassRealmManager.getId(artifact));
                if (artifact.getFile() == null) continue;
                constituents.add(new ArtifactClassRealmConstituent(artifact));
            }
        }
        parentImports = parentImports != null ? new ArrayList<String>(parentImports) : new ArrayList<String>();
        foreignImports = foreignImports != null ? new TreeMap<String, ClassLoader>(foreignImports) : new TreeMap<String, ClassLoader>();
        ClassRealm classRealm = this.newRealm(baseRealmId);
        if (parent2 != null) {
            classRealm.setParentClassLoader(parent2);
        }
        this.callDelegates(classRealm, type2, parent2, parentImports, foreignImports, constituents);
        this.wireRealm(classRealm, parentImports, foreignImports);
        Set<String> includedIds = this.populateRealm(classRealm, constituents);
        if (this.logger.isDebugEnabled()) {
            artifactIds.removeAll(includedIds);
            for (String id : artifactIds) {
                this.logger.debug("  Excluded: " + id);
            }
        }
        return classRealm;
    }

    @Override
    public ClassRealm getCoreRealm() {
        return this.containerRealm;
    }

    @Override
    public ClassRealm createProjectRealm(Model model, List<Artifact> artifacts) {
        Objects.requireNonNull(model, "model cannot be null");
        ClassRealm parent2 = this.getMavenApiRealm();
        return this.createRealm(DefaultClassRealmManager.getKey(model), ClassRealmRequest.RealmType.Project, parent2, null, null, artifacts);
    }

    private static String getKey(Model model) {
        return "project>" + model.getGroupId() + ":" + model.getArtifactId() + ":" + model.getVersion();
    }

    @Override
    public ClassRealm createExtensionRealm(Plugin plugin, List<Artifact> artifacts) {
        Objects.requireNonNull(plugin, "plugin cannot be null");
        ClassLoader parent2 = PARENT_CLASSLOADER;
        Map<String, ClassLoader> foreignImports = Collections.singletonMap("", this.getMavenApiRealm());
        return this.createRealm(DefaultClassRealmManager.getKey(plugin, true), ClassRealmRequest.RealmType.Extension, parent2, null, foreignImports, artifacts);
    }

    private boolean isProvidedArtifact(Artifact artifact) {
        return this.providedArtifacts.contains(artifact.getGroupId() + ":" + artifact.getArtifactId());
    }

    @Override
    public ClassRealm createPluginRealm(Plugin plugin, ClassLoader parent2, List<String> parentImports, Map<String, ClassLoader> foreignImports, List<Artifact> artifacts) {
        Objects.requireNonNull(plugin, "plugin cannot be null");
        if (parent2 == null) {
            parent2 = PARENT_CLASSLOADER;
        }
        return this.createRealm(DefaultClassRealmManager.getKey(plugin, false), ClassRealmRequest.RealmType.Plugin, parent2, parentImports, foreignImports, artifacts);
    }

    private static String getKey(Plugin plugin, boolean extension2) {
        String version = ArtifactUtils.toSnapshotVersion(plugin.getVersion());
        return (extension2 ? "extension>" : "plugin>") + plugin.getGroupId() + ":" + plugin.getArtifactId() + ":" + version;
    }

    private static String getId(Artifact artifact) {
        return DefaultClassRealmManager.getId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), artifact.getBaseVersion());
    }

    private static String getId(ClassRealmConstituent constituent) {
        return DefaultClassRealmManager.getId(constituent.getGroupId(), constituent.getArtifactId(), constituent.getType(), constituent.getClassifier(), constituent.getVersion());
    }

    private static String getId(String gid, String aid, String type2, String cls, String ver) {
        return gid + ':' + aid + ':' + type2 + (StringUtils.isNotEmpty(cls) ? ':' + cls : "") + ':' + ver;
    }

    private void callDelegates(ClassRealm classRealm, ClassRealmRequest.RealmType type2, ClassLoader parent2, List<String> parentImports, Map<String, ClassLoader> foreignImports, List<ClassRealmConstituent> constituents) {
        ArrayList<ClassRealmManagerDelegate> delegates = new ArrayList<ClassRealmManagerDelegate>(this.delegates);
        if (!delegates.isEmpty()) {
            DefaultClassRealmRequest request = new DefaultClassRealmRequest(type2, parent2, parentImports, foreignImports, constituents);
            for (ClassRealmManagerDelegate delegate : delegates) {
                try {
                    delegate.setupRealm(classRealm, request);
                }
                catch (Exception e2) {
                    this.logger.error(delegate.getClass().getName() + " failed to setup class realm " + classRealm + ": " + e2.getMessage(), e2);
                }
            }
        }
    }

    private Set<String> populateRealm(ClassRealm classRealm, List<ClassRealmConstituent> constituents) {
        LinkedHashSet<String> includedIds = new LinkedHashSet<String>();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Populating class realm " + classRealm.getId());
        }
        for (ClassRealmConstituent constituent : constituents) {
            File file2 = constituent.getFile();
            String id = DefaultClassRealmManager.getId(constituent);
            includedIds.add(id);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("  Included: " + id);
            }
            try {
                classRealm.addURL(file2.toURI().toURL());
            }
            catch (MalformedURLException e2) {
                this.logger.error(e2.getMessage(), e2);
            }
        }
        return includedIds;
    }

    private void wireRealm(ClassRealm classRealm, List<String> parentImports, Map<String, ClassLoader> foreignImports) {
        if (foreignImports != null && !foreignImports.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Importing foreign packages into class realm " + classRealm.getId());
            }
            for (Map.Entry entry : foreignImports.entrySet()) {
                ClassLoader importedRealm = (ClassLoader)entry.getValue();
                String imp = (String)entry.getKey();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("  Imported: " + imp + " < " + this.getId(importedRealm));
                }
                classRealm.importFrom(importedRealm, imp);
            }
        }
        if (parentImports != null && !parentImports.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Importing parent packages into class realm " + classRealm.getId());
            }
            for (String string2 : parentImports) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("  Imported: " + string2 + " < " + this.getId(classRealm.getParentClassLoader()));
                }
                classRealm.importFromParent(string2);
            }
        }
    }

    private String getId(ClassLoader classLoader) {
        if (classLoader instanceof ClassRealm) {
            return ((ClassRealm)classLoader).getId();
        }
        return String.valueOf(classLoader);
    }
}

