/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.validation;

import java.util.HashSet;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.building.SettingsProblemCollector;
import org.apache.maven.settings.validation.SettingsValidator;
import org.codehaus.plexus.util.StringUtils;

@Named
@Singleton
public class DefaultSettingsValidator
implements SettingsValidator {
    private static final String ID_REGEX = "[A-Za-z0-9_\\-.]+";
    private static final String ILLEGAL_FS_CHARS = "\\/:\"<>|?*";
    private static final String ILLEGAL_REPO_ID_CHARS = "\\/:\"<>|?*";

    @Override
    public void validate(Settings settings, SettingsProblemCollector problems) {
        List<Proxy> proxies;
        List<Profile> profiles;
        List<Mirror> mirrors;
        List<Server> servers;
        List<String> pluginGroups;
        if (settings.isUsePluginRegistry()) {
            DefaultSettingsValidator.addViolation(problems, SettingsProblem.Severity.WARNING, "usePluginRegistry", null, "is deprecated and has no effect.");
        }
        if ((pluginGroups = settings.getPluginGroups()) != null) {
            for (int i = 0; i < pluginGroups.size(); ++i) {
                String pluginGroup = pluginGroups.get(i).trim();
                if (StringUtils.isBlank(pluginGroup)) {
                    DefaultSettingsValidator.addViolation(problems, SettingsProblem.Severity.ERROR, "pluginGroups.pluginGroup[" + i + "]", null, "must not be empty");
                    continue;
                }
                if (pluginGroup.matches(ID_REGEX)) continue;
                DefaultSettingsValidator.addViolation(problems, SettingsProblem.Severity.ERROR, "pluginGroups.pluginGroup[" + i + "]", null, "must denote a valid group id and match the pattern [A-Za-z0-9_\\-.]+");
            }
        }
        if ((servers = settings.getServers()) != null) {
            HashSet<String> serverIds = new HashSet<String>();
            for (int i = 0; i < servers.size(); ++i) {
                Server server2 = servers.get(i);
                DefaultSettingsValidator.validateStringNotEmpty(problems, "servers.server[" + i + "].id", server2.getId(), null);
                if (serverIds.add(server2.getId())) continue;
                DefaultSettingsValidator.addViolation(problems, SettingsProblem.Severity.WARNING, "servers.server.id", null, "must be unique but found duplicate server with id " + server2.getId());
            }
        }
        if ((mirrors = settings.getMirrors()) != null) {
            for (Mirror mirror : mirrors) {
                DefaultSettingsValidator.validateStringNotEmpty(problems, "mirrors.mirror.id", mirror.getId(), mirror.getUrl());
                DefaultSettingsValidator.validateBannedCharacters(problems, "mirrors.mirror.id", SettingsProblem.Severity.WARNING, mirror.getId(), null, "\\/:\"<>|?*");
                if ("local".equals(mirror.getId())) {
                    DefaultSettingsValidator.addViolation(problems, SettingsProblem.Severity.WARNING, "mirrors.mirror.id", null, "must not be 'local', this identifier is reserved for the local repository, using it for other repositories will corrupt your repository metadata.");
                }
                DefaultSettingsValidator.validateStringNotEmpty(problems, "mirrors.mirror.url", mirror.getUrl(), mirror.getId());
                DefaultSettingsValidator.validateStringNotEmpty(problems, "mirrors.mirror.mirrorOf", mirror.getMirrorOf(), mirror.getId());
            }
        }
        if ((profiles = settings.getProfiles()) != null) {
            HashSet<String> profileIds = new HashSet<String>();
            for (Profile profile2 : profiles) {
                if (!profileIds.add(profile2.getId())) {
                    DefaultSettingsValidator.addViolation(problems, SettingsProblem.Severity.WARNING, "profiles.profile.id", null, "must be unique but found duplicate profile with id " + profile2.getId());
                }
                String prefix = "profiles.profile[" + profile2.getId() + "].";
                this.validateRepositories(problems, profile2.getRepositories(), prefix + "repositories.repository");
                this.validateRepositories(problems, profile2.getPluginRepositories(), prefix + "pluginRepositories.pluginRepository");
            }
        }
        if ((proxies = settings.getProxies()) != null) {
            HashSet<String> proxyIds = new HashSet<String>();
            for (Proxy proxy2 : proxies) {
                if (!proxyIds.add(proxy2.getId())) {
                    DefaultSettingsValidator.addViolation(problems, SettingsProblem.Severity.WARNING, "proxies.proxy.id", null, "must be unique but found duplicate proxy with id " + proxy2.getId());
                }
                DefaultSettingsValidator.validateStringNotEmpty(problems, "proxies.proxy.host", proxy2.getHost(), proxy2.getId());
            }
        }
    }

    private void validateRepositories(SettingsProblemCollector problems, List<Repository> repositories, String prefix) {
        HashSet<String> repoIds = new HashSet<String>();
        for (Repository repository : repositories) {
            DefaultSettingsValidator.validateStringNotEmpty(problems, prefix + ".id", repository.getId(), repository.getUrl());
            DefaultSettingsValidator.validateBannedCharacters(problems, prefix + ".id", SettingsProblem.Severity.WARNING, repository.getId(), null, "\\/:\"<>|?*");
            if ("local".equals(repository.getId())) {
                DefaultSettingsValidator.addViolation(problems, SettingsProblem.Severity.WARNING, prefix + ".id", null, "must not be 'local', this identifier is reserved for the local repository, using it for other repositories will corrupt your repository metadata.");
            }
            if (!repoIds.add(repository.getId())) {
                DefaultSettingsValidator.addViolation(problems, SettingsProblem.Severity.WARNING, prefix + ".id", null, "must be unique but found duplicate repository with id " + repository.getId());
            }
            DefaultSettingsValidator.validateStringNotEmpty(problems, prefix + ".url", repository.getUrl(), repository.getId());
            if (!"legacy".equals(repository.getLayout())) continue;
            DefaultSettingsValidator.addViolation(problems, SettingsProblem.Severity.WARNING, prefix + ".layout", repository.getId(), "uses the unsupported value 'legacy', artifact resolution might fail.");
        }
    }

    private static boolean validateStringNotEmpty(SettingsProblemCollector problems, String fieldName, String string2, String sourceHint) {
        if (!DefaultSettingsValidator.validateNotNull(problems, fieldName, string2, sourceHint)) {
            return false;
        }
        if (string2.length() > 0) {
            return true;
        }
        DefaultSettingsValidator.addViolation(problems, SettingsProblem.Severity.ERROR, fieldName, sourceHint, "is missing");
        return false;
    }

    private static boolean validateNotNull(SettingsProblemCollector problems, String fieldName, Object object, String sourceHint) {
        if (object != null) {
            return true;
        }
        DefaultSettingsValidator.addViolation(problems, SettingsProblem.Severity.ERROR, fieldName, sourceHint, "is missing");
        return false;
    }

    private static boolean validateBannedCharacters(SettingsProblemCollector problems, String fieldName, SettingsProblem.Severity severity, String string2, String sourceHint, String banned) {
        if (string2 != null) {
            for (int i = string2.length() - 1; i >= 0; --i) {
                if (banned.indexOf(string2.charAt(i)) < 0) continue;
                DefaultSettingsValidator.addViolation(problems, severity, fieldName, sourceHint, "must not contain any of these characters " + banned + " but found " + string2.charAt(i));
                return false;
            }
        }
        return true;
    }

    private static void addViolation(SettingsProblemCollector problems, SettingsProblem.Severity severity, String fieldName, String sourceHint, String message) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append('\'').append(fieldName).append('\'');
        if (sourceHint != null) {
            buffer.append(" for ").append(sourceHint);
        }
        buffer.append(' ').append(message);
        problems.add(severity, buffer.toString(), -1, -1, null);
    }
}

