/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TrackingFileManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrackingFileManager.class);

    TrackingFileManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties read(File file2) {
        Object object = this.getLock(file2);
        synchronized (object) {
            block9: {
                Properties properties;
                FileLock lock = null;
                FileInputStream stream = null;
                try {
                    if (!file2.exists()) {
                        Properties properties2 = null;
                        return properties2;
                    }
                    stream = new FileInputStream(file2);
                    lock = this.lock(stream.getChannel(), Math.max(1L, file2.length()), true);
                    Properties props = new Properties();
                    props.load(stream);
                    properties = props;
                    this.release(lock, file2);
                }
                catch (IOException e2) {
                    LOGGER.warn("Failed to read tracking file {}", (Object)file2, (Object)e2);
                    break block9;
                }
                this.close(stream, file2);
                return properties;
                finally {
                    this.release(lock, file2);
                    this.close(stream, file2);
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties update(File file2, Map<String, String> updates) {
        Properties props = new Properties();
        Object object = this.getLock(file2);
        synchronized (object) {
            File directory = file2.getParentFile();
            if (!directory.mkdirs() && !directory.exists()) {
                LOGGER.warn("Failed to create parent directories for tracking file {}", (Object)file2);
                return props;
            }
            RandomAccessFile raf = null;
            FileLock lock = null;
            try {
                raf = new RandomAccessFile(file2, "rw");
                lock = this.lock(raf.getChannel(), Math.max(1L, raf.length()), false);
                if (file2.canRead()) {
                    byte[] buffer = new byte[(int)raf.length()];
                    raf.readFully(buffer);
                    ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
                    props.load(stream);
                }
                for (Map.Entry<String, String> update2 : updates.entrySet()) {
                    if (update2.getValue() == null) {
                        props.remove(update2.getKey());
                        continue;
                    }
                    props.setProperty(update2.getKey(), update2.getValue());
                }
                ByteArrayOutputStream stream = new ByteArrayOutputStream(2048);
                LOGGER.debug("Writing tracking file {}", (Object)file2);
                props.store(stream, "NOTE: This is a Maven Resolver internal implementation file, its format can be changed without prior notice.");
                raf.seek(0L);
                raf.write(stream.toByteArray());
                raf.setLength(raf.getFilePointer());
                this.release(lock, file2);
                this.close(raf, file2);
            }
            catch (IOException e2) {
                LOGGER.warn("Failed to write tracking file {}", (Object)file2, (Object)e2);
            }
            finally {
                this.release(lock, file2);
                this.close(raf, file2);
            }
        }
        return props;
    }

    private void release(FileLock lock, File file2) {
        if (lock != null) {
            try {
                lock.release();
            }
            catch (IOException e2) {
                LOGGER.warn("Error releasing lock for tracking file {}", (Object)file2, (Object)e2);
            }
        }
    }

    private void close(Closeable closeable, File file2) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e2) {
                LOGGER.warn("Error closing tracking file {}", (Object)file2, (Object)e2);
            }
        }
    }

    private Object getLock(File file2) {
        try {
            return file2.getCanonicalPath().intern();
        }
        catch (IOException e2) {
            LOGGER.warn("Failed to canonicalize path {}: {}", (Object)file2, (Object)e2.getMessage());
            return file2.getAbsolutePath().intern();
        }
    }

    private FileLock lock(FileChannel channel, long size2, boolean shared) throws IOException {
        FileLock lock = null;
        for (int attempts = 8; attempts >= 0; --attempts) {
            try {
                lock = channel.lock(0L, size2, shared);
                break;
            }
            catch (OverlappingFileLockException e2) {
                if (attempts <= 0) {
                    throw new IOException(e2);
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
        }
        if (lock == null) {
            throw new IOException("Could not lock file");
        }
        return lock;
    }
}

