/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.params.AuthParams;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.params.ConnRouteParams;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DecompressingHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.transport.AbstractTransporter;
import org.eclipse.aether.spi.connector.transport.GetTask;
import org.eclipse.aether.spi.connector.transport.PeekTask;
import org.eclipse.aether.spi.connector.transport.PutTask;
import org.eclipse.aether.spi.connector.transport.TransportTask;
import org.eclipse.aether.transfer.NoTransporterException;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transport.http.DeferredCredentialsProvider;
import org.eclipse.aether.transport.http.DemuxCredentialsProvider;
import org.eclipse.aether.transport.http.HttpMkCol;
import org.eclipse.aether.transport.http.LocalState;
import org.eclipse.aether.transport.http.SharingHttpContext;
import org.eclipse.aether.transport.http.SslConfig;
import org.eclipse.aether.transport.http.UriUtils;
import org.eclipse.aether.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpTransporter
extends AbstractTransporter {
    private static final Pattern CONTENT_RANGE_PATTERN = Pattern.compile("\\s*bytes\\s+([0-9]+)\\s*-\\s*([0-9]+)\\s*/.*");
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpTransporter.class);
    private final AuthenticationContext repoAuthContext;
    private final AuthenticationContext proxyAuthContext;
    private final URI baseUri;
    private final HttpHost server;
    private final HttpHost proxy;
    private final HttpClient client;
    private final Map<?, ?> headers;
    private final LocalState state;

    HttpTransporter(RemoteRepository repository, RepositorySystemSession session) throws NoTransporterException {
        if (!"http".equalsIgnoreCase(repository.getProtocol()) && !"https".equalsIgnoreCase(repository.getProtocol())) {
            throw new NoTransporterException(repository);
        }
        try {
            this.baseUri = new URI(repository.getUrl()).parseServerAuthority();
            if (this.baseUri.isOpaque()) {
                throw new URISyntaxException(repository.getUrl(), "URL must not be opaque");
            }
            this.server = URIUtils.extractHost(this.baseUri);
            if (this.server == null) {
                throw new URISyntaxException(repository.getUrl(), "URL lacks host name");
            }
        }
        catch (URISyntaxException e2) {
            throw new NoTransporterException(repository, e2.getMessage(), e2);
        }
        this.proxy = HttpTransporter.toHost(repository.getProxy());
        this.repoAuthContext = AuthenticationContext.forRepository(session, repository);
        this.proxyAuthContext = AuthenticationContext.forProxy(session, repository);
        this.state = new LocalState(session, repository, new SslConfig(session, this.repoAuthContext));
        this.headers = ConfigUtils.getMap(session, Collections.emptyMap(), "aether.connector.http.headers." + repository.getId(), "aether.connector.http.headers");
        DefaultHttpClient client = new DefaultHttpClient(this.state.getConnectionManager());
        HttpTransporter.configureClient(client.getParams(), session, repository, this.proxy);
        client.setCredentialsProvider(HttpTransporter.toCredentialsProvider(this.server, this.repoAuthContext, this.proxy, this.proxyAuthContext));
        this.client = new DecompressingHttpClient(client);
    }

    private static HttpHost toHost(Proxy proxy2) {
        HttpHost host = null;
        if (proxy2 != null) {
            host = new HttpHost(proxy2.getHost(), proxy2.getPort());
        }
        return host;
    }

    private static void configureClient(HttpParams params, RepositorySystemSession session, RemoteRepository repository, HttpHost proxy2) {
        AuthParams.setCredentialCharset(params, ConfigUtils.getString(session, "ISO-8859-1", "aether.connector.http.credentialEncoding." + repository.getId(), "aether.connector.http.credentialEncoding"));
        ConnRouteParams.setDefaultProxy(params, proxy2);
        HttpConnectionParams.setConnectionTimeout(params, ConfigUtils.getInteger(session, 10000, "aether.connector.connectTimeout." + repository.getId(), "aether.connector.connectTimeout"));
        HttpConnectionParams.setSoTimeout(params, ConfigUtils.getInteger(session, 1800000, "aether.connector.requestTimeout." + repository.getId(), "aether.connector.requestTimeout"));
        HttpProtocolParams.setUserAgent(params, ConfigUtils.getString(session, "Aether", "aether.connector.userAgent"));
    }

    private static CredentialsProvider toCredentialsProvider(HttpHost server2, AuthenticationContext serverAuthCtx, HttpHost proxy2, AuthenticationContext proxyAuthCtx) {
        CredentialsProvider provider = HttpTransporter.toCredentialsProvider(server2.getHostName(), -1, serverAuthCtx);
        if (proxy2 != null) {
            CredentialsProvider p = HttpTransporter.toCredentialsProvider(proxy2.getHostName(), proxy2.getPort(), proxyAuthCtx);
            provider = new DemuxCredentialsProvider(provider, p, proxy2);
        }
        return provider;
    }

    private static CredentialsProvider toCredentialsProvider(String host, int port, AuthenticationContext ctx) {
        DeferredCredentialsProvider provider = new DeferredCredentialsProvider();
        if (ctx != null) {
            AuthScope basicScope = new AuthScope(host, port);
            provider.setCredentials(basicScope, new DeferredCredentialsProvider.BasicFactory(ctx));
            AuthScope ntlmScope = new AuthScope(host, port, AuthScope.ANY_REALM, "ntlm");
            provider.setCredentials(ntlmScope, new DeferredCredentialsProvider.NtlmFactory(ctx));
        }
        return provider;
    }

    LocalState getState() {
        return this.state;
    }

    private URI resolve(TransportTask task) {
        return UriUtils.resolve(this.baseUri, task.getLocation());
    }

    @Override
    public int classify(Throwable error2) {
        if (error2 instanceof HttpResponseException && ((HttpResponseException)error2).getStatusCode() == 404) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void implPeek(PeekTask task) throws Exception {
        HttpHead request = this.commonHeaders(new HttpHead(this.resolve(task)));
        this.execute(request, null);
    }

    @Override
    protected void implGet(GetTask task) throws Exception {
        EntityGetter getter = new EntityGetter(task);
        HttpGet request = this.commonHeaders(new HttpGet(this.resolve(task)));
        this.resume(request, task);
        try {
            this.execute(request, getter);
        }
        catch (HttpResponseException e2) {
            if (e2.getStatusCode() == 412 && request.containsHeader("Range")) {
                request = this.commonHeaders(new HttpGet(request.getURI()));
                this.execute(request, getter);
                return;
            }
            throw e2;
        }
    }

    @Override
    protected void implPut(PutTask task) throws Exception {
        PutTaskEntity entity2 = new PutTaskEntity(task);
        HttpPut request = (HttpPut)this.commonHeaders((HttpUriRequest)this.entity(new HttpPut(this.resolve(task)), entity2));
        try {
            this.execute(request, null);
        }
        catch (HttpResponseException e2) {
            if (e2.getStatusCode() == 417 && request.containsHeader("Expect")) {
                this.state.setExpectContinue(false);
                request = (HttpPut)this.commonHeaders((HttpUriRequest)this.entity(new HttpPut(request.getURI()), entity2));
                this.execute(request, null);
                return;
            }
            throw e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(HttpUriRequest request, EntityGetter getter) throws Exception {
        try {
            SharingHttpContext context = new SharingHttpContext(this.state);
            this.prepare(request, context);
            HttpResponse response = this.client.execute(this.server, (HttpRequest)request, (HttpContext)context);
            try {
                context.close();
                this.handleStatus(response);
                if (getter != null) {
                    getter.handle(response);
                }
            }
            finally {
                EntityUtils.consumeQuietly(response.getEntity());
            }
        }
        catch (IOException e2) {
            if (e2.getCause() instanceof TransferCancelledException) {
                throw (Exception)e2.getCause();
            }
            throw e2;
        }
    }

    private void prepare(HttpUriRequest request, SharingHttpContext context) {
        boolean put = "PUT".equalsIgnoreCase(request.getMethod());
        if (this.state.getWebDav() == null && (put || this.isPayloadPresent(request))) {
            try {
                HttpOptions req = this.commonHeaders(new HttpOptions(request.getURI()));
                HttpResponse response = this.client.execute(this.server, (HttpRequest)req, (HttpContext)context);
                this.state.setWebDav(this.isWebDav(response));
                EntityUtils.consumeQuietly(response.getEntity());
            }
            catch (IOException e2) {
                LOGGER.debug("Failed to prepare HTTP context", e2);
            }
        }
        if (put && Boolean.TRUE.equals(this.state.getWebDav())) {
            this.mkdirs(request.getURI(), context);
        }
    }

    private boolean isWebDav(HttpResponse response) {
        return response.containsHeader("Dav");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mkdirs(URI uri, SharingHttpContext context) {
        HttpResponse response;
        int index2;
        List<URI> dirs = UriUtils.getDirectories(this.baseUri, uri);
        for (index2 = 0; index2 < dirs.size(); ++index2) {
            try {
                response = this.client.execute(this.server, (HttpRequest)this.commonHeaders(new HttpMkCol(dirs.get(index2))), (HttpContext)context);
                try {
                    int status = response.getStatusLine().getStatusCode();
                    if (status < 300 || status == 405) break;
                    if (status == 409) continue;
                    this.handleStatus(response);
                    continue;
                }
                finally {
                    EntityUtils.consumeQuietly(response.getEntity());
                }
            }
            catch (IOException e2) {
                LOGGER.debug("Failed to create parent directory {}", (Object)dirs.get(index2), (Object)e2);
                return;
            }
        }
        --index2;
        while (index2 >= 0) {
            try {
                response = this.client.execute(this.server, (HttpRequest)this.commonHeaders(new HttpMkCol(dirs.get(index2))), (HttpContext)context);
                try {
                    this.handleStatus(response);
                }
                finally {
                    EntityUtils.consumeQuietly(response.getEntity());
                }
            }
            catch (IOException e3) {
                LOGGER.debug("Failed to create parent directory {}", (Object)dirs.get(index2), (Object)e3);
                return;
            }
            --index2;
        }
    }

    private <T extends HttpEntityEnclosingRequest> T entity(T request, HttpEntity entity2) {
        request.setEntity(entity2);
        return request;
    }

    private boolean isPayloadPresent(HttpUriRequest request) {
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntity entity2 = ((HttpEntityEnclosingRequest)((Object)request)).getEntity();
            return entity2 != null && entity2.getContentLength() != 0L;
        }
        return false;
    }

    private <T extends HttpUriRequest> T commonHeaders(T request) {
        request.setHeader("Cache-Control", "no-cache, no-store");
        request.setHeader("Pragma", "no-cache");
        if (this.state.isExpectContinue() && this.isPayloadPresent(request)) {
            request.setHeader("Expect", "100-continue");
        }
        for (Map.Entry<?, ?> entry : this.headers.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            if (entry.getValue() instanceof String) {
                request.setHeader(entry.getKey().toString(), entry.getValue().toString());
                continue;
            }
            request.removeHeaders(entry.getKey().toString());
        }
        if (!this.state.isExpectContinue()) {
            request.removeHeaders("Expect");
        }
        return request;
    }

    private <T extends HttpUriRequest> T resume(T request, GetTask task) {
        long resumeOffset = task.getResumeOffset();
        if (resumeOffset > 0L && task.getDataFile() != null) {
            request.setHeader("Range", "bytes=" + resumeOffset + '-');
            request.setHeader("If-Unmodified-Since", DateUtils.formatDate(new Date(task.getDataFile().lastModified() - 60000L)));
            request.setHeader("Accept-Encoding", "identity");
        }
        return request;
    }

    private void handleStatus(HttpResponse response) throws HttpResponseException {
        int status = response.getStatusLine().getStatusCode();
        if (status >= 300) {
            throw new HttpResponseException(status, response.getStatusLine().getReasonPhrase() + " (" + status + ")");
        }
    }

    @Override
    protected void implClose() {
        AuthenticationContext.close(this.repoAuthContext);
        AuthenticationContext.close(this.proxyAuthContext);
        this.state.close();
    }

    private class PutTaskEntity
    extends AbstractHttpEntity {
        private final PutTask task;

        PutTaskEntity(PutTask task) {
            this.task = task;
        }

        @Override
        public boolean isRepeatable() {
            return true;
        }

        @Override
        public boolean isStreaming() {
            return false;
        }

        @Override
        public long getContentLength() {
            return this.task.getDataLength();
        }

        @Override
        public InputStream getContent() throws IOException {
            return this.task.newInputStream();
        }

        @Override
        public void writeTo(OutputStream os) throws IOException {
            try {
                HttpTransporter.this.utilPut(this.task, os, false);
            }
            catch (TransferCancelledException e2) {
                throw (IOException)new InterruptedIOException().initCause(e2);
            }
        }
    }

    private class EntityGetter {
        private final GetTask task;

        EntityGetter(GetTask task) {
            this.task = task;
        }

        public void handle(HttpResponse response) throws IOException, TransferCancelledException {
            HttpEntity entity2 = response.getEntity();
            if (entity2 == null) {
                entity2 = new ByteArrayEntity(new byte[0]);
            }
            long offset = 0L;
            long length = entity2.getContentLength();
            String range2 = this.getHeader(response, "Content-Range");
            if (range2 != null) {
                Matcher m3 = CONTENT_RANGE_PATTERN.matcher(range2);
                if (!m3.matches()) {
                    throw new IOException("Invalid Content-Range header for partial download: " + range2);
                }
                offset = Long.parseLong(m3.group(1));
                length = Long.parseLong(m3.group(2)) + 1L;
                if (offset < 0L || offset >= length || offset > 0L && offset != this.task.getResumeOffset()) {
                    throw new IOException("Invalid Content-Range header for partial download from offset " + this.task.getResumeOffset() + ": " + range2);
                }
            }
            InputStream is2 = entity2.getContent();
            HttpTransporter.this.utilGet(this.task, is2, true, length, offset > 0L);
            this.extractChecksums(response);
        }

        private void extractChecksums(HttpResponse response) {
            String etag = this.getHeader(response, "ETag");
            if (etag != null) {
                int start = etag.indexOf("SHA1{");
                int end = etag.indexOf("}", start + 5);
                if (start >= 0 && end > start) {
                    this.task.setChecksum("SHA-1", etag.substring(start + 5, end));
                }
            }
        }

        private String getHeader(HttpResponse response, String name2) {
            Header header = response.getFirstHeader(name2);
            return header != null ? header.getValue() : null;
        }
    }
}

