/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.artifact;

import java.io.File;
import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.artifact.AbstractArtifact;
import org.eclipse.aether.artifact.Artifact;

public final class SubArtifact
extends AbstractArtifact {
    private final Artifact mainArtifact;
    private final String classifier;
    private final String extension;
    private final File file;
    private final Map<String, String> properties;

    public SubArtifact(Artifact mainArtifact, String classifier, String extension2) {
        this(mainArtifact, classifier, extension2, (File)null);
    }

    public SubArtifact(Artifact mainArtifact, String classifier, String extension2, File file2) {
        this(mainArtifact, classifier, extension2, null, file2);
    }

    public SubArtifact(Artifact mainArtifact, String classifier, String extension2, Map<String, String> properties) {
        this(mainArtifact, classifier, extension2, properties, null);
    }

    public SubArtifact(Artifact mainArtifact, String classifier, String extension2, Map<String, String> properties, File file2) {
        this.mainArtifact = Objects.requireNonNull(mainArtifact, "main artifact cannot be null");
        this.classifier = classifier;
        this.extension = extension2;
        this.file = file2;
        this.properties = SubArtifact.copyProperties(properties);
    }

    private SubArtifact(Artifact mainArtifact, String classifier, String extension2, File file2, Map<String, String> properties) {
        this.mainArtifact = mainArtifact;
        this.classifier = classifier;
        this.extension = extension2;
        this.file = file2;
        this.properties = properties;
    }

    @Override
    public String getGroupId() {
        return this.mainArtifact.getGroupId();
    }

    @Override
    public String getArtifactId() {
        return this.mainArtifact.getArtifactId();
    }

    @Override
    public String getVersion() {
        return this.mainArtifact.getVersion();
    }

    @Override
    public String getBaseVersion() {
        return this.mainArtifact.getBaseVersion();
    }

    @Override
    public boolean isSnapshot() {
        return this.mainArtifact.isSnapshot();
    }

    @Override
    public String getClassifier() {
        return SubArtifact.expand(this.classifier, this.mainArtifact.getClassifier());
    }

    @Override
    public String getExtension() {
        return SubArtifact.expand(this.extension, this.mainArtifact.getExtension());
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public Artifact setFile(File file2) {
        if (Objects.equals(this.file, file2)) {
            return this;
        }
        return new SubArtifact(this.mainArtifact, this.classifier, this.extension, file2, this.properties);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public Artifact setProperties(Map<String, String> properties) {
        if (this.properties.equals(properties) || properties == null && this.properties.isEmpty()) {
            return this;
        }
        return new SubArtifact(this.mainArtifact, this.classifier, this.extension, properties, this.file);
    }

    private static String expand(String pattern, String replacement) {
        String result = "";
        if (pattern != null) {
            result = pattern.replace("*", replacement);
            if (replacement.length() <= 0) {
                char c;
                int i;
                if (pattern.startsWith("*")) {
                    for (i = 0; i < result.length() && ((c = result.charAt(i)) == '-' || c == '.'); ++i) {
                    }
                    result = result.substring(i);
                }
                if (pattern.endsWith("*")) {
                    for (i = result.length() - 1; i >= 0 && ((c = result.charAt(i)) == '-' || c == '.'); --i) {
                    }
                    result = result.substring(0, i + 1);
                }
            }
        }
        return result;
    }
}

