/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;

public class FileDestroyable
implements Destroyable {
    private static final Logger LOG = Log.getLogger(FileDestroyable.class);
    final List<File> _files = new ArrayList<File>();

    public FileDestroyable() {
    }

    public FileDestroyable(String file2) throws IOException {
        this._files.add(Resource.newResource(file2).getFile());
    }

    public FileDestroyable(File file2) {
        this._files.add(file2);
    }

    public void addFile(String file2) throws IOException {
        try (Resource r = Resource.newResource(file2);){
            this._files.add(r.getFile());
        }
    }

    public void addFile(File file2) {
        this._files.add(file2);
    }

    public void addFiles(Collection<File> files2) {
        this._files.addAll(files2);
    }

    public void removeFile(String file2) throws IOException {
        try (Resource r = Resource.newResource(file2);){
            this._files.remove(r.getFile());
        }
    }

    public void removeFile(File file2) {
        this._files.remove(file2);
    }

    @Override
    public void destroy() {
        for (File file2 : this._files) {
            if (!file2.exists()) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Destroy {}", file2);
            }
            IO.delete(file2);
        }
    }
}

