/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class CreateBranchCommand
extends GitCommand<Ref> {
    private String name;
    private boolean force = false;
    private SetupUpstreamMode upstreamMode;
    private String startPoint = "HEAD";
    private RevCommit startCommit;

    protected CreateBranchCommand(Repository repo) {
        super(repo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Ref call() throws GitAPIException, RefAlreadyExistsException, RefNotFoundException, InvalidRefNameException {
        this.checkCallable();
        this.processOptions();
        try (RevWalk revWalk = new RevWalk(this.repo);){
            String autosetupflag;
            String refLogMessage;
            Ref baseRef;
            boolean exists2;
            Ref refToCheck = this.repo.findRef(this.name);
            boolean bl = exists2 = refToCheck != null && refToCheck.getName().startsWith("refs/heads/");
            if (!this.force && exists2) {
                throw new RefAlreadyExistsException(MessageFormat.format(JGitText.get().refAlreadyExists1, this.name));
            }
            ObjectId startAt = this.getStartPointObjectId();
            String startPointFullName = null;
            if (this.startPoint != null && (baseRef = this.repo.findRef(this.startPoint)) != null) {
                startPointFullName = baseRef.getName();
            }
            String baseBranch = "";
            if (startPointFullName == null) {
                String baseCommit;
                if (this.startCommit != null) {
                    baseCommit = this.startCommit.getShortMessage();
                } else {
                    RevCommit commit = revWalk.parseCommit(this.repo.resolve(this.getStartPointOrHead()));
                    baseCommit = commit.getShortMessage();
                }
                refLogMessage = exists2 ? "branch: Reset start-point to commit " + baseCommit : "branch: Created from commit " + baseCommit;
            } else if (startPointFullName.startsWith("refs/heads/") || startPointFullName.startsWith("refs/remotes/")) {
                baseBranch = startPointFullName;
                refLogMessage = exists2 ? "branch: Reset start-point to branch " + startPointFullName : "branch: Created from branch " + baseBranch;
            } else {
                startAt = revWalk.peel(revWalk.parseAny(startAt));
                refLogMessage = exists2 ? "branch: Reset start-point to tag " + startPointFullName : "branch: Created from tag " + startPointFullName;
            }
            RefUpdate updateRef = this.repo.updateRef("refs/heads/" + this.name);
            updateRef.setNewObjectId(startAt);
            updateRef.setRefLogMessage(refLogMessage, false);
            RefUpdate.Result updateResult = exists2 && this.force ? updateRef.forceUpdate() : updateRef.update();
            this.setCallable(false);
            boolean ok2 = false;
            switch (updateResult) {
                case NEW: {
                    ok2 = !exists2;
                    break;
                }
                case NO_CHANGE: 
                case FAST_FORWARD: 
                case FORCED: {
                    ok2 = exists2;
                    break;
                }
            }
            if (!ok2) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().createBranchUnexpectedResult, updateResult.name()));
            }
            Ref result = this.repo.findRef(this.name);
            if (result == null) {
                throw new JGitInternalException(JGitText.get().createBranchFailedUnknownReason);
            }
            if (baseBranch.length() == 0) {
                Ref ref2 = result;
                return ref2;
            }
            boolean doConfigure = this.upstreamMode == SetupUpstreamMode.SET_UPSTREAM || this.upstreamMode == SetupUpstreamMode.TRACK ? true : (this.upstreamMode == SetupUpstreamMode.NOTRACK ? false : ("false".equals(autosetupflag = this.repo.getConfig().getString("branch", null, "autosetupmerge")) ? false : ("always".equals(autosetupflag) ? true : baseBranch.startsWith("refs/remotes/"))));
            if (doConfigure) {
                StoredConfig config = this.repo.getConfig();
                String remoteName = this.repo.getRemoteName(baseBranch);
                if (remoteName != null) {
                    String branchName = this.repo.shortenRemoteBranchName(baseBranch);
                    config.setString("branch", this.name, "remote", remoteName);
                    config.setString("branch", this.name, "merge", "refs/heads/" + branchName);
                } else {
                    config.setString("branch", this.name, "remote", ".");
                    config.setString("branch", this.name, "merge", baseBranch);
                }
                config.save();
            }
            Ref ref3 = result;
            return ref3;
        }
        catch (IOException ioe) {
            throw new JGitInternalException(ioe.getMessage(), ioe);
        }
    }

    private ObjectId getStartPointObjectId() throws AmbiguousObjectException, RefNotFoundException, IOException {
        if (this.startCommit != null) {
            return this.startCommit.getId();
        }
        String startPointOrHead = this.getStartPointOrHead();
        ObjectId result = this.repo.resolve(startPointOrHead);
        if (result == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, startPointOrHead));
        }
        return result;
    }

    private String getStartPointOrHead() {
        return this.startPoint != null ? this.startPoint : "HEAD";
    }

    private void processOptions() throws InvalidRefNameException {
        if (this.name == null || !Repository.isValidRefName("refs/heads/" + this.name)) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().branchNameInvalid, this.name == null ? "<null>" : this.name));
        }
    }

    public CreateBranchCommand setName(String name2) {
        this.checkCallable();
        this.name = name2;
        return this;
    }

    public CreateBranchCommand setForce(boolean force2) {
        this.checkCallable();
        this.force = force2;
        return this;
    }

    public CreateBranchCommand setStartPoint(String startPoint) {
        this.checkCallable();
        this.startPoint = startPoint;
        this.startCommit = null;
        return this;
    }

    public CreateBranchCommand setStartPoint(RevCommit startPoint) {
        this.checkCallable();
        this.startCommit = startPoint;
        this.startPoint = null;
        return this;
    }

    public CreateBranchCommand setUpstreamMode(SetupUpstreamMode mode) {
        this.checkCallable();
        this.upstreamMode = mode;
        return this;
    }

    public static enum SetupUpstreamMode {
        TRACK,
        NOTRACK,
        SET_UPSTREAM;

    }
}

