/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsOutputStream;
import org.eclipse.jgit.internal.storage.dfs.DfsPackCompactor;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsReftable;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.internal.storage.dfs.ReftableStack;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.internal.storage.reftable.ReftableCompactor;
import org.eclipse.jgit.internal.storage.reftable.ReftableConfig;
import org.eclipse.jgit.internal.storage.reftable.ReftableWriter;
import org.eclipse.jgit.internal.storage.reftree.RefTreeNames;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSet;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.storage.pack.PackStatistics;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.io.CountingOutputStream;

public class DfsGarbageCollector {
    private final DfsRepository repo;
    private final RefDatabase refdb;
    private final DfsObjDatabase objdb;
    private final List<DfsPackDescription> newPackDesc;
    private final List<PackStatistics> newPackStats;
    private final List<ObjectIdSet> newPackObj;
    private DfsReader ctx;
    private PackConfig packConfig;
    private ReftableConfig reftableConfig;
    private boolean convertToReftable = true;
    private boolean includeDeletes;
    private long reftableInitialMinUpdateIndex = 1L;
    private long reftableInitialMaxUpdateIndex = 1L;
    private long coalesceGarbageLimit = 0x3200000L;
    private long garbageTtlMillis = TimeUnit.DAYS.toMillis(1L);
    private long startTimeMillis;
    private List<DfsPackFile> packsBefore;
    private List<DfsReftable> reftablesBefore;
    private List<DfsPackFile> expiredGarbagePacks;
    private Collection<Ref> refsBefore;
    private Set<ObjectId> allHeadsAndTags;
    private Set<ObjectId> allTags;
    private Set<ObjectId> nonHeads;
    private Set<ObjectId> txnHeads;
    private Set<ObjectId> tagTargets;

    public DfsGarbageCollector(DfsRepository repository) {
        this.repo = repository;
        this.refdb = this.repo.getRefDatabase();
        this.objdb = this.repo.getObjectDatabase();
        this.newPackDesc = new ArrayList<DfsPackDescription>(4);
        this.newPackStats = new ArrayList<PackStatistics>(4);
        this.newPackObj = new ArrayList<ObjectIdSet>(4);
        this.packConfig = new PackConfig(this.repo);
        this.packConfig.setIndexVersion(2);
    }

    public PackConfig getPackConfig() {
        return this.packConfig;
    }

    public DfsGarbageCollector setPackConfig(PackConfig newConfig) {
        this.packConfig = newConfig;
        return this;
    }

    public DfsGarbageCollector setReftableConfig(ReftableConfig cfg) {
        this.reftableConfig = cfg;
        return this;
    }

    public DfsGarbageCollector setConvertToReftable(boolean convert) {
        this.convertToReftable = convert;
        return this;
    }

    public DfsGarbageCollector setIncludeDeletes(boolean include) {
        this.includeDeletes = include;
        return this;
    }

    public DfsGarbageCollector setReftableInitialMinUpdateIndex(long u) {
        this.reftableInitialMinUpdateIndex = Math.max(u, 0L);
        return this;
    }

    public DfsGarbageCollector setReftableInitialMaxUpdateIndex(long u) {
        this.reftableInitialMaxUpdateIndex = Math.max(0L, u);
        return this;
    }

    public long getCoalesceGarbageLimit() {
        return this.coalesceGarbageLimit;
    }

    public DfsGarbageCollector setCoalesceGarbageLimit(long limit) {
        this.coalesceGarbageLimit = limit;
        return this;
    }

    public long getGarbageTtlMillis() {
        return this.garbageTtlMillis;
    }

    public DfsGarbageCollector setGarbageTtl(long ttl, TimeUnit unit) {
        this.garbageTtlMillis = unit.toMillis(ttl);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pack(ProgressMonitor pm) throws IOException {
        if (pm == null) {
            pm = NullProgressMonitor.INSTANCE;
        }
        if (this.packConfig.getIndexVersion() != 2) {
            throw new IllegalStateException(JGitText.get().supportOnlyPackIndexVersion2);
        }
        this.startTimeMillis = SystemReader.getInstance().getCurrentTime();
        this.ctx = this.objdb.newReader();
        try {
            this.refdb.refresh();
            this.objdb.clearCache();
            this.refsBefore = this.getAllRefs();
            this.readPacksBefore();
            this.readReftablesBefore();
            HashSet<ObjectId> allHeads = new HashSet<ObjectId>();
            this.allHeadsAndTags = new HashSet<ObjectId>();
            this.allTags = new HashSet<ObjectId>();
            this.nonHeads = new HashSet<ObjectId>();
            this.txnHeads = new HashSet<ObjectId>();
            this.tagTargets = new HashSet<ObjectId>();
            for (Ref ref2 : this.refsBefore) {
                if (ref2.isSymbolic() || ref2.getObjectId() == null) continue;
                if (DfsGarbageCollector.isHead(ref2)) {
                    allHeads.add(ref2.getObjectId());
                } else if (DfsGarbageCollector.isTag(ref2)) {
                    this.allTags.add(ref2.getObjectId());
                } else if (RefTreeNames.isRefTree(this.refdb, ref2.getName())) {
                    this.txnHeads.add(ref2.getObjectId());
                } else {
                    this.nonHeads.add(ref2.getObjectId());
                }
                if (ref2.getPeeledObjectId() == null) continue;
                this.tagTargets.add(ref2.getPeeledObjectId());
            }
            this.allTags.removeAll(allHeads);
            this.allHeadsAndTags.addAll(allHeads);
            this.allHeadsAndTags.addAll(this.allTags);
            this.tagTargets.addAll(this.allHeadsAndTags);
            if (this.packConfig.getSinglePack()) {
                this.allHeadsAndTags.addAll(this.nonHeads);
                this.nonHeads.clear();
            }
            boolean rollback = true;
            try {
                this.packHeads(pm);
                this.packRest(pm);
                this.packRefTreeGraph(pm);
                this.packGarbage(pm);
                this.objdb.commitPack(this.newPackDesc, this.toPrune());
                rollback = false;
                boolean bl = true;
                if (rollback) {
                    this.objdb.rollbackPack(this.newPackDesc);
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (rollback) {
                    this.objdb.rollbackPack(this.newPackDesc);
                }
                throw throwable;
            }
        }
        finally {
            this.ctx.close();
        }
    }

    private Collection<Ref> getAllRefs() throws IOException {
        Collection<Ref> refs = this.refdb.getRefs("").values();
        List<Ref> addl = this.refdb.getAdditionalRefs();
        if (!addl.isEmpty()) {
            ArrayList<Ref> all = new ArrayList<Ref>(refs.size() + addl.size());
            all.addAll(refs);
            for (Ref r : addl) {
                if (!r.getName().startsWith("refs/")) continue;
                all.add(r);
            }
            return all;
        }
        return refs;
    }

    private void readPacksBefore() throws IOException {
        DfsPackFile[] packs = this.objdb.getPacks();
        this.packsBefore = new ArrayList<DfsPackFile>(packs.length);
        this.expiredGarbagePacks = new ArrayList<DfsPackFile>(packs.length);
        long now = SystemReader.getInstance().getCurrentTime();
        for (DfsPackFile p : packs) {
            DfsPackDescription d = p.getPackDescription();
            if (d.getPackSource() != DfsObjDatabase.PackSource.UNREACHABLE_GARBAGE) {
                this.packsBefore.add(p);
                continue;
            }
            if (this.packIsExpiredGarbage(d, now)) {
                this.expiredGarbagePacks.add(p);
                continue;
            }
            if (!this.packIsCoalesceableGarbage(d, now)) continue;
            this.packsBefore.add(p);
        }
    }

    private void readReftablesBefore() throws IOException {
        DfsReftable[] tables = this.objdb.getReftables();
        this.reftablesBefore = new ArrayList<DfsReftable>(Arrays.asList(tables));
    }

    private boolean packIsExpiredGarbage(DfsPackDescription d, long now) {
        return d.getPackSource() == DfsObjDatabase.PackSource.UNREACHABLE_GARBAGE && this.garbageTtlMillis > 0L && now - d.getLastModified() >= this.garbageTtlMillis;
    }

    private boolean packIsCoalesceableGarbage(DfsPackDescription d, long now) {
        long dayStartToday;
        if (d.getPackSource() != DfsObjDatabase.PackSource.UNREACHABLE_GARBAGE || d.getFileSize(PackExt.PACK) >= this.coalesceGarbageLimit) {
            return false;
        }
        if (this.garbageTtlMillis == 0L) {
            return true;
        }
        long lastModified = d.getLastModified();
        long dayStartLastModified = DfsGarbageCollector.dayStartInMillis(lastModified);
        if (dayStartLastModified != (dayStartToday = DfsGarbageCollector.dayStartInMillis(now))) {
            return false;
        }
        if (this.garbageTtlMillis > TimeUnit.DAYS.toMillis(1L)) {
            return true;
        }
        long timeInterval = this.garbageTtlMillis / 3L;
        if (timeInterval == 0L) {
            return false;
        }
        long modifiedTimeSlot = (lastModified - dayStartLastModified) / timeInterval;
        long presentTimeSlot = (now - dayStartToday) / timeInterval;
        return modifiedTimeSlot == presentTimeSlot;
    }

    private static long dayStartInMillis(long timeInMillis) {
        GregorianCalendar cal = new GregorianCalendar(SystemReader.getInstance().getTimeZone());
        cal.setTimeInMillis(timeInMillis);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public Set<DfsPackDescription> getSourcePacks() {
        return this.toPrune();
    }

    public List<DfsPackDescription> getNewPacks() {
        return this.newPackDesc;
    }

    public List<PackStatistics> getNewPackStatistics() {
        return this.newPackStats;
    }

    private Set<DfsPackDescription> toPrune() {
        HashSet<DfsPackDescription> toPrune = new HashSet<DfsPackDescription>();
        for (DfsPackFile pack : this.packsBefore) {
            toPrune.add(pack.getPackDescription());
        }
        if (this.reftableConfig != null) {
            for (DfsReftable table : this.reftablesBefore) {
                toPrune.add(table.getPackDescription());
            }
        }
        for (DfsPackFile pack : this.expiredGarbagePacks) {
            toPrune.add(pack.getPackDescription());
        }
        return toPrune;
    }

    private void packHeads(ProgressMonitor pm) throws IOException {
        if (this.allHeadsAndTags.isEmpty()) {
            this.writeReftable();
            return;
        }
        try (PackWriter pw = this.newPackWriter();){
            pw.setTagTargets(this.tagTargets);
            pw.preparePack(pm, this.allHeadsAndTags, PackWriter.NONE, PackWriter.NONE, this.allTags);
            if (0L < pw.getObjectCount()) {
                long estSize = this.estimateGcPackSize(DfsObjDatabase.PackSource.INSERT, DfsObjDatabase.PackSource.RECEIVE, DfsObjDatabase.PackSource.COMPACT, DfsObjDatabase.PackSource.GC);
                this.writePack(DfsObjDatabase.PackSource.GC, pw, pm, estSize);
            } else {
                this.writeReftable();
            }
        }
    }

    private void packRest(ProgressMonitor pm) throws IOException {
        if (this.nonHeads.isEmpty()) {
            return;
        }
        try (PackWriter pw = this.newPackWriter();){
            for (ObjectIdSet packedObjs : this.newPackObj) {
                pw.excludeObjects(packedObjs);
            }
            pw.preparePack(pm, this.nonHeads, this.allHeadsAndTags);
            if (0L < pw.getObjectCount()) {
                this.writePack(DfsObjDatabase.PackSource.GC_REST, pw, pm, this.estimateGcPackSize(DfsObjDatabase.PackSource.INSERT, DfsObjDatabase.PackSource.RECEIVE, DfsObjDatabase.PackSource.COMPACT, DfsObjDatabase.PackSource.GC_REST));
            }
        }
    }

    private void packRefTreeGraph(ProgressMonitor pm) throws IOException {
        if (this.txnHeads.isEmpty()) {
            return;
        }
        try (PackWriter pw = this.newPackWriter();){
            for (ObjectIdSet packedObjs : this.newPackObj) {
                pw.excludeObjects(packedObjs);
            }
            pw.preparePack(pm, this.txnHeads, PackWriter.NONE);
            if (0L < pw.getObjectCount()) {
                this.writePack(DfsObjDatabase.PackSource.GC_TXN, pw, pm, 0L);
            }
        }
    }

    private void packGarbage(ProgressMonitor pm) throws IOException {
        PackConfig cfg = new PackConfig(this.packConfig);
        cfg.setReuseDeltas(true);
        cfg.setReuseObjects(true);
        cfg.setDeltaCompress(false);
        cfg.setBuildBitmaps(false);
        try (PackWriter pw = new PackWriter(cfg, (ObjectReader)this.ctx);
             RevWalk pool = new RevWalk(this.ctx);){
            pw.setDeltaBaseAsOffset(true);
            pw.setReuseDeltaCommits(true);
            pm.beginTask(JGitText.get().findingGarbage, this.objectsBefore());
            long estimatedPackSize = 32L;
            for (DfsPackFile oldPack : this.packsBefore) {
                PackIndex oldIdx = oldPack.getPackIndex(this.ctx);
                PackReverseIndex oldRevIdx = oldPack.getReverseIdx(this.ctx);
                long maxOffset = oldPack.getPackDescription().getFileSize(PackExt.PACK) - 20L;
                for (PackIndex.MutableEntry ent : oldIdx) {
                    pm.update(1);
                    ObjectId id = ent.toObjectId();
                    if (pool.lookupOrNull(id) != null || this.anyPackHas(id)) continue;
                    long offset = ent.getOffset();
                    int type2 = oldPack.getObjectType(this.ctx, offset);
                    pw.addObject(pool.lookupAny(id, type2));
                    long objSize = oldRevIdx.findNextOffset(offset, maxOffset) - offset;
                    estimatedPackSize += objSize;
                }
            }
            pm.endTask();
            if (0L < pw.getObjectCount()) {
                this.writePack(DfsObjDatabase.PackSource.UNREACHABLE_GARBAGE, pw, pm, estimatedPackSize);
            }
        }
    }

    private boolean anyPackHas(AnyObjectId id) {
        for (ObjectIdSet packedObjs : this.newPackObj) {
            if (!packedObjs.contains(id)) continue;
            return true;
        }
        return false;
    }

    private static boolean isHead(Ref ref2) {
        return ref2.getName().startsWith("refs/heads/");
    }

    private static boolean isTag(Ref ref2) {
        return ref2.getName().startsWith("refs/tags/");
    }

    private int objectsBefore() {
        int cnt = 0;
        for (DfsPackFile p : this.packsBefore) {
            cnt = (int)((long)cnt + p.getPackDescription().getObjectCount());
        }
        return cnt;
    }

    private PackWriter newPackWriter() {
        PackWriter pw = new PackWriter(this.packConfig, (ObjectReader)this.ctx);
        pw.setDeltaBaseAsOffset(true);
        pw.setReuseDeltaCommits(false);
        return pw;
    }

    private long estimateGcPackSize(DfsObjDatabase.PackSource first, DfsObjDatabase.PackSource ... rest) {
        EnumSet<DfsObjDatabase.PackSource[]> sourceSet = EnumSet.of(first, rest);
        long size2 = 32L;
        for (DfsPackDescription pack : this.getSourcePacks()) {
            if (!sourceSet.contains((Object)pack.getPackSource())) continue;
            size2 += pack.getFileSize(PackExt.PACK) - 32L;
        }
        return size2;
    }

    private DfsPackDescription writePack(DfsObjDatabase.PackSource source2, PackWriter pw, ProgressMonitor pm, long estimatedPackSize) throws IOException {
        CountingOutputStream cnt2;
        DfsPackDescription pack = this.repo.getObjectDatabase().newPack(source2, estimatedPackSize);
        if (source2 == DfsObjDatabase.PackSource.GC && this.reftableConfig != null) {
            this.writeReftable(pack);
        }
        try (DfsOutputStream out = this.objdb.writeFile(pack, PackExt.PACK);){
            pw.writePack(pm, pm, out);
            pack.addFileExt(PackExt.PACK);
            pack.setBlockSize(PackExt.PACK, out.blockSize());
        }
        out = this.objdb.writeFile(pack, PackExt.INDEX);
        var8_7 = null;
        try {
            cnt2 = new CountingOutputStream(out);
            pw.writeIndex(cnt2);
            pack.addFileExt(PackExt.INDEX);
            pack.setFileSize(PackExt.INDEX, cnt2.getCount());
            pack.setBlockSize(PackExt.INDEX, out.blockSize());
            pack.setIndexVersion(pw.getIndexVersion());
        }
        catch (Throwable cnt2) {
            var8_7 = cnt2;
            throw cnt2;
        }
        finally {
            if (out != null) {
                DfsGarbageCollector.$closeResource(var8_7, out);
            }
        }
        if (pw.prepareBitmapIndex(pm)) {
            out = this.objdb.writeFile(pack, PackExt.BITMAP_INDEX);
            var8_7 = null;
            try {
                cnt2 = new CountingOutputStream(out);
                pw.writeBitmapIndex(cnt2);
                pack.addFileExt(PackExt.BITMAP_INDEX);
                pack.setFileSize(PackExt.BITMAP_INDEX, cnt2.getCount());
                pack.setBlockSize(PackExt.BITMAP_INDEX, out.blockSize());
            }
            catch (Throwable throwable) {
                var8_7 = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    DfsGarbageCollector.$closeResource(var8_7, out);
                }
            }
        }
        PackStatistics stats = pw.getStatistics();
        pack.setPackStats(stats);
        pack.setLastModified(this.startTimeMillis);
        this.newPackDesc.add(pack);
        this.newPackStats.add(stats);
        this.newPackObj.add(pw.getObjectSet());
        return pack;
    }

    private void writeReftable() throws IOException {
        if (this.reftableConfig != null) {
            DfsPackDescription pack = this.objdb.newPack(DfsObjDatabase.PackSource.GC);
            this.newPackDesc.add(pack);
            this.newPackStats.add(null);
            this.writeReftable(pack);
        }
    }

    private void writeReftable(DfsPackDescription pack) throws IOException {
        if (this.convertToReftable && !this.hasGcReftable()) {
            this.writeReftable(pack, this.refsBefore);
            return;
        }
        try (ReftableStack stack = ReftableStack.open(this.ctx, this.reftablesBefore);){
            ReftableCompactor compact = new ReftableCompactor();
            compact.addAll(stack.readers());
            compact.setIncludeDeletes(this.includeDeletes);
            this.compactReftable(pack, compact);
        }
    }

    private boolean hasGcReftable() {
        for (DfsReftable table : this.reftablesBefore) {
            if (table.getPackDescription().getPackSource() != DfsObjDatabase.PackSource.GC) continue;
            return true;
        }
        return false;
    }

    private void writeReftable(DfsPackDescription pack, Collection<Ref> refs) throws IOException {
        try (DfsOutputStream out = this.objdb.writeFile(pack, PackExt.REFTABLE);){
            ReftableConfig cfg = DfsPackCompactor.configureReftable(this.reftableConfig, out);
            ReftableWriter writer2 = new ReftableWriter(cfg).setMinUpdateIndex(this.reftableInitialMinUpdateIndex).setMaxUpdateIndex(this.reftableInitialMaxUpdateIndex).begin(out).sortAndWriteRefs(refs).finish();
            pack.addFileExt(PackExt.REFTABLE);
            pack.setReftableStats(writer2.getStats());
        }
    }

    private void compactReftable(DfsPackDescription pack, ReftableCompactor compact) throws IOException {
        try (DfsOutputStream out = this.objdb.writeFile(pack, PackExt.REFTABLE);){
            compact.setConfig(DfsPackCompactor.configureReftable(this.reftableConfig, out));
            compact.compact(out);
            pack.addFileExt(PackExt.REFTABLE);
            pack.setReftableStats(compact.getStats());
        }
    }
}

