/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.RawParseUtils;

public class BlobBasedConfig
extends Config {
    public BlobBasedConfig(Config base2, byte[] blob) throws ConfigInvalidException {
        super(base2);
        String decoded = this.isUtf8(blob) ? RawParseUtils.decode(RawParseUtils.UTF8_CHARSET, blob, 3, blob.length) : RawParseUtils.decode(blob);
        this.fromText(decoded);
    }

    public BlobBasedConfig(Config base2, Repository db, AnyObjectId objectId) throws IOException, ConfigInvalidException {
        this(base2, BlobBasedConfig.read(db, objectId));
    }

    private static byte[] read(Repository db, AnyObjectId blobId) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        try (ObjectReader or2 = db.newObjectReader();){
            byte[] byArray = BlobBasedConfig.read(or2, blobId);
            return byArray;
        }
    }

    private static byte[] read(ObjectReader or2, AnyObjectId blobId) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectLoader loader = or2.open(blobId, 3);
        return loader.getCachedBytes(Integer.MAX_VALUE);
    }

    public BlobBasedConfig(Config base2, Repository db, AnyObjectId treeish, String path2) throws FileNotFoundException, IOException, ConfigInvalidException {
        this(base2, BlobBasedConfig.read(db, treeish, path2));
    }

    private static byte[] read(Repository db, AnyObjectId treeish, String path2) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        try (ObjectReader or2 = db.newObjectReader();){
            TreeWalk tree = TreeWalk.forPath(or2, path2, BlobBasedConfig.asTree(or2, treeish));
            if (tree == null) {
                throw new FileNotFoundException(MessageFormat.format(JGitText.get().entryNotFoundByPath, path2));
            }
            byte[] byArray = BlobBasedConfig.read(or2, (AnyObjectId)tree.getObjectId(0));
            return byArray;
        }
    }

    private static AnyObjectId asTree(ObjectReader or2, AnyObjectId treeish) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (treeish instanceof RevTree) {
            return treeish;
        }
        if (treeish instanceof RevCommit && ((RevCommit)treeish).getTree() != null) {
            return ((RevCommit)treeish).getTree();
        }
        try (RevWalk rw = new RevWalk(or2);){
            ObjectId objectId = rw.parseTree(treeish).getId();
            return objectId;
        }
    }
}

