/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.errors.RemoteRepositoryException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.BaseConnection;
import org.eclipse.jgit.transport.PackTransport;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.PacketLineOut;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UserAgent;
import org.eclipse.jgit.util.io.InterruptTimer;
import org.eclipse.jgit.util.io.TimeoutInputStream;
import org.eclipse.jgit.util.io.TimeoutOutputStream;

abstract class BasePackConnection
extends BaseConnection {
    protected final Repository local;
    protected final URIish uri;
    protected final Transport transport;
    protected TimeoutInputStream timeoutIn;
    protected TimeoutOutputStream timeoutOut;
    private InterruptTimer myTimer;
    protected InputStream in;
    protected OutputStream out;
    protected PacketLineIn pckIn;
    protected PacketLineOut pckOut;
    protected boolean outNeedsEnd;
    protected boolean statelessRPC;
    private final Set<String> remoteCapablities = new HashSet<String>();
    protected final Set<ObjectId> additionalHaves = new HashSet<ObjectId>();

    BasePackConnection(PackTransport packTransport) {
        this.transport = (Transport)((Object)packTransport);
        this.local = this.transport.local;
        this.uri = this.transport.uri;
    }

    protected final void init(InputStream myIn, OutputStream myOut) {
        int timeout = this.transport.getTimeout();
        if (timeout > 0) {
            Thread caller = Thread.currentThread();
            if (this.myTimer == null) {
                this.myTimer = new InterruptTimer(caller.getName() + "-Timer");
            }
            this.timeoutIn = new TimeoutInputStream(myIn, this.myTimer);
            this.timeoutOut = new TimeoutOutputStream(myOut, this.myTimer);
            this.timeoutIn.setTimeout(timeout * 1000);
            this.timeoutOut.setTimeout(timeout * 1000);
            myIn = this.timeoutIn;
            myOut = this.timeoutOut;
        }
        this.in = myIn;
        this.out = myOut;
        this.pckIn = new PacketLineIn(this.in);
        this.pckOut = new PacketLineOut(this.out);
        this.outNeedsEnd = true;
    }

    protected void readAdvertisedRefs() throws TransportException {
        try {
            this.readAdvertisedRefsImpl();
        }
        catch (TransportException err) {
            this.close();
            throw err;
        }
        catch (IOException err) {
            this.close();
            throw new TransportException(err.getMessage(), err);
        }
        catch (RuntimeException err) {
            this.close();
            throw new TransportException(err.getMessage(), err);
        }
    }

    private void readAdvertisedRefsImpl() throws IOException {
        LinkedHashMap<String, Ref> avail;
        block11: {
            String name2;
            avail = new LinkedHashMap<String, Ref>();
            while (true) {
                int nul;
                String line2;
                try {
                    line2 = this.pckIn.readString();
                }
                catch (EOFException eof) {
                    if (avail.isEmpty()) {
                        throw this.noRepository();
                    }
                    throw eof;
                }
                if (line2 == PacketLineIn.END) break block11;
                if (line2.startsWith("ERR ")) {
                    throw new RemoteRepositoryException(this.uri, line2.substring(4));
                }
                if (avail.isEmpty() && (nul = line2.indexOf(0)) >= 0) {
                    for (String c : line2.substring(nul + 1).split(" ")) {
                        this.remoteCapablities.add(c);
                    }
                    line2 = line2.substring(0, nul);
                }
                name2 = line2.substring(41, line2.length());
                if (avail.isEmpty() && name2.equals("capabilities^{}")) continue;
                ObjectId id = ObjectId.fromString(line2.substring(0, 40));
                if (name2.equals(".have")) {
                    this.additionalHaves.add(id);
                    continue;
                }
                if (name2.endsWith("^{}")) {
                    Ref prior = avail.get(name2 = name2.substring(0, name2.length() - 3));
                    if (prior == null) {
                        throw new PackProtocolException(this.uri, MessageFormat.format(JGitText.get().advertisementCameBefore, name2, name2));
                    }
                    if (prior.getPeeledObjectId() != null) {
                        throw this.duplicateAdvertisement(name2 + "^{}");
                    }
                    avail.put(name2, new ObjectIdRef.PeeledTag(Ref.Storage.NETWORK, name2, prior.getObjectId(), id));
                    continue;
                }
                Ref prior = avail.put(name2, new ObjectIdRef.PeeledNonTag(Ref.Storage.NETWORK, name2, id));
                if (prior != null) break;
            }
            throw this.duplicateAdvertisement(name2);
        }
        this.available(avail);
    }

    protected TransportException noRepository() {
        return new NoRemoteRepositoryException(this.uri, JGitText.get().notFound);
    }

    protected boolean isCapableOf(String option) {
        return this.remoteCapablities.contains(option);
    }

    protected boolean wantCapability(StringBuilder b, String option) {
        if (!this.isCapableOf(option)) {
            return false;
        }
        b.append(' ');
        b.append(option);
        return true;
    }

    protected void addUserAgentCapability(StringBuilder b) {
        String a = UserAgent.get();
        if (a != null && UserAgent.hasAgent(this.remoteCapablities)) {
            b.append(' ').append("agent").append('=').append(a);
        }
    }

    @Override
    public String getPeerUserAgent() {
        return UserAgent.getAgent(this.remoteCapablities, super.getPeerUserAgent());
    }

    private PackProtocolException duplicateAdvertisement(String name2) {
        return new PackProtocolException(this.uri, MessageFormat.format(JGitText.get().duplicateAdvertisementsOf, name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.out != null) {
            try {
                if (this.outNeedsEnd) {
                    this.outNeedsEnd = false;
                    this.pckOut.end();
                }
                this.out.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.out = null;
                this.pckOut = null;
            }
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.in = null;
                this.pckIn = null;
            }
        }
        if (this.myTimer != null) {
            try {
                this.myTimer.terminate();
            }
            finally {
                this.myTimer = null;
                this.timeoutIn = null;
                this.timeoutOut = null;
            }
        }
    }

    protected void endOut() {
        if (this.outNeedsEnd && this.out != null) {
            try {
                this.outNeedsEnd = false;
                this.pckOut.end();
            }
            catch (IOException e2) {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    this.out = null;
                    this.pckOut = null;
                }
            }
        }
    }
}

