/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.errors.MissingBundlePrerequisiteException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackLock;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.BaseFetchConnection;
import org.eclipse.jgit.transport.PackParser;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

class BundleFetchConnection
extends BaseFetchConnection {
    private final Transport transport;
    InputStream bin;
    final Map<ObjectId, String> prereqs = new HashMap<ObjectId, String>();
    private String lockMessage;
    private PackLock packLock;

    BundleFetchConnection(Transport transportBundle, InputStream src) throws TransportException {
        this.transport = transportBundle;
        this.bin = new BufferedInputStream(src);
        try {
            switch (this.readSignature()) {
                case 2: {
                    this.readBundleV2();
                    break;
                }
                default: {
                    throw new TransportException(this.transport.uri, JGitText.get().notABundle);
                }
            }
        }
        catch (TransportException err) {
            this.close();
            throw err;
        }
        catch (IOException err) {
            this.close();
            throw new TransportException(this.transport.uri, err.getMessage(), err);
        }
        catch (RuntimeException err) {
            this.close();
            throw new TransportException(this.transport.uri, err.getMessage(), err);
        }
    }

    private int readSignature() throws IOException {
        String rev = this.readLine(new byte[1024]);
        if ("# v2 git bundle".equals(rev)) {
            return 2;
        }
        throw new TransportException(this.transport.uri, JGitText.get().notABundle);
    }

    private void readBundleV2() throws IOException {
        String line2;
        byte[] hdrbuf = new byte[1024];
        LinkedHashMap<String, Ref> avail = new LinkedHashMap<String, Ref>();
        while ((line2 = this.readLine(hdrbuf)).length() != 0) {
            ObjectId id;
            if (line2.charAt(0) == '-') {
                ObjectId id2 = ObjectId.fromString(line2.substring(1, 41));
                String shortDesc = null;
                if (line2.length() > 42) {
                    shortDesc = line2.substring(42);
                }
                this.prereqs.put(id2, shortDesc);
                continue;
            }
            String name2 = line2.substring(41, line2.length());
            Ref prior = avail.put(name2, new ObjectIdRef.Unpeeled(Ref.Storage.NETWORK, name2, id = ObjectId.fromString(line2.substring(0, 40))));
            if (prior == null) continue;
            throw this.duplicateAdvertisement(name2);
        }
        this.available(avail);
    }

    private PackProtocolException duplicateAdvertisement(String name2) {
        return new PackProtocolException(this.transport.uri, MessageFormat.format(JGitText.get().duplicateAdvertisementsOf, name2));
    }

    private String readLine(byte[] hdrbuf) throws IOException {
        StringBuilder line2 = new StringBuilder();
        boolean done = false;
        while (!done) {
            int lf;
            this.bin.mark(hdrbuf.length);
            int cnt = this.bin.read(hdrbuf);
            for (lf = 0; lf < cnt && hdrbuf[lf] != 10; ++lf) {
            }
            this.bin.reset();
            IO.skipFully(this.bin, lf);
            if (lf < cnt && hdrbuf[lf] == 10) {
                IO.skipFully(this.bin, 1L);
                done = true;
            }
            line2.append(RawParseUtils.decode(Constants.CHARSET, hdrbuf, 0, lf));
        }
        return line2.toString();
    }

    @Override
    public boolean didFetchTestConnectivity() {
        return false;
    }

    @Override
    protected void doFetch(ProgressMonitor monitor, Collection<Ref> want, Set<ObjectId> have) throws TransportException {
        this.verifyPrerequisites();
        try (ObjectInserter ins = this.transport.local.newObjectInserter();){
            PackParser parser = ins.newPackParser(this.bin);
            parser.setAllowThin(true);
            parser.setObjectChecker(this.transport.getObjectChecker());
            parser.setLockMessage(this.lockMessage);
            this.packLock = parser.parse(NullProgressMonitor.INSTANCE);
            ins.flush();
        }
        catch (IOException err) {
            this.close();
            throw new TransportException(this.transport.uri, err.getMessage(), err);
        }
        catch (RuntimeException err) {
            this.close();
            throw new TransportException(this.transport.uri, err.getMessage(), err);
        }
    }

    @Override
    public void setPackLockMessage(String message) {
        this.lockMessage = message;
    }

    @Override
    public Collection<PackLock> getPackLocks() {
        if (this.packLock != null) {
            return Collections.singleton(this.packLock);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private void verifyPrerequisites() throws TransportException {
        if (this.prereqs.isEmpty()) {
            return;
        }
        try (RevWalk rw = new RevWalk(this.transport.local);){
            void var8_13;
            Map<String, Ref> localRefs;
            RevFlag PREREQ = rw.newFlag("PREREQ");
            RevFlag SEEN = rw.newFlag("SEEN");
            HashMap<ObjectId, String> missing = new HashMap<ObjectId, String>();
            ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
            for (Map.Entry<ObjectId, String> entry : this.prereqs.entrySet()) {
                ObjectId p = entry.getKey();
                try {
                    RevCommit revCommit = rw.parseCommit(p);
                    if (revCommit.has(PREREQ)) continue;
                    revCommit.add(PREREQ);
                    commits.add(revCommit);
                }
                catch (MissingObjectException missingObjectException) {
                    missing.put(p, entry.getValue());
                }
                catch (IOException iOException) {
                    throw new TransportException(this.transport.uri, MessageFormat.format(JGitText.get().cannotReadCommit, p.name()), iOException);
                }
            }
            if (!missing.isEmpty()) {
                throw new MissingBundlePrerequisiteException(this.transport.uri, missing);
            }
            try {
                localRefs = this.transport.local.getRefDatabase().getRefs("");
            }
            catch (IOException iOException) {
                throw new TransportException(this.transport.uri, iOException.getMessage(), iOException);
            }
            for (Ref r : localRefs.values()) {
                try {
                    rw.markStart(rw.parseCommit(r.getObjectId()));
                }
                catch (IOException iOException) {}
            }
            int n = commits.size();
            try {
                RevCommit c;
                while ((c = rw.next()) != null) {
                    if (!c.has(PREREQ)) continue;
                    c.add(SEEN);
                    if (--var8_13 != false) continue;
                    break;
                }
            }
            catch (IOException err) {
                throw new TransportException(this.transport.uri, JGitText.get().cannotReadObject, err);
            }
            if (var8_13 > 0) {
                for (RevObject revObject : commits) {
                    if (revObject.has(SEEN)) continue;
                    missing.put(revObject, this.prereqs.get(revObject));
                }
                throw new MissingBundlePrerequisiteException(this.transport.uri, missing);
            }
        }
    }

    @Override
    public void close() {
        if (this.bin != null) {
            try {
                this.bin.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.bin = null;
            }
        }
    }
}

