/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefComparator;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.PacketLineOut;
import org.eclipse.jgit.util.RefMap;

public abstract class RefAdvertiser {
    private final StringBuilder tmpLine = new StringBuilder(100);
    private final char[] tmpId = new char[40];
    final Set<String> capablities = new LinkedHashSet<String>();
    private final Set<ObjectId> sent = new HashSet<ObjectId>();
    private Repository repository;
    private boolean derefTags;
    boolean first = true;

    public void init(Repository src) {
        this.repository = src;
    }

    public void setDerefTags(boolean deref2) {
        this.derefTags = deref2;
    }

    public void advertiseCapability(String name2) {
        this.capablities.add(name2);
    }

    public void advertiseCapability(String name2, String value) {
        if (value != null) {
            this.capablities.add(name2 + '=' + value);
        }
    }

    public void addSymref(String from, String to) {
        this.advertiseCapability("symref", from + ':' + to);
    }

    public Set<ObjectId> send(Map<String, Ref> refs) throws IOException {
        for (Ref ref2 : this.getSortedRefs(refs)) {
            if (ref2.getObjectId() == null) continue;
            this.advertiseAny(ref2.getObjectId(), ref2.getName());
            if (!this.derefTags) continue;
            if (!ref2.isPeeled()) {
                if (this.repository == null) continue;
                ref2 = this.repository.peel(ref2);
            }
            if (ref2.getPeeledObjectId() == null) continue;
            this.advertiseAny(ref2.getPeeledObjectId(), ref2.getName() + "^{}");
        }
        return this.sent;
    }

    private Iterable<Ref> getSortedRefs(Map<String, Ref> all) {
        if (all instanceof RefMap || all instanceof SortedMap && ((SortedMap)all).comparator() == null) {
            return all.values();
        }
        return RefComparator.sort(all.values());
    }

    public void advertiseHave(AnyObjectId id) throws IOException {
        this.advertiseAnyOnce(id, ".have");
    }

    public boolean isEmpty() {
        return this.first;
    }

    private void advertiseAnyOnce(AnyObjectId obj, String refName) throws IOException {
        if (!this.sent.contains(obj)) {
            this.advertiseAny(obj, refName);
        }
    }

    private void advertiseAny(AnyObjectId obj, String refName) throws IOException {
        this.sent.add(obj.toObjectId());
        this.advertiseId(obj, refName);
    }

    public void advertiseId(AnyObjectId id, String refName) throws IOException {
        this.tmpLine.setLength(0);
        id.copyTo(this.tmpId, this.tmpLine);
        this.tmpLine.append(' ');
        this.tmpLine.append(refName);
        if (this.first) {
            this.first = false;
            if (!this.capablities.isEmpty()) {
                this.tmpLine.append('\u0000');
                for (String capName : this.capablities) {
                    this.tmpLine.append(' ');
                    this.tmpLine.append(capName);
                }
                this.tmpLine.append(' ');
            }
        }
        this.tmpLine.append('\n');
        this.writeOne(this.tmpLine);
    }

    protected abstract void writeOne(CharSequence var1) throws IOException;

    protected abstract void end() throws IOException;

    public static class PacketLineOutRefAdvertiser
    extends RefAdvertiser {
        private final CharsetEncoder utf8 = StandardCharsets.UTF_8.newEncoder();
        private final PacketLineOut pckOut;
        private byte[] binArr = new byte[256];
        private ByteBuffer binBuf = ByteBuffer.wrap(this.binArr);
        private char[] chArr = new char[256];
        private CharBuffer chBuf = CharBuffer.wrap(this.chArr);

        public PacketLineOutRefAdvertiser(PacketLineOut out) {
            this.pckOut = out;
        }

        @Override
        public void advertiseId(AnyObjectId id, String refName) throws IOException {
            id.copyTo(this.binArr, 0);
            this.binArr[40] = 32;
            this.binBuf.position(41);
            this.append(refName);
            if (this.first) {
                this.first = false;
                if (!this.capablities.isEmpty()) {
                    this.append(0);
                    for (String cap : this.capablities) {
                        this.append(32);
                        this.append(cap);
                    }
                }
            }
            this.append(10);
            this.pckOut.writePacket(this.binArr, 0, this.binBuf.position());
        }

        private void append(String str2) throws CharacterCodingException {
            int n = str2.length();
            if (n > this.chArr.length) {
                this.chArr = new char[n + 256];
                this.chBuf = CharBuffer.wrap(this.chArr);
            }
            str2.getChars(0, n, this.chArr, 0);
            this.chBuf.position(0).limit(n);
            this.utf8.reset();
            while (true) {
                CoderResult cr;
                if ((cr = this.utf8.encode(this.chBuf, this.binBuf, true)).isOverflow()) {
                    this.grow();
                    continue;
                }
                if (cr.isUnderflow()) break;
                cr.throwException();
            }
        }

        private void append(int b) {
            if (!this.binBuf.hasRemaining()) {
                this.grow();
            }
            this.binBuf.put((byte)b);
        }

        private void grow() {
            int cnt = this.binBuf.position();
            byte[] tmp = new byte[this.binArr.length << 1];
            System.arraycopy(this.binArr, 0, tmp, 0, cnt);
            this.binArr = tmp;
            this.binBuf = ByteBuffer.wrap(this.binArr);
            this.binBuf.position(cnt);
        }

        @Override
        protected void writeOne(CharSequence line2) throws IOException {
            this.pckOut.writeString(line2.toString());
        }

        @Override
        protected void end() throws IOException {
            this.pckOut.end();
        }
    }
}

