/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.binder.ScopedBindingBuilder;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.sisu.inject.DeferredClass;
import org.eclipse.sisu.inject.Sources;
import org.eclipse.sisu.plexus.PlexusTypeListener;
import org.eclipse.sisu.plexus.Roles;
import org.eclipse.sisu.space.QualifiedTypeBinder;
import org.eclipse.sisu.space.QualifiedTypeListener;

public final class PlexusTypeBinder
implements PlexusTypeListener {
    private final Binder binder;
    private final QualifiedTypeListener qualifiedTypeBinder;

    public PlexusTypeBinder(Binder binder) {
        this.binder = binder;
        this.qualifiedTypeBinder = new QualifiedTypeBinder(binder);
    }

    @Override
    public void hear(Class<?> qualifiedType, Object source2) {
        this.qualifiedTypeBinder.hear(qualifiedType, source2);
    }

    @Override
    public void hear(Component component2, DeferredClass<?> clazz, Object source2) {
        Key<?> roleKey = Roles.componentKey(component2);
        String strategy = component2.instantiationStrategy();
        Class<?> role = component2.role();
        Binder componentBinder = this.componentBinder(source2, component2.description());
        ScopedBindingBuilder sbb = role.getName().equals(clazz.getName()) ? (roleKey.getAnnotation() != null ? componentBinder.bind(roleKey).to(role) : componentBinder.bind(roleKey)) : ("load-on-start".equals(strategy) ? componentBinder.bind(roleKey).to(clazz.load()) : componentBinder.bind(roleKey).toProvider((Provider<?>)clazz.asProvider()));
        if ("load-on-start".equals(strategy)) {
            sbb.asEagerSingleton();
        } else if (!"per-lookup".equals(strategy)) {
            sbb.in(Scopes.SINGLETON);
        }
    }

    private Binder componentBinder(Object source2, String description) {
        if (description != null && description.length() > 0) {
            return this.binder.withSource(Sources.describe(source2, description));
        }
        return this.binder.withSource(source2);
    }
}

