(ns ^:no-doc polylith.clj.core.nav-generator.main
  (:require [clojure.string :as str]
            [polylith.clj.core.nav-generator.help-generator :as help-gen]
            [polylith.clj.core.nav-generator.pages-generator :as pages-gen]
            [polylith.clj.core.nav-generator.ws-generator :as ws-gen]))

(defn indent [data]
  (str (str/join "\n" (mapv #(str "  " %)
                            (str/split (str data) #",")))
       ")"))

(def filename "components/doc/src/polylith/clj/core/doc/navigation/generated.clj")

(defn save-file [def-name data]
  (spit filename "\n\n" :append true)
  (spit filename (str "(def " def-name "\n") :append true)
  (spit filename (indent data) :append true))

(defn -main [& _]
  (spit filename (str "(ns ^:no-doc polylith.clj.core.doc.navigation.generated)\n\n"
                      ";; This file is generated by the nav-generator base."))
  (save-file "help-nav" (help-gen/navigation))
  (save-file "ci-pages" (pages-gen/ci-pages))
  (save-file "pages-nav" (pages-gen/navigation))
  (save-file "ws-nav" (ws-gen/navigation))
  (spit filename "\n" :append true))

(comment
  (-main)
  #__)
