(ns leiningen.polylith.help)

(defn help []
  (println "Polylith 0.0.26-alpha (2017-12-04) - by Joakim Tengstrand")
  (println "  https://github.com/tengstrand/polylith")
  (println)
  (println "  lein polylith cmd [args]  - where cmd [args] are:")
  (println)
  (println "    changes x s1 s2        List changed components, systems or builds")
  (println "                           between two Git sha1:s")
  (println "    compile s1 s2          List components and systems to AOT compile")
  (println "    deps                   List all dependencies")
  (println "    diff s1 s2             List all changes between two Git sha1:s")
  (println "    info [x] [s1 s2]       list apis, components, systems and builds")
  (println "    settings               The polylith settings in current project.clj")
  (println "    tests x [s1 s2]        Show or run tests")
  (println)
  (println "  lein polylith [help]     Show this help")
  (println "  lein polylith help cmd   Show help for a specific command")
  (println)
  (println "  Examples:")
  (println "    lein polylith changes s 2c851f3c6e7a5114cecf6bdd6e1c8c8aec8b32c1 58cd8b3106c942f372a40616fe9155c9d2efd122")
  (println "    lein polylith compile 2c851f3c6e7a5114cecf6bdd6e1c8c8aec8b32c1 58cd8b3106c942f372a40616fe9155c9d2efd122")
  (println "    lein polylith diff 2c851f3c6e7a5114cecf6bdd6e1c8c8aec8b32c1 58cd8b3106c942f372a40616fe9155c9d2efd122")
  (println "    lein polylith help info")
  (println "    lein polylith info")
  (println "    lein polylith info a")
  (println "    lein polylith info 2c851f3c6e7a5114cecf6bdd6e1c8c8aec8b32c1 58cd8b3106c942f372a40616fe9155c9d2efd122")
  (println "    lein polylith info a 2c851f3c6e7a5114cecf6bdd6e1c8c8aec8b32c1 58cd8b3106c942f372a40616fe9155c9d2efd122")
  (println "    lein polylith info c 2c851f3c6e7a5114cecf6bdd6e1c8c8aec8b32c1 58cd8b3106c942f372a40616fe9155c9d2efd122")
  (println "    lein polylith tests u")
  (println "    lein polylith tests ui+ 2c851f3c6e7a5114cecf6bdd6e1c8c8aec8b32c1 58cd8b3106c942f372a40616fe9155c9d2efd122"))

(defn changes []
  (println "  lein polylith changes x s1 s2")
  (println "    x = a -> show changed apis")
  (println "        b -> show changed builds")
  (println "        s -> show changed systems")
  (println "        c -> show changed components")
  (println "    s1 = last successful Git sha1")
  (println "    s2 = current Git sha1")
  (println)
  (println "  example:")
  (println "    lein polylith changes s 2c851f3c6e7a5114cecf6bdd6e1c8c8aec8b32c1 58cd8b3106c942f372a40616fe9155c9d2efd122"))

(defn compile-components-and-systems []
  (println "  Prints a script with commands that AOT compiles")
  (println "  the APIs + changed components and systems")
  (println)
  (println "  lein polylith compile s1 s2")
  (println "    s1 = last successful Git sha1")
  (println "    s2 = current Git sha1")
  (println)
  (println "  example:")
  (println "    lein polylith compile 2c851f3c6e7a5114cecf6bdd6e1c8c8aec8b32c1 58cd8b3106c942f372a40616fe9155c9d2efd122"))

(defn deps []
  (println "  WRITE SOME HELP HERE!"))

(defn diff []
  (println "  lein polylith diff s1 s2")
  (println "    s1 = last successful Git sha1")
  (println "    s2 = current Git sha1")
  (println)
  (println "  example:")
  (println "    lein polylith diff 2c851f3c6e7a5114cecf6bdd6e1c8c8aec8b32c1 58cd8b3106c942f372a40616fe9155c9d2efd122"))

(defn info []
  (println "  lein polylith info [x] [s1 s2]")
  (println "    x = a -> show all apis, components, systems and builds")
  (println "        c -> show changed apis, components, systems and builds")
  (println "        u -> show unchanged apis, components, systems and builds")
  (println "        (omitted) -> show all components, systems, builds")
  (println "                     (and apis if changed)")
  (println "    s1 = last successful Git sha1")
  (println "    s2 = current Git sha1")
  (println)
  (println "  example:")
  (println "    lein polylith info")
  (println "    lein polylith info a")
  (println "    lein polylith info 2c851f3c6e7a5114cecf6bdd6e1c8c8aec8b32c1 58cd8b3106c942f372a40616fe9155c9d2efd122")
  (println "    lein polylith info a 2c851f3c6e7a5114cecf6bdd6e1c8c8aec8b32c1 58cd8b3106c942f372a40616fe9155c9d2efd122")
  (println "    lein polylith info c 2c851f3c6e7a5114cecf6bdd6e1c8c8aec8b32c1 58cd8b3106c942f372a40616fe9155c9d2efd122"))

(defn settings []
  (println "  WRITE SOME HELP HERE!"))

(defn tests []
  (println "  lein polylith tests x [s1 s2]")
  (println "    x: different combinations of u,i,+,-:")
  (println "        u = unit tests")
  (println "        i = integration tests")
  (println "        + = execute tests")
  (println "        - = show test statement")
  (println "    combinations:")
  (println "        u = list unit tests")
  (println "        i = list integration tests")
  (println "        ui = list unit + integration tests")
  (println "        u- = show test statement (u tests)")
  (println "        i- = show test statement (i tests)")
  (println "        ui- = show test statement (u+i tests)")
  (println "        u+ = execute unit tests")
  (println "        i+ = execute integration tests")
  (println "        ui+ = execute unit + integration tests")
  (println "        ui+- = execute unit + integration tests + show test statement")
  (println)
  (println "    s1 = last successful Git sha1")
  (println "    s2 = current Git sha1")
  (println)
  (println "    -----------------------------------------------------------")
  (println)
  (println "    if s1 and s2 are given:")
  (println "      include tests from changed components and systems")
  (println "    if s1 and s2 are omitted:")
  (println "      include tests from all components and systems")
  (println)
  (println "    Component and system tests can be ignored in project.clj:")
  (println "      (defproject ....")
  (println "        ...")
  (println "        :polylith {:ignore-tests [...]}}")
  (println "        ...")
  (println "      )")
  (println "    where [...] is e.g.:")
  (println "      [\"comp*\"] = ignore all 'comp' tests including all underlying namespaces")
  (println "      [\"comp.x*\"] = ignore all 'comp.x' tests including all underlying namespaces")
  (println "      [\"comp.x\" \"sys.y\"] = ignore all 'comp.x' and 'sys.y' tests")
  (println)
  (println "  examples:")
  (println "    lein polylith tests u")
  (println "    lein polylith tests ui+ 2c851f3c6e7a5114cecf6bdd6e1c8c8aec8b32c1 58cd8b3106c942f372a40616fe9155c9d2efd122"))
