(ns leiningen.polylith.cmd.help.changes)

(defn help []
  (println "  Show what has been changed since a specific point in time.")
  (println)
  (println "  lein polylith changes ENTITY [ARG]")
  (println "    ENTITY = i[nterface] -> Show changed interfaces")
  (println "             c[omponent] -> Show changed components")
  (println "             b[ase]      -> Show changed bases")
  (println "             s[ystem]    -> Show changed systems")
  (println "    ARG = (omitted) -> Since last successful build, stored in bookmark")
  (println "                       :last-successful-build in WS-ROOT/time.edn.")
  (println "          timestamp -> Since the given timestamp (milliseconds since 1970).")
  (println "          bookmark  -> Since the timestamp for the given bookmark in WS-ROOT/time.edn.")
  (println)
  (println "  example:")
  (println "    lein polylith changes i")
  (println "    lein polylith changes c")
  (println "    lein polylith changes component")
  (println "    lein polylith changes b")
  (println "    lein polylith changes s 1523649477000")
  (println "    lein polylith changes s mybookmark"))
