(ns leiningen.polylith.cmd.help.create)

(defn help []
  (println "  Create a component:")
  (println)
  (println "  lein polylith create c[omponent] NAME [INTERFACE]")
  (println "    NAME = Component name")
  (println "    INTERFACE = Interface name")
  (println "  --------------------------------------------------------")
  (println "  Create a system:")
  (println)
  (println "  lein polylith create s[ystem] NAME [BASE]")
  (println "    NAME = System name")
  (println "    BASE = Base name")
  (println "  --------------------------------------------------------")
  (println "  Create a workspace:")
  (println)
  (println "  lein polylith create w[orkspace] WS NS [TOP-NS]")
  (println "    WS = Workspace name")
  (println "    NS = Namespace name")
  (println "    TOP-NS = If left out, it will be sett to the ")
  (println "             corresponding value of the NS e.g. ")
  (println "             'com/my/company' if NS is 'com.my.company'.")
  (println "             Set to blank if package name only exists in")
  (println "             the system project.clj file but not as a ")
  (println "             package structure under src, e.g.:")
  (println "               (defproject com.my.comp/development \"1.0\"")
  (println "                  ...)")
  (println "  --------------------------------------------------------")
  (println "  example:")
  (println "    lein polylith create c mycomponent")
  (println "    lein polylith create c mycomponent myinterface")
  (println "    lein polylith create component mycomponent")
  (println "    lein polylith create component mycomponent myinterface")
  (println "    lein polylith create s mysystem")
  (println "    lein polylith create s mysystem mybase")
  (println "    lein polylith create system mysystem")
  (println "    lein polylith create system mysystem mybase")
  (println "    lein polylith create w myworkspace com.my.company")
  (println "    lein polylith create w myworkspace com.my.company \"\"")
  (println "    lein polylith create workspace myworkspace com.my.company")
  (println "    lein polylith create workspace myworkspace \"\""))
