(ns leiningen.polylith.cmd.help.info)

(defn help []
  (println "  Show the content of a Polylith workspace and its changes since")
  (println "  THE last successful build or a given point in time")
  (println "  (each row is followed by an * if something has changed).")
  (println)
  (println "  lein polylith info PREFIX [ARG]")
  (println "    PREFIX = (omitted) -> Uses time.local.edn")
  (println "             prefix    -> Uses given prefix as time.PREFIX.edn.")
  (println)
  (println "    ARG = (omitted) -> Since last successful build, stored in bookmark")
  (println "                       :last-successful-build in WS-ROOT/.polylith/time.local.edn.")
  (println "          timestamp -> Since the given timestamp (milliseconds since 1970).")
  (println "          bookmark  -> Since the timestamp for the given bookmark in WS-ROOT/.polylith/time.local.edn.")
  (println)
  (println "  example:")
  (println "    lein polylith info")
  (println "    lein polylith info local")
  (println "    lein polylith info remote")
  (println "    lein polylith info local 1523649477000")
  (println "    lein polylith info local mybookmark"))
