(ns leiningen.polylith.cmd.help.test)

(defn help []
  (println "  Execute tests.")
  (println)
  (println "  lein polylith test PREFIX [ARG] [SKIP]")
  (println "    PREFIX = (omitted) -> Uses time.local.edn")
  (println "             prefix    -> Uses given prefix as time.PREFIX.edn.")
  (println)
  (println "    ARG = (omitted) -> Since last successful build, stored in bookmark")
  (println "                       :last-successful-build in WS-ROOT/.polylith/time.local.edn.")
  (println "          timestamp -> Since the given timestamp (milliseconds since 1970).")
  (println "          bookmark  -> Since the timestamp for the given bookmark in WS-ROOT/.polylith/time.local.edn.")
  (println)
  (println "    SKIP = (omitted) -> Compiles and tests")
  (println "           -compile -> Skips compilation step")
  (println)
  (println "  examples:")
  (println "    lein polylith test")
  (println "    lein polylith test -compile")
  (println "    lein polylith test local")
  (println "    lein polylith test remote")
  (println "    lein polylith test local 1523649477000")
  (println "    lein polylith test local mybookmark")
  (println "    lein polylith test local mybookmark -compile"))
