(ns leiningen.polylith.cmd.help.deps)

(defn help []
  (println "  List dependencies.")
  (println)
  (println "  lein polylith deps [ARG]")
  (println "    ARG = (omitted)   -> list component dependencies")
  (println "          c[omponent] -> list component dependencies")
  (println "          f[unction]  -> list function dependencies")
  (println)
  (println "  To work correctly, :require with a corresponding :as alias")
  (println "  must be used to specify dependencies in each namespace, e.g.:")
  (println "    (ns my.namespace.core")
  (println "      (:require [my.namespace.user.interface :as user]")
  (println "                [my.namespace.email.interface :as email]))")
  (println)
  (println "  example:")
  (println "    lein polylith deps")
  (println "    lein polylith deps c")
  (println "    lein polylith deps component")
  (println "    lein polylith deps f")
  (println "    lein polylith deps function"))
