(ns leiningen.polylith.cmd.help.changes
  (:require [leiningen.polylith.cmd.shared :as shared]))

(defn help []
  (println "  Shows what has been changed since a specific point in time.")
  (println)
  (println "  lein polylith changes ENTITY [ARG]")
  (println "    ENTITY = i[nterface] -> Shows changed interfaces")
  (println "             c[omponent] -> Shows changed components")
  (println "             b[ase]      -> Shows changed bases")
  (println "             s[ystem]    -> Shows changed systems")
  (println)
  (println "    ARG = (omitted) -> Since last successful test or build, stored in bookmark")
  (println "                       :last-success in WS-ROOT/.polylith/time.edn. or")
  (println "                       :last-success in WS-ROOT/.polylith/git.edn if")
  (println "                       you have the CI variable set to something on the machine.")
  (println "          timestamp -> Since the given timestamp (milliseconds since 1970).")
  (println "          git-hash  -> Since the given git hash if the CI variable is set.")
  (println "          bookmark  -> Since the timestamp for the given bookmark in")
  (println "                       WS-ROOT/.polylith/time.edn or since the git hash")
  (println "                       for the given bookmark in WS-ROOT/.polylith/git.edn")
  (println "                       if the CI variable is set.")
  (println)
  (println "  'lein polylith changes 0' can be used to build all files in the workspace")
  (println "  (or at least changes since 1970-01-01).")
  (println)
  (println "  example:")
  (println "    lein polylith changes i")
  (println "    lein polylith changes c")
  (println "    lein polylith changes component")
  (println "    lein polylith changes b")
  (if (shared/ci?)
    (println "    lein polylith changes s 7d7fd132412aad0f8d3019edfccd1e9d92a5a8ae")
    (println "    lein polylith changes s 1523649477000"))
  (println "    lein polylith changes s mybookmark"))
