(ns leiningen.polylith.cmd.help.deps)

(defn help []
  (println "  Lists dependencies used in at least one environment or system.")
  (println)
  (println "  lein polylith deps [NAME] [FLAG]")
  (println "    NAME = (omitted) -> Lists all dependencies.")
  (println "           else      -> Filters dependencies by given system, environment")
  (println "                        base or component name.")
  (println "    FLAG = (omitted)    -> Lists interface dependencies.")
  (println "           +c[omponent] -> Lists component dependencies.")
  (println "           +f[unction]  -> Lists function dependencies.")
  (println)
  (println "  To work correctly, :require with a corresponding :as alias")
  (println "  must be used to specify dependencies in each namespace, e.g.:")
  (println "    (ns my.namespace.core")
  (println "      (:require [my.namespace.user.interface :as user]")
  (println "                [my.namespace.email.interface :as email]))")
  (println)
  (println "  example:")
  (println "    lein polylith deps")
  (println "    lein polylith deps +c")
  (println "    lein polylith deps +component")
  (println "    lein polylith deps +f")
  (println "    lein polylith deps +function")
  (println "    lein polylith deps development")
  (println "    lein polylith deps mycomponent +f")
  (println "    lein polylith deps myenvironment +c"))
