(ns leiningen.polylith.cmd.help.diff
  (:require [leiningen.polylith.cmd.shared :as shared]))

(defn help []
  (println "  Lists all files and directories that have changed in the workspace")
  (println "  since a specific point in time. Deleted files and directories")
  (println "  are not detected locally (when the CI environment variable is not set).")
  (println)
  (println "  lein polylith diff [ARG] [FLAG]")
  (println "    ARG = (omitted) -> Since last successful test or build, stored in bookmark")
  (println "                       :last-success in WS-ROOT/.polylith/time.edn")
  (println "                       or :last-success in WS-ROOT/.polylith/git.edn")
  (println "                       if you have the CI variable set to something on the machine.")
  (println "          timestamp -> Since the given timestamp (milliseconds since 1970).")
  (println "          git-hash  -> Since the given git hash if the CI variable is set.")
  (println "          bookmark  -> Since the timestamp for the given bookmark in")
  (println "                       WS-ROOT/.polylith/time.edn or since the git hash")
  (println "                       for the given bookmark in WS-ROOT/.polylith/git.edn")
  (println "                       if the CI variable is set.")
  (println)
  (println "    FLAG = +        -> Show time information.")
  (println "                       (the + sign may occur in any order in the argument list).")
  (println)
  (println "  'lein polylith diff 0' can be used to list all files in the workspace")
  (println "  (or at least changes since 1970-01-01).")
  (println)
  (println "  example:")
  (println "    lein polylith diff")
  (println "    lein polylith diff +")
  (if (shared/ci?)
    (println "    lein polylith diff + 7d7fd132412aad0f8d3019edfccd1e9d92a5a8ae")
    (println "    lein polylith diff + 1523649477000"))
  (if (shared/ci?)
    (println "    lein polylith diff 7d7fd132412aad0f8d3019edfccd1e9d92a5a8ae")
    (println "    lein polylith diff 1523649477000"))
  (println "    lein polylith diff 1523649477000 +")
  (println "    lein polylith diff mybookmark"))
