(ns leiningen.polylith.cmd.help.sync)

(defn help []
  (println "  These steps are performed:")
  (println)
  (println "  1. Adds missing libraries to the development environment.")
  (println "     The way it does that is to first check which components and bases")
  (println "     are part of the development environment. Then it goes through")
  (println "     those components and bases and collects a list of all their dependencies")
  (println "     from each project.clj file. That list is compared with the dependencies")
  (println "     in environments/development/project.clj and missing libraries are added.")
  (println)
  (println "  2. Makes sure that the library versions for all components")
  (println "     and bases are in sync with the library versions in")
  (println "     environments/development/project.clj.")
  (println)
  (println "  3. Makes sure that each system has a library list that reflects")
  (println "     the sum of all libraries of its components and bases.")
  (println)
  (println "  4. Adds missing components to systems if possible/needed.")
  (println "     This can be performed only if each interface belongs to exactly")
  (println "     one component, otherwise an error message is displayed.")
  (println)
  (println "  5. Adds missing def/defn/defmacro definitions to workspace interfaces.")
  (println "     All namespaces for each interface under the interfaces directory are")
  (println "     parsed and all def/defn/defmacro definitions are collected into a set.")
  (println "     Then all def/defn/defmacro definitions, that exist in the corresponding")
  (println "     component interface(s) but not in the workspace interface, are added.")
  (println "     If a new arity of a function or macro has been added or changed,")
  (println "     then an error message is shown, informing you to update it manually.")
  (println)
  (println "  example:")
  (println "    lein polylith sync"))
