/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.LoaderContext;
import clojure.lang.Util;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLClassLoader;

public class DynamicClassLoader
extends URLClassLoader {
    static final URL[] EMPTY_URLS = new URL[0];
    protected final LoaderContext context;

    public DynamicClassLoader(ClassLoader parent) {
        this(EMPTY_URLS, parent);
    }

    public DynamicClassLoader(URL[] urls, ClassLoader parent) {
        this(urls, parent, parent instanceof DynamicClassLoader ? ((DynamicClassLoader)parent).context : LoaderContext.ROOT);
    }

    public DynamicClassLoader(URL[] urls, ClassLoader parent, LoaderContext loaderContext) {
        super(urls, parent);
        this.context = loaderContext;
    }

    @Override
    public void close() throws IOException {
        this.context.namespaces.clear();
        this.context.classCache.clear();
        super.close();
    }

    public Class defineClass(String name, byte[] bytes, Object srcForm) {
        Util.clearCache(this.context.classCacheReferenceQueue, this.context.classCache);
        Class<?> c = this.defineClass(name, bytes, 0, bytes.length);
        this.context.classCache.put(name, new SoftReference(c, this.context.classCacheReferenceQueue));
        return c;
    }

    public static Class<?> findInMemoryClass(LoaderContext context, String name) {
        Reference<Class> cr = context.classCache.get(name);
        if (cr != null) {
            Class c = cr.get();
            if (c != null) {
                return c;
            }
            context.classCache.remove(name, cr);
        }
        return null;
    }

    public static Class<?> findInMemoryClass(String name) {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        LoaderContext lc = null;
        do {
            if (ccl instanceof DynamicClassLoader) {
                lc = ((DynamicClassLoader)ccl).context;
                continue;
            }
            if ((ccl = ccl.getParent()) != null) continue;
            lc = LoaderContext.ROOT;
        } while (lc == null);
        return DynamicClassLoader.findInMemoryClass(lc, name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> c = DynamicClassLoader.findInMemoryClass(this.context, name);
        if (c != null) {
            return c;
        }
        return super.findClass(name);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null && (c = DynamicClassLoader.findInMemoryClass(this.context, name)) == null) {
            c = super.loadClass(name, false);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public void registerConstants(int id, Object[] val) {
        this.context.constantVals.put(id, val);
    }

    public Object[] getConstants(int id) {
        return this.context.constantVals.get(id);
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    static {
        DynamicClassLoader.registerAsParallelCapable();
    }
}

