/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.DynamicClassLoader;
import clojure.lang.IPersistentMap;
import clojure.lang.Namespace;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class LoaderContext {
    public static final LoaderContext ROOT = new LoaderContext();
    public final HashMap<Integer, Object[]> constantVals = new HashMap();
    public final ConcurrentHashMap<Symbol, Namespace> namespaces = new ConcurrentHashMap();
    public final ConcurrentHashMap<String, Reference<Class>> classCache = new ConcurrentHashMap();
    public final ReferenceQueue classCacheReferenceQueue = new ReferenceQueue();

    public static LoaderContext get() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl instanceof DynamicClassLoader ? ((DynamicClassLoader)cl).context : ROOT;
    }

    public String toString() {
        if (this == ROOT) {
            return "(LoaderContext/ROOT with namespaces: " + this.namespaces + ")";
        }
        return "(" + super.toString() + " with namespaces: " + this.namespaces.keySet() + ")";
    }

    public LoaderContext() {
        if (RT.CLOJURE_NS != null) {
            Symbol loadedLibs = Symbol.intern("*loaded-libs*");
            Var loadedLibsVar = (Var)RT.CLOJURE_NS.getMappings().valAt(loadedLibs);
            if (loadedLibsVar != null) {
                ConcurrentHashMap<Symbol, Namespace> root = LoaderContext.ROOT.namespaces;
                Namespace copy = root.get(Symbol.intern("clojure.core.protocols"));
                this.namespaces.put(copy.name, copy);
                copy = root.get(Symbol.intern("clojure.instant"));
                this.namespaces.put(copy.name, copy);
                copy = root.get(Symbol.intern("clojure.uuid"));
                this.namespaces.put(copy.name, copy);
                copy = root.get(Symbol.intern("clojure.string"));
                this.namespaces.put(copy.name, copy);
                copy = root.get(Symbol.intern("clojure.java.io"));
                this.namespaces.put(copy.name, copy);
            }
        }
    }

    public IPersistentMap injectNamespaces(LoaderContext from, String nameRegex) {
        IPersistentMap injected = RT.map(new Object[0]);
        if (from != this) {
            for (Map.Entry<Symbol, Namespace> ns : from.namespaces.entrySet()) {
                if (!ns.getKey().name.matches(nameRegex)) continue;
                this.namespaces.put(ns.getKey(), ns.getValue());
                injected = injected.assoc(ns.getKey(), ns.getValue());
            }
        }
        return injected;
    }
}

